/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation;

import de.uni_freiburg.informatik.ultimate.cdt.translation.LineDirectiveMapping;
import de.uni_freiburg.informatik.ultimate.cdt.translation.LineOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.ACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CLocation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;

public class LocationFactory {
    private final LineDirectiveMapping mLineDirectiveMapping;
    private final LineOffsetComputer mLineOffsetComputer;

    public LocationFactory(LineDirectiveMapping lineDirectiveMapping, LineOffsetComputer lineOffsetComputer) {
        this.mLineDirectiveMapping = lineDirectiveMapping;
        this.mLineOffsetComputer = lineOffsetComputer;
    }

    public ILocation createRootCLocation(Set<IASTTranslationUnit> set) {
        return new CACSLProjectLocation(set);
    }

    public CACSLLocation createCLocation(IASTNode iASTNode) {
        return new CLocation(iASTNode, false, this.mLineDirectiveMapping, this.mLineOffsetComputer);
    }

    public static CACSLLocation createIgnoreCLocation(IASTNode iASTNode) {
        return new CLocation(iASTNode, true, null, null);
    }

    public static CACSLLocation createIgnoreCLocation() {
        return LocationFactory.createIgnoreCLocation(null);
    }

    public CACSLLocation createACSLLocation(ACSLNode aCSLNode) {
        return new ACSLLocation(aCSLNode, false);
    }

    public static CACSLLocation createLocation(CACSLLocation cACSLLocation) {
        if (cACSLLocation instanceof ACSLLocation) {
            ACSLLocation aCSLLocation = (ACSLLocation)cACSLLocation;
            return new ACSLLocation(aCSLLocation.getNode(), aCSLLocation.ignoreDuringBacktranslation());
        }
        if (cACSLLocation instanceof CLocation) {
            CLocation cLocation = (CLocation)cACSLLocation;
            return cLocation.copy();
        }
        throw new UnsupportedOperationException();
    }

    public static CACSLLocation createIgnoreLocation(ILocation iLocation) {
        if (iLocation instanceof ACSLLocation) {
            ACSLLocation aCSLLocation = (ACSLLocation)iLocation;
            return new ACSLLocation(aCSLLocation.getNode(), true);
        }
        if (iLocation instanceof CLocation) {
            CLocation cLocation = (CLocation)iLocation;
            return cLocation.createIgnoreCopy();
        }
        throw new UnsupportedOperationException();
    }

    private static final class CACSLProjectLocation
    extends DefaultLocation {
        private static final long serialVersionUID = -7960532970979883689L;
        private final Set<String> mFilenames;

        public CACSLProjectLocation(Set<IASTTranslationUnit> set) {
            super(((IASTTranslationUnit)Objects.requireNonNull(set).stream().findAny().orElseThrow(() -> new IllegalArgumentException("set is empty"))).getFilePath(), -1, -1, -1, -1);
            this.mFilenames = Collections.unmodifiableSet(set.stream().map(iASTTranslationUnit -> iASTTranslationUnit.getFilePath()).collect(Collectors.toSet()));
        }

        public Set<String> getFilenames() {
            return this.mFilenames;
        }

        public IAnnotations merge(IAnnotations iAnnotations) {
            if (iAnnotations == null) {
                return this;
            }
            if (iAnnotations == this) {
                return this;
            }
            return super.merge(iAnnotations);
        }
    }
}

