/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public abstract sealed class Specification
extends BoogieASTNode
permits LoopInvariantSpecification, EnsuresSpecification, ModifiesSpecification, RequiresSpecification {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Specification.class);
    ILocation loc;
    boolean isFree;

    public Specification(ILocation iLocation, boolean bl) {
        super(iLocation);
        this.loc = iLocation;
        this.isFree = bl;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Specification: " + String.valueOf((Object)this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Specification").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',').append(this.isFree);
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public boolean isFree() {
        return this.isFree;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public abstract void accept(GeneratedBoogieAstVisitor var1);

    public abstract Specification accept(GeneratedBoogieAstTransformer var1);
}

