/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree;

import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISemanticReducerFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeRun;
import de.uni_freiburg.informatik.ultimate.automata.tree.InterpolantTreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.Tree;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TreeRun<LETTER extends IRankedLetter, STATE>
implements ITreeRun<LETTER, STATE> {
    private final STATE mState;
    private final LETTER mLetter;
    private final List<TreeRun<LETTER, STATE>> mChildren;
    private final Collection<STATE> mAllStates;
    private final Collection<TreeAutomatonRule<LETTER, STATE>> mAllRules;

    public TreeRun(STATE STATE) {
        this(STATE, null, new ArrayList<TreeRun<LETTER, STATE>>());
    }

    public TreeRun(STATE STATE, LETTER LETTER, List<TreeRun<LETTER, STATE>> list) {
        this.mState = STATE;
        this.mLetter = LETTER;
        this.mChildren = list;
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashSet<TreeAutomatonRule<LETTER, STATE>> hashSet2 = new HashSet<TreeAutomatonRule<LETTER, STATE>>();
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (TreeRun<LETTER, STATE> treeRun : list) {
            hashSet.addAll(treeRun.getStates());
            arrayList.add(treeRun.getRoot());
            hashSet2.addAll(treeRun.getRules());
        }
        if (this.mLetter != null) {
            hashSet2.add(new TreeAutomatonRule(this.mLetter, arrayList, STATE));
        }
        hashSet.add(this.mState);
        this.mAllStates = Collections.unmodifiableSet(hashSet);
        this.mAllRules = Collections.unmodifiableSet(hashSet2);
        assert (!this.mAllStates.stream().anyMatch(Objects::isNull));
    }

    public <ST> TreeRun<LETTER, ST> reconstruct(Map<STATE, ST> map) {
        ArrayList<TreeRun<LETTER, STATE>> arrayList = new ArrayList<TreeRun<LETTER, STATE>>();
        for (TreeRun<LETTER, STATE> treeRun : this.mChildren) {
            arrayList.add(treeRun.reconstruct(map));
        }
        return new TreeRun<LETTER, Object>((map.containsKey(this.mState) ? (STATE)map.get(this.mState) : null), this.mLetter, arrayList);
    }

    public <ST> TreeRun<LETTER, ST> reconstructViaSubtrees(Map<TreeRun<LETTER, STATE>, ST> map) {
        ArrayList<TreeRun<LETTER, STATE>> arrayList = new ArrayList<TreeRun<LETTER, STATE>>();
        for (TreeRun<LETTER, STATE> treeRun : this.mChildren) {
            arrayList.add(treeRun.reconstructViaSubtrees(map));
        }
        if (map.get(this) == null) {
            return this;
        }
        return new TreeRun<LETTER, ST>(map.get(this), this.mLetter, arrayList);
    }

    public List<TreeRun<LETTER, STATE>> getChildren() {
        return this.mChildren;
    }

    private Collection<TreeAutomatonRule<LETTER, STATE>> getRules() {
        return this.mAllRules;
    }

    private Collection<STATE> getStates() {
        return this.mAllStates;
    }

    @Override
    public <SF extends ISemanticReducerFactory<STATE, LETTER>> InterpolantTreeAutomatonBU<LETTER, STATE> getInterpolantAutomaton(SF SF) {
        InterpolantTreeAutomatonBU interpolantTreeAutomatonBU = new InterpolantTreeAutomatonBU(SF);
        for (STATE object : this.getStates()) {
            interpolantTreeAutomatonBU.addState(object);
        }
        interpolantTreeAutomatonBU.addFinalState(this.mState);
        for (TreeAutomatonRule treeAutomatonRule : this.getRules()) {
            interpolantTreeAutomatonBU.addRule(treeAutomatonRule);
        }
        return interpolantTreeAutomatonBU;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getAutomaton() {
        TreeAutomatonBU treeAutomatonBU = new TreeAutomatonBU();
        for (STATE object : this.getStates()) {
            treeAutomatonBU.addState(object);
        }
        treeAutomatonBU.addFinalState(this.mState);
        for (TreeAutomatonRule treeAutomatonRule : this.getRules()) {
            treeAutomatonBU.addRule(treeAutomatonRule);
        }
        return treeAutomatonBU;
    }

    @Override
    public Tree<LETTER> getTree() {
        ArrayList arrayList = new ArrayList();
        for (TreeRun<LETTER, STATE> treeRun : this.mChildren) {
            arrayList.add(treeRun.getTree());
        }
        return new Tree<LETTER>(this.mLetter, arrayList);
    }

    @Override
    public STATE getRoot() {
        return this.mState;
    }

    @Override
    public LETTER getRootSymbol() {
        return this.mLetter;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TreeRun<LETTER, STATE> treeRun : this.mChildren) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(treeRun.toString());
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(")");
        }
        return String.format("%s[%s]%s", this.mLetter, this.mState, stringBuilder);
    }
}

