/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.AddSymbols;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.CommuHashPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.DNF;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.MatchInOutVars;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RemoveNegation;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteBooleans;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteDivision;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteEquality;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteIte;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteStrictInequalities;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTrueFalse;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteUserDefinedTypes;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.SimplifyPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.ILassoRankerPreferences;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.GeometricNonTerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.INonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.nontermination.NonTerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPartitioneerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.MapEliminationLassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.RewriteArrays2;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.StemAndLoopPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.NonterminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisSettings;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgumentSynthesizer;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.DebugMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LassoAnalysis {
    private final ILogger mLogger;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final UnmodifiableTransFormula mStemTransition;
    private final UnmodifiableTransFormula mLoopTransition;
    private Collection<Lasso> mLassos;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;
    protected final SmtFunctionsAndAxioms mSmtSymbols;
    protected final ILassoRankerPreferences mPreferences;
    protected final Set<Term> mArrayIndexSupportingInvariants;
    private final IIcfgSymbolTable mSymbolTable;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final List<TerminationAnalysisBenchmark> mLassoTerminationAnalysisBenchmarks;
    private final List<NonterminationAnalysisBenchmark> mLassoNonterminationAnalysisBenchmarks;
    private PreprocessingBenchmark mPreprocessingBenchmark;
    private final CfgSmtToolkit mCfgSmtToolkit;

    public LassoAnalysis(CfgSmtToolkit cfgSmtToolkit, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set, SmtFunctionsAndAxioms smtFunctionsAndAxioms, ILassoRankerPreferences iLassoRankerPreferences, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) throws TermException {
        this.mServices = iUltimateServiceProvider;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mLogger = this.mServices.getLoggingService().getLogger("Library-LassoRanker");
        this.mPreferences = iLassoRankerPreferences;
        this.mLogger.info((Object)"Preferences:");
        this.mPreferences.feedSettingsString(arg_0 -> ((ILogger)this.mLogger).info(arg_0));
        this.mSmtSymbols = smtFunctionsAndAxioms;
        this.mArrayIndexSupportingInvariants = new HashSet<Term>();
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mCfgSmtToolkit = cfgSmtToolkit;
        this.mSymbolTable = cfgSmtToolkit.getSymbolTable();
        this.mLassoTerminationAnalysisBenchmarks = new ArrayList<TerminationAnalysisBenchmark>();
        this.mLassoNonterminationAnalysisBenchmarks = new ArrayList<NonterminationAnalysisBenchmark>();
        this.mStemTransition = unmodifiableTransFormula;
        this.mLoopTransition = unmodifiableTransFormula2;
        this.mModifiableGlobalsAtHonda = set;
        assert (this.mLoopTransition != null);
        this.preprocess();
    }

    protected void preprocess() throws TermException {
        this.mLogger.info((Object)"Starting lasso preprocessing...");
        LassoBuilder lassoBuilder = new LassoBuilder(this.mLogger, this.mCfgSmtToolkit, this.mStemTransition, this.mLoopTransition, this.mPreferences.getNlaHandling());
        assert (lassoBuilder.isSane("initial lasso construction"));
        lassoBuilder.preprocess(this.getPreProcessors(lassoBuilder, this.mPreferences.isOverapproximateArrayIndexConnection()), this.getPreProcessors(lassoBuilder, false));
        this.mPreprocessingBenchmark = lassoBuilder.getPreprocessingBenchmark();
        lassoBuilder.constructPolyhedra();
        this.mLassos = lassoBuilder.getLassos();
        this.mLogger.debug((Object)new DebugMessage("Original stem:\n{0}", new Object[]{this.mStemTransition}));
        this.mLogger.debug((Object)new DebugMessage("Original loop:\n{0}", new Object[]{this.mLoopTransition}));
        this.mLogger.debug((Object)new DebugMessage("After preprocessing:\n{0}", new Object[]{lassoBuilder}));
        this.mLogger.debug((Object)("Guesses for Motzkin coefficients: " + LassoAnalysis.eigenvalueGuesses(this.mLassos)));
        this.mLogger.info((Object)"Preprocessing complete.");
    }

    protected LassoPreprocessor[] getPreProcessors(LassoBuilder lassoBuilder, boolean bl) {
        LassoPreprocessor lassoPreprocessor = this.mPreferences.isUseOldMapElimination() ? new RewriteArrays2(true, this.mStemTransition, this.mLoopTransition, this.mModifiableGlobalsAtHonda, this.mServices, this.mArrayIndexSupportingInvariants, this.mSymbolTable, this.mMgdScript, lassoBuilder.getReplacementVarFactory(), this.mSimplificationTechnique) : new MapEliminationLassoPreprocessor(this.mServices, this.mMgdScript, this.mSymbolTable, lassoBuilder.getReplacementVarFactory(), this.mStemTransition, this.mLoopTransition, this.mModifiableGlobalsAtHonda, this.mArrayIndexSupportingInvariants, this.mPreferences.getMapEliminationSettings(this.mSimplificationTechnique));
        return new LassoPreprocessor[]{new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new MatchInOutVars()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new AddSymbols(lassoBuilder.getReplacementVarFactory(), this.mSmtSymbols)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new CommuHashPreprocessor(this.mServices)), this.mPreferences.isEnablePartitioneer() ? new LassoPartitioneerPreprocessor(this.mMgdScript, this.mServices) : null, lassoPreprocessor, new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new MatchInOutVars()), this.mPreferences.isEnablePartitioneer() ? new LassoPartitioneerPreprocessor(this.mMgdScript, this.mServices) : null, new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteDivision(lassoBuilder.getReplacementVarFactory())), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteBooleans(lassoBuilder.getReplacementVarFactory(), this.mMgdScript)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteIte()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteUserDefinedTypes(lassoBuilder.getReplacementVarFactory(), this.mMgdScript)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteEquality()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new CommuHashPreprocessor(this.mServices)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new DNF(this.mServices)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new SimplifyPreprocessor(this.mServices, this.mSimplificationTechnique)), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteTrueFalse()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RemoveNegation()), new StemAndLoopPreprocessor(this.mMgdScript, (TransitionPreprocessor)new RewriteStrictInequalities())};
    }

    public Collection<Lasso> getLassos() {
        return this.mLassos;
    }

    public List<TerminationAnalysisBenchmark> getTerminationAnalysisBenchmarks() {
        return this.mLassoTerminationAnalysisBenchmarks;
    }

    public List<NonterminationAnalysisBenchmark> getNonterminationAnalysisBenchmarks() {
        return this.mLassoNonterminationAnalysisBenchmarks;
    }

    public PreprocessingBenchmark getPreprocessingBenchmark() {
        return this.mPreprocessingBenchmark;
    }

    protected String benchmarkScriptMessage(Script.LBool lBool, RankingTemplate rankingTemplate) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("BenchmarkResult: ");
        stringBuilder.append(lBool);
        stringBuilder.append(" for template ");
        stringBuilder.append(rankingTemplate.getName());
        stringBuilder.append(" with degree ");
        stringBuilder.append(rankingTemplate.getDegree());
        stringBuilder.append(". ");
        stringBuilder.append(this.mLassoTerminationAnalysisBenchmarks.toString());
        return stringBuilder.toString();
    }

    protected static String eigenvalueGuesses(Collection<Lasso> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (Lasso lasso : collection) {
            Rational[] rationalArray = lasso.guessEigenvalues(true);
            int n = 0;
            while (n < rationalArray.length) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(rationalArray[n].toString());
                ++n;
            }
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public GeometricNonTerminationArgument checkNonTermination(NonTerminationAnalysisSettings nonTerminationAnalysisSettings) throws SMTLIBException, TermException, IOException {
        void var3_7;
        this.mLogger.info((Object)"Checking for nontermination...");
        ArrayList<GeometricNonTerminationArgument> arrayList = new ArrayList<GeometricNonTerminationArgument>(this.mLassos.size());
        if (this.mLassos.isEmpty()) {
            this.mLassos.add(new Lasso(LinearTransition.getTranstionTrue(), LinearTransition.getTranstionTrue()));
        }
        for (Lasso serializable2 : this.mLassos) {
            GeometricNonTerminationArgument geometricNonTerminationArgument;
            Script.LBool lBool;
            NonTerminationArgumentSynthesizer nonTerminationArgumentSynthesizer;
            long l = System.nanoTime();
            NonTerminationAnalysisSettings nonTerminationAnalysisSettings2 = LassoAnalysis.constructGev0Copy(nonTerminationAnalysisSettings);
            Throwable throwable = null;
            Object var11_17 = null;
            try {
                nonTerminationArgumentSynthesizer = new NonTerminationArgumentSynthesizer(serializable2, this.mPreferences, nonTerminationAnalysisSettings2, this.mServices);
                try {
                    lBool = nonTerminationArgumentSynthesizer.synthesize();
                    geometricNonTerminationArgument = lBool == Script.LBool.SAT ? nonTerminationArgumentSynthesizer.getArgument() : null;
                }
                finally {
                    if (nonTerminationArgumentSynthesizer != null) {
                        nonTerminationArgumentSynthesizer.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (lBool == Script.LBool.UNSAT) {
                throwable = null;
                var11_17 = null;
                try {
                    nonTerminationArgumentSynthesizer = new NonTerminationArgumentSynthesizer(serializable2, this.mPreferences, nonTerminationAnalysisSettings, this.mServices);
                    try {
                        lBool = nonTerminationArgumentSynthesizer.synthesize();
                        geometricNonTerminationArgument = lBool == Script.LBool.SAT ? nonTerminationArgumentSynthesizer.getArgument() : null;
                    }
                    finally {
                        if (nonTerminationArgumentSynthesizer != null) {
                            nonTerminationArgumentSynthesizer.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            long l2 = System.nanoTime();
            boolean bl = lBool == Script.LBool.SAT ? geometricNonTerminationArgument.getLambdas().isEmpty() || geometricNonTerminationArgument.getGEVs().isEmpty() : false;
            NonterminationAnalysisBenchmark nonterminationAnalysisBenchmark = new NonterminationAnalysisBenchmark(lBool, bl, serializable2.getStemVarNum(), serializable2.getLoopVarNum(), serializable2.getStemDisjuncts(), serializable2.getLoopDisjuncts(), l2 - l);
            this.mLassoNonterminationAnalysisBenchmarks.add(nonterminationAnalysisBenchmark);
            if (lBool == Script.LBool.SAT) {
                this.mLogger.info((Object)"Proved nontermination for one component.");
                arrayList.add(geometricNonTerminationArgument);
                this.mLogger.info((Object)geometricNonTerminationArgument);
            } else if (lBool == Script.LBool.UNKNOWN) {
                this.mLogger.info((Object)"Proving nontermination failed: SMT Solver returned 'unknown'.");
            } else if (lBool == Script.LBool.UNSAT) {
                this.mLogger.info((Object)"Proving nontermination failed: No geometric nontermination argument exists.");
            } else assert (false);
            if (lBool == Script.LBool.SAT) continue;
            return null;
        }
        assert (!arrayList.isEmpty());
        GeometricNonTerminationArgument geometricNonTerminationArgument = (GeometricNonTerminationArgument)arrayList.get(0);
        int n = 1;
        while (n < arrayList.size()) {
            GeometricNonTerminationArgument geometricNonTerminationArgument2 = var3_7.join((GeometricNonTerminationArgument)arrayList.get(n));
            ++n;
        }
        return var3_7;
    }

    private static NonTerminationAnalysisSettings constructGev0Copy(INonTerminationAnalysisSettings iNonTerminationAnalysisSettings) {
        return new NonTerminationAnalysisSettings(new NonTerminationAnalysisSettings(iNonTerminationAnalysisSettings){
            private static final long serialVersionUID = 1L;

            @Override
            public int getNumberOfGevs() {
                return 0;
            }
        });
    }

    public TerminationArgument tryTemplate(RankingTemplate rankingTemplate, TerminationAnalysisSettings terminationAnalysisSettings) throws SMTLIBException, TermException, IOException {
        this.mLogger.info((Object)("Using template '" + rankingTemplate.getName() + "'."));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)rankingTemplate);
        }
        for (Lasso lasso : this.mLassos) {
            TerminationArgument terminationArgument;
            Script.LBool lBool;
            long l = System.nanoTime();
            Term[] termArray = null;
            Term term = null;
            try (TerminationArgumentSynthesizer terminationArgumentSynthesizer = new TerminationArgumentSynthesizer(lasso, rankingTemplate, this.mPreferences, terminationAnalysisSettings, this.mArrayIndexSupportingInvariants, this.mServices);){
                lBool = terminationArgumentSynthesizer.synthesize();
                long l2 = System.nanoTime();
                TerminationAnalysisBenchmark terminationAnalysisBenchmark = new TerminationAnalysisBenchmark(lBool, lasso.getStemVarNum(), lasso.getLoopVarNum(), lasso.getStemDisjuncts(), lasso.getLoopDisjuncts(), rankingTemplate.getName(), rankingTemplate.getDegree(), terminationArgumentSynthesizer.getNumSIs(), terminationArgumentSynthesizer.getNumMotzkin(), l2 - l);
                this.mLassoTerminationAnalysisBenchmarks.add(terminationAnalysisBenchmark);
                terminationArgument = lBool == Script.LBool.SAT ? terminationArgumentSynthesizer.getArgument() : null;
            }
            catch (Throwable object) {
                if (termArray == null) {
                    termArray = object;
                } else if (termArray != object) {
                    termArray.addSuppressed((Throwable)object);
                }
                throw termArray;
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)this.benchmarkScriptMessage(lBool, rankingTemplate));
            }
            if (lBool == Script.LBool.SAT) {
                this.mLogger.info((Object)"Proved termination.");
                this.mLogger.info((Object)terminationArgument);
                if (this.mLogger.isDebugEnabled()) {
                    Term[] termArray2 = termArray = terminationArgument.getRankingFunction().asLexTerm(this.mMgdScript.getScript());
                    int n = termArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        term = termArray2[n2];
                        this.mLogger.debug((Object)new DebugMessage("{0}", new Object[]{new SMTPrettyPrinter(term)}));
                        ++n2;
                    }
                }
                return terminationArgument;
            }
            if (lBool == Script.LBool.UNKNOWN) {
                this.mLogger.info((Object)"Proving termination failed: SMT Solver returned 'unknown'.");
                continue;
            }
            if (lBool == Script.LBool.UNSAT) {
                this.mLogger.info((Object)"Proving termination failed for this template and these settings.");
                continue;
            }
            assert (false);
        }
        return null;
    }

    public static enum AnalysisTechnique {
        RANKING_FUNCTIONS_SUPPORTING_INVARIANTS,
        GEOMETRIC_NONTERMINATION_ARGUMENTS;

    }

    public static class PreprocessingBenchmark {
        private final int mIntialMaxDagSizeLassos;
        private final List<String> mPreprocessors = new ArrayList<String>();
        private final List<Integer> mMaxDagSizeLassosAbsolut = new ArrayList<Integer>();
        private final List<Float> mMaxDagSizeLassosRelative = new ArrayList<Float>();

        public PreprocessingBenchmark(long l) {
            this.mIntialMaxDagSizeLassos = Math.toIntExact(l);
        }

        public void addPreprocessingData(String string, int n, int n2) {
            this.mPreprocessors.add(string);
            this.mMaxDagSizeLassosAbsolut.add(n2);
            this.mMaxDagSizeLassosRelative.add(Float.valueOf(this.computeQuotiontOfLastTwoEntries(this.mMaxDagSizeLassosAbsolut, this.mIntialMaxDagSizeLassos)));
        }

        public void addPreprocessingData(String string, long l) {
            this.mPreprocessors.add(string);
            this.mMaxDagSizeLassosAbsolut.add(Math.toIntExact(l));
            this.mMaxDagSizeLassosRelative.add(Float.valueOf(this.computeQuotiontOfLastTwoEntries(this.mMaxDagSizeLassosAbsolut, this.mIntialMaxDagSizeLassos)));
        }

        public float computeQuotiontOfLastTwoEntries(List<Integer> list, int n) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException();
            }
            double d = list.get(list.size() - 1).intValue();
            double d2 = list.size() == 1 ? (double)n : (double)list.get(list.size() - 2).intValue();
            return (float)(d / d2);
        }

        public int getIntialMaxDagSizeLassos() {
            return this.mIntialMaxDagSizeLassos;
        }

        public List<String> getPreprocessors() {
            return this.mPreprocessors;
        }

        public List<String> getPreprocessorsNon() {
            return this.mPreprocessors;
        }

        public List<Float> getMaxDagSizeLassosRelative() {
            return this.mMaxDagSizeLassosRelative;
        }

        public static String prettyprint(List<PreprocessingBenchmark> list) {
            if (list.isEmpty()) {
                return "";
            }
            List<String> list2 = list.get(0).getPreprocessors();
            List<String> list3 = PreprocessingBenchmark.computeAbbrev(list2);
            float[] fArray = new float[list2.size()];
            int n = 0;
            for (PreprocessingBenchmark object2 : list) {
                PreprocessingBenchmark.addListElements(fArray, object2.getMaxDagSizeLassosRelative());
                n += object2.getIntialMaxDagSizeLassos();
            }
            PreprocessingBenchmark.divideAllEntries(fArray, list.size());
            n /= list.size();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("  ");
            stringBuilder.append("Lassos: ");
            stringBuilder.append("inital");
            stringBuilder.append(n);
            stringBuilder.append(" ");
            stringBuilder.append(PreprocessingBenchmark.ppOne(fArray, list3));
            return stringBuilder.toString();
        }

        private static List<String> computeAbbrev(List<String> list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                arrayList.add(PreprocessingBenchmark.computeAbbrev(string));
            }
            return arrayList;
        }

        private static String computeAbbrev(String string) {
            switch (string) {
                case "Transform into disjunctive normal form": {
                    return "dnf";
                }
                case "Simplify formula using some simplification technique": {
                    return "smp";
                }
                case "Removes arrays by introducing new variables for each relevant array cell": {
                    return "arr";
                }
                case "Replaces a = b with (a <= b /\\ a >= b) and a != b with (a > b \\/ a < b)": {
                    return "eq";
                }
                case "Replace strict inequalities by non-strict inequalities": {
                    return "sie";
                }
                case "LassoPartitioneer": {
                    return "lsp";
                }
                case "Remove negation before atoms": {
                    return "neg";
                }
                case "Replace integer division by equivalent linear constraints": {
                    return "div";
                }
                case "Replace boolean variables by integer variables": {
                    return "bol";
                }
                case "Add a corresponding inVars and outVars": {
                    return "mio";
                }
                case "Replace 'true' with '0 >= 0' and 'false' with '0 >= 1'": {
                    return "tf";
                }
                case "Remove if-then-else terms.": {
                    return "ite";
                }
                case "Add axioms to the transition": {
                    return "ax";
                }
                case "Simplify formula using CommuhashNormalForm": {
                    return "hnf";
                }
            }
            return "ukn";
        }

        private static String ppOne(float[] fArray, List<String> list) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < fArray.length) {
                stringBuilder.append(list.get(n));
                stringBuilder.append(String.valueOf(PreprocessingBenchmark.makePercent(fArray[n])));
                stringBuilder.append(" ");
                ++n;
            }
            return stringBuilder.toString();
        }

        private static int makePercent(float f) {
            return (int)Math.floor((double)f * 100.0);
        }

        private static void addListElements(float[] fArray, List<Float> list) {
            assert (fArray.length == list.size());
            int n = 0;
            while (n < fArray.length) {
                int n2 = n;
                fArray[n2] = fArray[n2] + list.get(n).floatValue();
                ++n;
            }
        }

        private static void divideAllEntries(float[] fArray, int n) {
            int n2 = 0;
            while (n2 < fArray.length) {
                int n3 = n2++;
                fArray[n3] = fArray[n3] / (float)n;
            }
        }
    }
}

