/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.HashMap;
import java.util.Map;

public class AutomatonEpimorphism<STATE> {
    private static final String INVALID_STATE_NAME_MESSAGE = "Invalid state name: ";
    private final ILogger mLogger;
    private final Map<STATE, STATE> mEpimorphism;

    public AutomatonEpimorphism(AutomataLibraryServices automataLibraryServices) {
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mEpimorphism = new HashMap<STATE, STATE>();
    }

    public static AutomatonEpimorphism<String> createFromAutomatonLabels(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<String, String> iNestedWordAutomaton, INestedWordAutomaton<String, String> iNestedWordAutomaton2) {
        AutomatonEpimorphism<String> automatonEpimorphism = new AutomatonEpimorphism<String>(automataLibraryServices);
        for (String string : iNestedWordAutomaton.getStates()) {
            int n = string.indexOf(95);
            if (n == -1) continue;
            if (n + 1 == string.length()) {
                throw new IllegalArgumentException(INVALID_STATE_NAME_MESSAGE + string);
            }
            String string2 = string.substring(n + 1);
            if (string2.indexOf(95) != -1) {
                throw new IllegalArgumentException(INVALID_STATE_NAME_MESSAGE + string);
            }
            if (!iNestedWordAutomaton2.getStates().contains(string2)) {
                throw new IllegalArgumentException("Missing epimorphism partner for: " + string);
            }
            automatonEpimorphism.mEpimorphism.put(string, string2);
        }
        return automatonEpimorphism;
    }

    public STATE getMapping(STATE STATE) {
        return this.mEpimorphism.get(STATE);
    }

    public void insert(STATE STATE, STATE STATE2) {
        this.mEpimorphism.put(STATE, STATE2);
    }

    public void print() {
        if (this.mLogger.isDebugEnabled()) {
            for (Map.Entry<STATE, STATE> entry : this.mEpimorphism.entrySet()) {
                this.mLogger.debug((Object)(String.valueOf(entry.getKey()) + " --> " + String.valueOf(entry.getValue())));
            }
        }
    }
}

