/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;

public class BooleanOption
extends Option {
    private boolean mValue;
    private boolean mDefaultValue;

    public BooleanOption(boolean bl, boolean bl2, String string) {
        super(bl2, string);
        this.mValue = this.mDefaultValue = bl;
    }

    public BooleanOption(BooleanOption booleanOption) {
        super(booleanOption.isOnlineModifiable(), booleanOption.getDescription());
        this.mValue = booleanOption.mValue;
        this.mDefaultValue = booleanOption.mDefaultValue;
    }

    @Override
    public Option copy() {
        return new BooleanOption(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void set(Object object) {
        if (object instanceof Boolean) {
            this.mValue = (Boolean)object;
            return;
        } else {
            if (!(object instanceof String)) throw new SMTLIBException("Not a Boolean value: " + String.valueOf(object));
            String string = (String)object;
            if ("true".equalsIgnoreCase(string)) {
                this.mValue = true;
                return;
            } else {
                if (!"false".equalsIgnoreCase(string)) throw new SMTLIBException("Not a Boolean value: " + String.valueOf(object));
                this.mValue = false;
            }
        }
    }

    public final boolean getValue() {
        return this.mValue;
    }

    @Override
    public Object get() {
        return this.mValue;
    }

    @Override
    public void reset() {
        this.mValue = this.mDefaultValue;
    }

    @Override
    public Object defaultValue() {
        return this.mDefaultValue;
    }

    @Override
    public void started() {
        this.mDefaultValue = this.mValue;
    }
}

