/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtochc;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcCategoryInfo;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.ChcProviderForCalls;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent.ChcProviderConcurrentWithLbe;
import java.util.ArrayList;
import java.util.Collection;

public class IcfgToChcObserver
extends BaseObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IElement mResult;
    private static final boolean USE_LBE_FOR_CONCURRENT_PROGRAMS = true;

    public IcfgToChcObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public IElement getModel() {
        return this.mResult;
    }

    public boolean process(IElement iElement) throws Exception {
        if (iElement instanceof IIcfg) {
            this.processIcfg((IIcfg<IcfgLocation>)((IIcfg)iElement));
            return false;
        }
        return true;
    }

    private void processIcfg(IIcfg<IcfgLocation> iIcfg) {
        ManagedScript managedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        HcSymbolTable hcSymbolTable = new HcSymbolTable(managedScript);
        Collection<HornClause> collection = this.getChcProvider(iIcfg, managedScript, hcSymbolTable).getHornClauses(iIcfg);
        boolean bl = IcfgToChcObserver.isReturnReachable(iIcfg);
        boolean bl2 = bl || !IcfgUtils.getForksInLoop(iIcfg).isEmpty();
        ChcCategoryInfo chcCategoryInfo = new ChcCategoryInfo(this.getLogics(collection, managedScript), bl2);
        assert (collection.stream().allMatch(hornClause -> hornClause.constructFormula(managedScript, false).getFreeVars().length == 0));
        HornAnnot hornAnnot = new HornAnnot(iIcfg.getIdentifier(), managedScript, hcSymbolTable, new ArrayList<HornClause>(collection), true, chcCategoryInfo);
        this.mResult = HornClauseAST.create((HornAnnot)hornAnnot);
        ModelUtils.copyAnnotations(iIcfg, (IElement)this.mResult);
    }

    private Logics getLogics(Collection<HornClause> collection, ManagedScript managedScript) {
        boolean bl;
        TermClassifier termClassifier = new TermClassifier();
        collection.forEach(hornClause -> termClassifier.checkTerm(hornClause.constructFormula(managedScript, false)));
        TermClassifier termClassifier2 = new TermClassifier();
        collection.forEach(hornClause -> termClassifier2.checkTerm(hornClause.getConstraintFormula()));
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string : termClassifier.getOccuringSortNames()) {
            bl2 |= string.contains("Array");
            bl3 |= string.contains("Real");
            bl4 |= string.contains("Int");
        }
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (String string : termClassifier2.getOccuringSortNames()) {
            bl5 |= string.contains("Array");
            bl6 |= string.contains("Real");
            bl7 |= string.contains("Int");
        }
        assert (bl2 == bl5);
        assert (bl3 == bl6);
        assert (bl4 == bl7);
        boolean bl8 = bl = !termClassifier2.getOccuringQuantifiers().isEmpty();
        if (!bl2 && bl4 && !bl3 && !bl) {
            return Logics.QF_LIA;
        }
        if (!bl2 && !bl4 && bl3 && !bl) {
            return Logics.QF_LRA;
        }
        if (bl2 && bl4 && !bl3 && !bl) {
            return Logics.QF_ALIA;
        }
        return Logics.ALL;
    }

    private static boolean isReturnReachable(IIcfg<IcfgLocation> iIcfg) {
        return new IcfgEdgeIterator(iIcfg).asStream().anyMatch(IIcfgSummaryTransition.class::isInstance);
    }

    private IChcProvider getChcProvider(IIcfg<IcfgLocation> iIcfg, ManagedScript managedScript, HcSymbolTable hcSymbolTable) {
        if (IcfgUtils.isConcurrent(iIcfg)) {
            assert (!IcfgToChcObserver.isReturnReachable(iIcfg));
            return new ChcProviderConcurrentWithLbe(managedScript, hcSymbolTable, this.mServices);
        }
        return new ChcProviderForCalls(managedScript, hcSymbolTable);
    }

    public static interface IChcProvider {
        public Collection<HornClause> getHornClauses(IIcfg<IcfgLocation> var1);
    }
}

