/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaBasis;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackReceiver;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.TaskCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainExceptionWrapper;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskFileIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopLocalResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Dumper;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractCegarLoop<L extends IIcfgTransition<?>, A extends IAutomaton<L, IPredicate>> {
    private static final boolean DUMP_BIGGEST_AUTOMATON = false;
    private static final boolean DEBUG_KEEP_STORAGE = false;
    protected final ILogger mLogger;
    protected final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    protected final IIcfg<? extends IcfgLocation> mIcfg;
    protected final CfgSmtToolkit mCsToolkit;
    protected final PredicateFactory mPredicateFactory;
    protected final TAPreferences mPref;
    protected final Set<? extends IcfgLocation> mErrorLocs;
    protected int mIteration;
    protected IRun<L, ?> mCounterexample;
    protected A mAbstraction;
    protected IInterpolantGenerator<L> mInterpolantGenerator;
    protected NestedWordAutomaton<L, IPredicate> mInterpolAutomaton;
    protected IAutomaton<L, IPredicate> mArtifactAutomaton;
    protected final AutomatonDefinitionPrinter.Format mPrintAutomataLabeling;
    protected CegarLoopStatisticsGenerator mCegarLoopBenchmark;
    protected IUltimateServiceProvider mServices;
    protected final TaskIdentifier mTaskIdentifier;
    protected Dumper mDumper;
    private final DebugIdentifier mName;
    protected final CegarLoopResultBuilder mResultBuilder;
    private Map<IcfgLocation, Long> mTimeBudget;

    protected AbstractCegarLoop(IUltimateServiceProvider iUltimateServiceProvider, DebugIdentifier debugIdentifier, A a, IIcfg<?> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TAPreferences tAPreferences, Set<? extends IcfgLocation> set) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSimplificationTechnique = tAPreferences.getSimplificationTechnique();
        this.mPrintAutomataLabeling = tAPreferences.getAutomataFormat();
        this.mName = debugIdentifier;
        this.mAbstraction = a;
        this.mIcfg = iIcfg;
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateFactory = predicateFactory;
        this.mPref = tAPreferences;
        this.mErrorLocs = set;
        this.mTaskIdentifier = new SubtaskFileIdentifier(null, this.mIcfg.getIdentifier() + "_" + String.valueOf(debugIdentifier));
        this.mResultBuilder = new CegarLoopResultBuilder();
    }

    protected void initialize() throws AutomataLibraryException {
    }

    protected abstract boolean isAbstractionEmpty() throws AutomataOperationCanceledException;

    protected abstract Pair<Script.LBool, IProgramExecution<L, Term>> isCounterexampleFeasible() throws AutomataOperationCanceledException;

    protected abstract void constructInterpolantAutomaton() throws AutomataOperationCanceledException;

    protected abstract void constructErrorAutomaton() throws AutomataOperationCanceledException;

    protected abstract boolean refineAbstraction() throws AutomataLibraryException;

    protected abstract Set<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> getFloydHoareAutomata();

    public abstract IElement getArtifact();

    protected int getIteration() {
        return this.mIteration;
    }

    private String errorLocs() {
        Iterator<? extends IcfgLocation> iterator = this.mErrorLocs.iterator();
        if (!iterator.hasNext()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        stringBuilder.append('[');
        while (true) {
            stringBuilder.append(iterator.next().toString());
            ++n;
            if (!iterator.hasNext()) {
                return stringBuilder.append(']').toString();
            }
            if (stringBuilder.length() > 120) {
                stringBuilder.append(" (and ").append(this.mErrorLocs.size() - n).append(" more)]");
                return stringBuilder.toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    public IStatisticsDataProvider getCegarLoopBenchmark() {
        return this.mCegarLoopBenchmark;
    }

    protected abstract void finish();

    public final CegarLoopResult<L> runCegar() {
        CegarLoopResult<L> cegarLoopResult = this.startCegar();
        this.finish();
        return cegarLoopResult;
    }

    private final CegarLoopResult<L> startCegar() {
        this.mIteration = 0;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info("======== Iteration %s == of CEGAR loop == %s ========", new Object[]{this.mIteration, this.mName});
            this.mLogger.info("Settings: %s", new Object[]{ReflectionUtil.instanceFieldsToString((Object)this.mPref)});
            this.mLogger.info("Starting to check reachability of %s error locations.", new Object[]{this.mErrorLocs.size()});
        }
        if (this.mPref.dumpAutomata()) {
            this.mDumper = new Dumper(this.mLogger, this.mPref, this.mName, this.mIteration);
        }
        try {
            if (!this.computeInitialAbstraction()) {
                this.iterate();
            }
            return this.mResultBuilder.getResult();
        }
        catch (AutomataOperationCanceledException | ToolchainCanceledException throwable) {
            return this.performLimitReachedActions((IRunningTaskStackProvider)throwable);
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new ToolchainExceptionWrapper(Activator.PLUGIN_ID, (Throwable)automataLibraryException);
        }
    }

    private boolean computeInitialAbstraction() throws AutomataLibraryException {
        this.mCegarLoopBenchmark.start(CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime.toString());
        try {
            try {
                this.abortIfTimeout();
                this.initialize();
            }
            catch (AutomataOperationCanceledException | ToolchainCanceledException throwable) {
                RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), "constructing initial abstraction");
                ((IRunningTaskStackReceiver)throwable).addRunningTaskInfo(runningTaskInfo);
                throw throwable;
            }
        }
        finally {
            this.mCegarLoopBenchmark.stop(CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime.toString());
        }
        if (this.mIteration <= this.mPref.watchIteration() && (this.mPref.artifact() == TAPreferences.Artifact.ABSTRACTION || this.mPref.artifact() == TAPreferences.Artifact.RCFG)) {
            this.mArtifactAutomaton = this.mAbstraction;
        }
        if (this.mPref.dumpAutomata()) {
            String string = String.valueOf(this.mTaskIdentifier) + "_InitialAbstraction";
            this.writeAutomatonToFile((IAutomaton<L, IPredicate>)this.mAbstraction, string);
        }
        this.mCegarLoopBenchmark.reportAbstractionSize(this.mAbstraction.size(), this.mIteration);
        boolean bl = this.isAbstractionEmpty();
        if (bl) {
            this.mResultBuilder.addResultForAllRemaining(Result.SAFE);
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    protected void iterate() throws AutomataLibraryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 17[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void refineAbstractionInternal(AutomatonType automatonType) throws AutomataLibraryException, AssertionError {
        boolean bl = this.refineAbstraction();
        if (!bl) {
            this.mLogger.fatal((Object)"No progress! Counterexample is still accepted by refined abstraction.");
            throw new AssertionError((Object)"No progress! Counterexample is still accepted by refined abstraction.");
        }
        if (this.mInterpolAutomaton != null) {
            this.mLogger.info("Abstraction has %s", new Object[]{this.mAbstraction.sizeInformation()});
            this.mLogger.info("%s automaton has %s", new Object[]{automatonType, this.mInterpolAutomaton.sizeInformation()});
        }
        this.performAbstractionSanityCheck();
        if (this.mIteration <= this.mPref.watchIteration() && this.mPref.artifact() == TAPreferences.Artifact.ABSTRACTION) {
            this.mArtifactAutomaton = this.mAbstraction;
        }
        boolean bl2 = this.mCegarLoopBenchmark.reportAbstractionSize(this.mAbstraction.size(), this.mIteration);
    }

    protected void performAbstractionSanityCheck() {
    }

    protected IcfgLocation getErrorLocFromCounterexample() {
        return ((IIcfgTransition)this.mCounterexample.getSymbol(this.mCounterexample.getLength() - 2)).getTarget();
    }

    private AutomatonType processFeasibilityCheckResult(Script.LBool lBool, IProgramExecution<L, Term> iProgramExecution, IcfgLocation icfgLocation) {
        Result result;
        if (lBool == Script.LBool.SAT) {
            this.mResultBuilder.addResultForProgramExecution(Result.UNSAFE, iProgramExecution, null, null);
            if (this.mPref.stopAfterFirstViolation()) {
                this.mResultBuilder.addResultForAllRemaining(Result.UNKNOWN);
            }
            return AutomatonType.ERROR;
        }
        if (lBool != Script.LBool.UNKNOWN) {
            return AutomatonType.INTERPOLANT;
        }
        if (iProgramExecution != null) {
            UnprovabilityReason unprovabilityReason = new UnprovabilityReason("unable to decide satisfiability of path constraint");
            result = Result.UNKNOWN;
            this.mResultBuilder.addResultForProgramExecution(result, iProgramExecution, null, unprovabilityReason);
        } else {
            result = Result.TIMEOUT;
            this.mResultBuilder.addResult(icfgLocation, result, null, null, null);
        }
        if (this.mPref.stopAfterFirstViolation()) {
            this.mResultBuilder.addResultForAllRemaining(result);
        }
        return AutomatonType.UNKNOWN;
    }

    private void constructRefinementAutomaton(AutomatonType automatonType) throws AutomataOperationCanceledException {
        switch (automatonType) {
            case ERROR: 
            case UNKNOWN: {
                if (this.mPref.stopAfterFirstViolation()) {
                    return;
                }
                this.mLogger.info("Excluding counterexample to continue analysis with %s automaton", new Object[]{automatonType});
                this.constructErrorAutomaton();
                break;
            }
            case INTERPOLANT: {
                this.constructInterpolantAutomaton();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown automaton type: " + String.valueOf((Object)automatonType));
            }
        }
        if (this.mInterpolAutomaton != null) {
            this.mLogger.info("%s automaton has %s states", new Object[]{automatonType, this.mInterpolAutomaton.getStates().size()});
            if (this.mIteration <= this.mPref.watchIteration() && this.mPref.artifact() == TAPreferences.Artifact.INTERPOLANT_AUTOMATON) {
                this.mArtifactAutomaton = this.mInterpolAutomaton;
            }
        }
    }

    private Map<IcfgLocation, Long> initializeTimeBudget() {
        if (!this.mPref.hasErrorLocTimeLimit()) {
            return Collections.emptyMap();
        }
        HashMap<IcfgLocation, Long> hashMap = new HashMap<IcfgLocation, Long>();
        long l = this.mServices.getProgressMonitorService().remainingTime() / (long)this.mErrorLocs.size();
        this.mErrorLocs.stream().forEach(icfgLocation -> {
            Long l2 = hashMap.put((IcfgLocation)icfgLocation, l);
        });
        this.mLogger.info("Timelimit per error location is %s", new Object[]{CoreUtil.humanReadableTime((long)l, (TimeUnit)TimeUnit.MILLISECONDS, (int)2)});
        return hashMap;
    }

    protected IUltimateServiceProvider createIterationTimer(IcfgLocation icfgLocation) {
        if (!this.mPref.hasErrorLocTimeLimit()) {
            return this.mServices;
        }
        IProgressMonitorService iProgressMonitorService = this.mServices.getProgressMonitorService();
        int n = this.mResultBuilder.remainingErrorLocs();
        if (n == 0) {
            return this.mServices;
        }
        long l = this.mTimeBudget.get(icfgLocation);
        IProgressAwareTimer iProgressAwareTimer = iProgressMonitorService.getChildTimer(l);
        return iProgressMonitorService.registerChildTimer(this.mServices, iProgressAwareTimer);
    }

    private IUltimateServiceProvider updateTimeBudget(IcfgLocation icfgLocation, IUltimateServiceProvider iUltimateServiceProvider, IUltimateServiceProvider iUltimateServiceProvider2) {
        if (!this.mPref.hasErrorLocTimeLimit()) {
            return iUltimateServiceProvider;
        }
        long l = iUltimateServiceProvider2.getProgressMonitorService().remainingTime();
        long l2 = this.mTimeBudget.put(icfgLocation, l);
        this.mLogger.info("Used %s ms for %s, %s ms remaining", new Object[]{l2 - l, icfgLocation, l});
        return iUltimateServiceProvider;
    }

    private CegarLoopResult<L> performLimitReachedActions(IRunningTaskStackProvider iRunningTaskStackProvider) {
        Result result;
        this.mLogger.warn("Verification canceled: %s", new Object[]{iRunningTaskStackProvider.printRunningTaskMessage()});
        if (iRunningTaskStackProvider instanceof TaskCanceledException) {
            EnumSet enumSet = ((TaskCanceledException)iRunningTaskStackProvider).getLimits();
            result = Result.convert((TaskCanceledException.UserDefinedLimit)enumSet.iterator().next());
        } else {
            result = Result.TIMEOUT;
        }
        return this.mResultBuilder.addResultForAllRemaining(result, null, iRunningTaskStackProvider, null).getResult();
    }

    protected void writeAutomatonToFile(IAutomaton<L, IPredicate> iAutomaton, String string) {
        this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.DumpTime);
        new AutomatonDefinitionPrinter(new AutomataLibraryServices(this.getServices()), this.determineAutomatonName(iAutomaton), this.mPref.dumpPath() + File.separator + string, this.mPrintAutomataLabeling, "", new IAutomaton[]{iAutomaton});
        this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.DumpTime);
    }

    protected void writeAutomataToFile(String string, String string2, String string3, AutomatonDefinitionPrinter.NamedAutomaton<L, IPredicate> ... namedAutomatonArray) {
        this.mCegarLoopBenchmark.start((Object)CegarLoopStatisticsDefinitions.DumpTime);
        AutomatonDefinitionPrinter.writeAutomatonToFile((AutomataLibraryServices)new AutomataLibraryServices(this.getServices()), (String)(this.mPref.dumpPath() + File.separator + string), (AutomatonDefinitionPrinter.Format)this.mPrintAutomataLabeling, (String)string2, (String)string3, namedAutomatonArray);
        this.mCegarLoopBenchmark.stop((Object)CegarLoopStatisticsDefinitions.DumpTime);
    }

    private String determineAutomatonName(IAutomaton<L, IPredicate> iAutomaton) {
        String string;
        if (iAutomaton instanceof INwaBasis) {
            string = "nwa";
        } else if (iAutomaton instanceof IPetriNet) {
            string = "net";
        } else {
            throw new UnsupportedOperationException("unknown kind of automaton " + iAutomaton.getClass().getSimpleName());
        }
        return string;
    }

    protected void abortIfTimeout() {
        if (!this.getServices().getProgressMonitorService().continueProcessing()) {
            throw new ToolchainCanceledException(this.getClass());
        }
    }

    protected IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    public static enum AutomatonType {
        ERROR,
        UNKNOWN,
        INTERPOLANT;

    }

    protected final class CegarLoopResultBuilder {
        private final Map<IcfgLocation, CegarLoopLocalResult<L>> mResults = new LinkedHashMap();

        protected CegarLoopResultBuilder() {
        }

        public CegarLoopResultBuilder addResultForAllRemaining(Result result) {
            return this.addResultForAllRemaining(result, null, null, null);
        }

        public CegarLoopResultBuilder addResultForAllRemaining(Result result, IProgramExecution<L, Term> iProgramExecution, IRunningTaskStackProvider iRunningTaskStackProvider, UnprovabilityReason unprovabilityReason) {
            AbstractCegarLoop.this.mErrorLocs.stream().filter(icfgLocation -> !this.mResults.containsKey(icfgLocation)).forEachOrdered(icfgLocation -> {
                CegarLoopResultBuilder cegarLoopResultBuilder = this.addResult((IcfgLocation)icfgLocation, result, iProgramExecution, iRunningTaskStackProvider, unprovabilityReason);
            });
            return this;
        }

        public CegarLoopResultBuilder addResultForProgramExecution(Result result, IProgramExecution<L, Term> iProgramExecution, IRunningTaskStackProvider iRunningTaskStackProvider, UnprovabilityReason unprovabilityReason) {
            AtomicTraceElement atomicTraceElement = iProgramExecution.getTraceElement(iProgramExecution.getLength() - 1);
            IcfgLocation icfgLocation = ((IIcfgTransition)atomicTraceElement.getStep()).getTarget();
            return this.addResult(icfgLocation, result, iProgramExecution, iRunningTaskStackProvider, unprovabilityReason);
        }

        public CegarLoopResultBuilder addResult(IcfgLocation icfgLocation, Result result, IProgramExecution<L, Term> iProgramExecution, IRunningTaskStackProvider iRunningTaskStackProvider, UnprovabilityReason unprovabilityReason) {
            IRunningTaskStackProvider iRunningTaskStackProvider2;
            ArrayList<UnprovabilityReason> arrayList;
            IProgramExecution iProgramExecution2;
            AbstractCegarLoop.this.mLogger.info("Registering result %s for location %s (%s of %s remaining)", new Object[]{result, icfgLocation, AbstractCegarLoop.this.mErrorLocs.size() - this.mResults.size() - 1, AbstractCegarLoop.this.mErrorLocs.size()});
            if (result == Result.SAFE) {
                iProgramExecution2 = null;
                assert (iProgramExecution == null);
            } else {
                iProgramExecution2 = iProgramExecution;
            }
            if (result == Result.UNKNOWN) {
                arrayList = new ArrayList<UnprovabilityReason>();
                if (unprovabilityReason != null) {
                    arrayList.add(unprovabilityReason);
                }
                if (iProgramExecution2 != null) {
                    arrayList.addAll(UnprovabilityReason.getUnprovabilityReasons(iProgramExecution2));
                }
                if (arrayList.isEmpty()) {
                    arrayList.add(new UnprovabilityReason("Not analyzed"));
                }
            } else {
                arrayList = null;
                assert (unprovabilityReason == null);
            }
            if (result.isLimit()) {
                iRunningTaskStackProvider2 = iRunningTaskStackProvider;
            } else {
                iRunningTaskStackProvider2 = null;
                assert (iRunningTaskStackProvider == null);
            }
            CegarLoopLocalResult cegarLoopLocalResult = new CegarLoopLocalResult(result, iProgramExecution2, arrayList, iRunningTaskStackProvider2);
            CegarLoopLocalResult cegarLoopLocalResult2 = this.mResults.get(icfgLocation);
            if (cegarLoopLocalResult2 != null) {
                if (cegarLoopLocalResult2.getResult().isConflicting(cegarLoopLocalResult.getResult())) {
                    throw new AssertionError((Object)String.format("New result %s conflicts with already found result %s", new Object[]{result, cegarLoopLocalResult2.getResult()}));
                }
                if (cegarLoopLocalResult2.getResult().compareAuthority(cegarLoopLocalResult.getResult())) {
                    AbstractCegarLoop.this.mLogger.warn("Keeping previous result %s instead of new one %s", new Object[]{cegarLoopLocalResult2, cegarLoopLocalResult});
                    return this;
                }
                AbstractCegarLoop.this.mLogger.warn("Overwriting previous result %s with the new one %s", new Object[]{cegarLoopLocalResult2, cegarLoopLocalResult});
            }
            this.mResults.put(icfgLocation, cegarLoopLocalResult);
            return this;
        }

        public CegarLoopResult<L> getResult() {
            IStatisticsDataProvider iStatisticsDataProvider = AbstractCegarLoop.this.getCegarLoopBenchmark();
            ArrayList arrayList = AbstractCegarLoop.this.mPref.getFloydHoareAutomataReuse() != TraceAbstractionPreferenceInitializer.FloydHoareAutomataReuse.NONE ? new ArrayList(AbstractCegarLoop.this.getFloydHoareAutomata()) : null;
            return new CegarLoopResult(this.mResults, iStatisticsDataProvider, AbstractCegarLoop.this.getArtifact(), arrayList);
        }

        public int remainingErrorLocs() {
            return AbstractCegarLoop.this.mErrorLocs.size() - this.mResults.size();
        }
    }

    public static enum Result {
        SAFE(2),
        UNSAFE(1),
        TIMEOUT(4),
        UNKNOWN(3),
        USER_LIMIT_TIME(4),
        USER_LIMIT_TRACEHISTOGRAM(4),
        USER_LIMIT_ITERATIONS(4),
        USER_LIMIT_PATH_PROGRAM(4);

        private final int mHierarchy;
        public static final Set<Result> USER_LIMIT_RESULTS;

        static {
            USER_LIMIT_RESULTS = EnumSet.of(USER_LIMIT_ITERATIONS, USER_LIMIT_PATH_PROGRAM, USER_LIMIT_TIME, USER_LIMIT_TRACEHISTOGRAM);
        }

        private Result(int n2) {
            this.mHierarchy = n2;
        }

        public boolean compareAuthority(Result result) {
            return this.mHierarchy <= result.mHierarchy;
        }

        public boolean isConflicting(Result result) {
            return this == SAFE && result == UNSAFE || this == UNSAFE && result == SAFE;
        }

        public static Result getAuthoritative(Result result, Result result2) {
            return result.compareAuthority(result2) ? result : result2;
        }

        public boolean isLimit() {
            return this == TIMEOUT || USER_LIMIT_RESULTS.contains((Object)this);
        }

        public static final Result convert(Throwable throwable) {
            if (throwable instanceof TaskCanceledException) {
                TaskCanceledException taskCanceledException = (TaskCanceledException)throwable;
                return taskCanceledException.getLimits().stream().map(Result::convert).reduce(Result::getAuthoritative).get();
            }
            if (throwable instanceof ToolchainCanceledException || throwable instanceof AutomataOperationCanceledException) {
                return USER_LIMIT_TIME;
            }
            throw new UnsupportedOperationException("Cannot convert " + throwable.getClass().getSimpleName() + " to " + String.valueOf(Result.class));
        }

        public static final Result convert(TaskCanceledException.UserDefinedLimit userDefinedLimit) {
            return switch (userDefinedLimit) {
                case TaskCanceledException.UserDefinedLimit.ITERATIONS -> USER_LIMIT_ITERATIONS;
                case TaskCanceledException.UserDefinedLimit.PATH_PROGRAM_ATTEMPTS -> USER_LIMIT_PATH_PROGRAM;
                case TaskCanceledException.UserDefinedLimit.TIME_PER_ERROR_LOCATION -> USER_LIMIT_TIME;
                case TaskCanceledException.UserDefinedLimit.TRACE_HISTOGRAM -> USER_LIMIT_TRACEHISTOGRAM;
                default -> throw new MatchException(null, null);
            };
        }
    }
}

