/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LoopDetector<INLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final Map<IcfgLocation, Loop> mLoopBodies;
    private final IUltimateServiceProvider mServices;
    private final Set<INLOC> mErrorLocations;
    private final Set<INLOC> mLoopHeads;
    private final Set<IcfgLocation> mIllegalLoopHeads;
    private final Map<IcfgLocation, IcfgLocation> mNesting;
    private final Map<IcfgLocation, IcfgLocation> mNested;
    private final Map<IcfgLocation, IcfgLocation> mLoopExitNodes;
    private final HashMap<IcfgLocation, Deque<Backbone>> mBackbones;
    private final int mBackboneLimit;

    public LoopDetector(ILogger iLogger, IIcfg<INLOC> iIcfg, Set<INLOC> set, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, int n) {
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mServices = iUltimateServiceProvider;
        this.mScript = managedScript;
        this.mErrorLocations = IcfgUtils.getErrorLocations(iIcfg);
        this.mLoopHeads = set;
        this.mIllegalLoopHeads = new HashSet<IcfgLocation>();
        this.mNesting = new HashMap<IcfgLocation, IcfgLocation>();
        this.mNested = new HashMap<IcfgLocation, IcfgLocation>();
        this.mLoopBodies = new HashMap<IcfgLocation, Loop>();
        this.mLoopExitNodes = new HashMap<IcfgLocation, IcfgLocation>();
        this.mBackbones = new HashMap();
        this.mBackboneLimit = n;
        for (IcfgLocation icfgLocation : this.mLoopHeads) {
            Loop loop = new Loop(icfgLocation, this.mScript);
            this.mLoopBodies.put(icfgLocation, loop);
        }
        this.getLoop();
        this.mLogger.debug((Object)("Found Backbones: " + String.valueOf(this.mBackbones)));
        if (this.mBackbones.size() > this.mBackboneLimit) {
            this.mLogger.warn((Object)"Found more backbones than the limit allows... This might take a while.");
        }
        this.mLogger.debug((Object)("Loop detector done." + System.lineSeparator()));
    }

    private void getLoop() {
        Object object;
        for (IcfgLocation object2 : this.mLoopHeads) {
            this.mLogger.debug((Object)("LoopHead: " + String.valueOf(object2)));
            object = this.getBackbonePath(this.mLoopBodies.get(object2));
            this.mBackbones.put(object2, (Deque<Backbone>)object);
        }
        this.checkBackbones();
        for (Loop loop : this.mLoopBodies.values()) {
            Collection<Object> collection;
            object = loop.getLoophead();
            if (!this.mLoopExitNodes.containsKey(object)) {
                collection = new HashSet<IcfgLocation>();
                collection.add(object);
                this.findLoopExits((IcfgLocation)object, (Set<IcfgLocation>)collection);
            }
            if (this.mIllegalLoopHeads.contains(object) || this.mBackbones.get(object).isEmpty() || !this.mLoopExitNodes.containsKey(object)) {
                this.mLoopBodies.remove(object);
                continue;
            }
            collection = this.mBackbones.get(loop.getLoophead());
            loop.setBackbones((Deque<Backbone>)collection);
            Pair<UnmodifiableTransFormula, Set<IcfgEdge>> pair = this.mergeBackbones((Deque<Backbone>)collection);
            loop.setFormula((UnmodifiableTransFormula)pair.getFirst());
            loop.setPath((Set)pair.getSecond());
            loop.setInVars(((UnmodifiableTransFormula)pair.getFirst()).getInVars());
            loop.setOutVars(((UnmodifiableTransFormula)pair.getFirst()).getOutVars());
            loop.setLoopExit(this.mLoopExitNodes.get(object));
        }
    }

    private void checkBackbones() {
        ArrayDeque<Backbone> arrayDeque = new ArrayDeque<Backbone>();
        for (Deque<Backbone> object : this.mBackbones.values()) {
            arrayDeque.addAll(object);
        }
        for (Backbone backbone : arrayDeque) {
            IcfgLocation icfgLocation = backbone.getNodes().getFirst();
            for (Backbone backbone2 : arrayDeque) {
                IcfgLocation icfgLocation2 = backbone2.getNodes().getFirst();
                if (icfgLocation.equals((Object)icfgLocation2) || !backbone.getNodes().contains(icfgLocation2) || !backbone2.getNodes().contains(icfgLocation)) continue;
                if (this.mIllegalLoopHeads.contains(icfgLocation)) {
                    this.mIllegalLoopHeads.add(icfgLocation2);
                    continue;
                }
                if (this.mIllegalLoopHeads.contains(icfgLocation2)) {
                    this.mIllegalLoopHeads.add(icfgLocation);
                    continue;
                }
                this.checkNesting(icfgLocation, icfgLocation2);
                if (this.mNested.containsKey(icfgLocation2) && this.mNested.get(icfgLocation2).equals((Object)icfgLocation)) {
                    this.mBackbones.get(icfgLocation2).remove(backbone2);
                    backbone.addNestedLoop(icfgLocation2);
                    this.mLoopBodies.get(icfgLocation).addNestedLoop(this.mLoopBodies.get(icfgLocation2));
                    continue;
                }
                if (this.mNested.containsKey(icfgLocation) && this.mNested.get(icfgLocation).equals((Object)icfgLocation2)) {
                    this.mBackbones.get(icfgLocation).remove(backbone);
                    backbone.addNestedLoop(icfgLocation);
                    this.mLoopBodies.get(icfgLocation2).addNestedLoop(this.mLoopBodies.get(icfgLocation));
                    continue;
                }
                this.mIllegalLoopHeads.add(backbone.getNodes().getFirst());
                this.mIllegalLoopHeads.add(backbone2.getNodes().getFirst());
            }
        }
        for (IcfgLocation icfgLocation : this.mIllegalLoopHeads) {
            this.mBackbones.remove(icfgLocation);
            this.mLoopBodies.remove(icfgLocation);
        }
        this.mLogger.debug((Object)"Backbones checked.");
    }

    private boolean findLoopHeader(IcfgEdge icfgEdge, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Set<IcfgEdge> set, Set<IcfgLocation> set2, boolean bl) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>(set);
        HashSet<IcfgLocation> hashSet2 = new HashSet<IcfgLocation>(set2);
        HashSet<INLOC> hashSet3 = new HashSet<INLOC>(this.mLoopHeads);
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>();
        ArrayDeque<IcfgLocation> arrayDeque2 = new ArrayDeque<IcfgLocation>();
        arrayDeque.push(icfgEdge);
        hashSet3.remove(icfgLocation2);
        hashSet3.removeAll(this.mIllegalLoopHeads);
        arrayDeque2.addLast(icfgLocation);
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge2 = (IcfgEdge)arrayDeque.pop();
            IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge2.getTarget();
            if (icfgLocation3.equals((Object)icfgLocation2)) {
                return true;
            }
            if (arrayDeque2.contains(icfgLocation3) || hashSet.contains(icfgEdge2) || hashSet2.contains(icfgLocation3) || icfgLocation3.equals((Object)icfgLocation)) continue;
            if (hashSet3.contains(icfgLocation3) && !bl) {
                if (this.mLoopExitNodes.containsKey(icfgLocation3)) {
                    arrayDeque.addAll(this.mLoopBodies.get(icfgLocation3).getExitTransitions());
                } else {
                    hashSet2.add(icfgLocation);
                    this.findLoopExits(icfgLocation3, hashSet2);
                }
            }
            arrayDeque2.addLast(icfgLocation3);
            arrayDeque.addAll(icfgLocation3.getOutgoingEdges());
        }
        return false;
    }

    private boolean findLoopHeader(Deque<IcfgEdge> deque, IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Set<IcfgEdge> set, Set<IcfgLocation> set2, boolean bl) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>(set);
        HashSet<IcfgLocation> hashSet2 = new HashSet<IcfgLocation>(set2);
        HashSet<INLOC> hashSet3 = new HashSet<INLOC>(this.mLoopHeads);
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>();
        ArrayDeque<IcfgLocation> arrayDeque2 = new ArrayDeque<IcfgLocation>();
        arrayDeque.addAll(deque);
        hashSet3.remove(icfgLocation2);
        hashSet3.removeAll(this.mIllegalLoopHeads);
        arrayDeque2.addLast(icfgLocation);
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.pop();
            IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge.getTarget();
            if (icfgLocation3.equals((Object)icfgLocation2)) {
                return true;
            }
            if (arrayDeque2.contains(icfgLocation3) || hashSet.contains(icfgEdge) || hashSet2.contains(icfgLocation3) || icfgLocation3.equals((Object)icfgLocation)) continue;
            if (hashSet3.contains(icfgLocation3) && !bl) {
                if (this.mLoopExitNodes.containsKey(icfgLocation3)) {
                    arrayDeque.addAll(this.mLoopBodies.get(icfgLocation3).getExitTransitions());
                } else {
                    hashSet2.add(icfgLocation);
                    this.findLoopExits(icfgLocation3, hashSet2);
                }
            }
            arrayDeque2.addLast(icfgLocation3);
            arrayDeque.addAll(icfgLocation3.getOutgoingEdges());
        }
        return false;
    }

    private void checkNesting(IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        if (this.mNested.containsKey(icfgLocation) && this.mNested.get(icfgLocation).equals((Object)icfgLocation2) || this.mNesting.containsKey(icfgLocation) && this.mNesting.get(icfgLocation).equals((Object)icfgLocation2)) {
            return;
        }
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        hashSet.add(icfgLocation2);
        hashSet.add(icfgLocation);
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>(icfgLocation.getOutgoingEdges());
        if (this.mNested.containsKey(icfgLocation)) {
            hashSet.add(this.mNested.get(icfgLocation));
        }
        if (!this.findLoopHeader(arrayDeque, icfgLocation, icfgLocation, Collections.emptySet(), hashSet, false)) {
            this.mNested.put(icfgLocation2, icfgLocation);
        }
        hashSet.clear();
        hashSet.add(icfgLocation2);
        hashSet.add(icfgLocation);
        ArrayDeque<IcfgEdge> arrayDeque2 = new ArrayDeque<IcfgEdge>(icfgLocation2.getOutgoingEdges());
        if (this.mNested.containsKey(icfgLocation2)) {
            hashSet.add(this.mNested.get(icfgLocation2));
        }
        if (!this.findLoopHeader(arrayDeque2, icfgLocation2, icfgLocation2, Collections.emptySet(), hashSet, false)) {
            this.mNested.put(icfgLocation, icfgLocation2);
        }
    }

    private void findLoopExits(IcfgLocation icfgLocation, Set<IcfgLocation> set) {
        for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
            if (this.findLoopHeader(icfgEdge, icfgLocation, icfgLocation, Collections.emptySet(), set, false)) continue;
            this.mLoopExitNodes.put(icfgLocation, (IcfgLocation)icfgEdge.getTarget());
            this.mLoopBodies.get(icfgLocation).setLoopExit((IcfgLocation)icfgEdge.getTarget());
        }
    }

    private Deque<Backbone> getBackbonePath(Loop loop) {
        ArrayDeque<Backbone> arrayDeque = new ArrayDeque<Backbone>();
        IcfgLocation icfgLocation = loop.getLoophead();
        ArrayDeque<Backbone> arrayDeque2 = new ArrayDeque<Backbone>();
        for (Object object : icfgLocation.getOutgoingEdges()) {
            Backbone backbone = new Backbone((IcfgEdge)object);
            arrayDeque2.add(backbone);
        }
        while (!arrayDeque2.isEmpty()) {
            IcfgEdge icfgEdge;
            Object object;
            object = new HashSet();
            Backbone backbone = (Backbone)arrayDeque2.pop();
            object.addAll(backbone.getNodes());
            boolean bl = false;
            while (!((IcfgLocation)backbone.getPath().getLast().getTarget()).equals((Object)icfgLocation)) {
                icfgEdge = backbone.getPath().getLast();
                IcfgLocation icfgLocation2 = (IcfgLocation)backbone.getPath().getLast().getTarget();
                if (this.mErrorLocations.contains(icfgLocation2)) {
                    this.mLogger.debug((Object)"FOUND ERROR LOCATIONS");
                    TransFormula transFormula = this.calculateFormula(backbone.getPath());
                    backbone.setFormula(transFormula);
                    loop.addErrorPath((IcfgLocation)icfgEdge.getTarget(), backbone);
                    this.mLogger.debug((Object)"ERROR PATH DONE");
                    bl = true;
                    break;
                }
                if (!this.findLoopHeader(icfgEdge, icfgLocation, icfgLocation, Collections.emptySet(), (Set<IcfgLocation>)object, false) || object.contains(icfgLocation2)) {
                    bl = true;
                    break;
                }
                object.add(icfgLocation2);
                if (icfgLocation2.getOutgoingEdges().isEmpty()) continue;
                int n = 1;
                while (n < icfgLocation2.getOutgoingEdges().size()) {
                    Backbone backbone2 = new Backbone(backbone);
                    backbone2.addTransition((IcfgEdge)icfgLocation2.getOutgoingEdges().get(n));
                    arrayDeque2.addLast(backbone2);
                    ++n;
                }
                backbone.addTransition((IcfgEdge)icfgLocation2.getOutgoingEdges().get(0));
            }
            if (bl) continue;
            icfgEdge = this.calculateFormula(backbone.getPath());
            backbone.setFormula((TransFormula)icfgEdge);
            arrayDeque.addLast(backbone);
        }
        return arrayDeque;
    }

    private TransFormula calculateFormula(Deque<IcfgEdge> deque) {
        ArrayList<UnmodifiableTransFormula> arrayList = new ArrayList<UnmodifiableTransFormula>();
        for (IcfgEdge icfgEdge : deque) {
            arrayList.add(icfgEdge.getTransformula());
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, arrayList);
    }

    private Pair<UnmodifiableTransFormula, Set<IcfgEdge>> mergeBackbones(Deque<Backbone> deque) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        UnmodifiableTransFormula unmodifiableTransFormula = (UnmodifiableTransFormula)deque.getFirst().getFormula();
        for (Backbone backbone : deque) {
            hashSet.addAll(backbone.getPath());
            unmodifiableTransFormula = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (boolean)false, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{unmodifiableTransFormula, (UnmodifiableTransFormula)backbone.getFormula()});
        }
        return new Pair((Object)unmodifiableTransFormula, hashSet);
    }

    public Map<IcfgLocation, Loop> getLoopBodies() {
        return this.mLoopBodies;
    }
}

