/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.EprEqualityPredicate;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.atoms.EprGroundPredicateAtom;
import java.util.ArrayList;
import java.util.List;

public class EprGroundEqualityAtom
extends EprGroundPredicateAtom {
    private final Term mLhs;
    private final Term mRhs;
    private final List<ApplicationTerm> mPoint;

    public EprGroundEqualityAtom(ApplicationTerm applicationTerm, int n, int n2, EprEqualityPredicate eprEqualityPredicate, SourceAnnotation sourceAnnotation) {
        super(applicationTerm, n, n2, eprEqualityPredicate, sourceAnnotation);
        assert (applicationTerm.getParameters().length == 2);
        this.mLhs = applicationTerm.getParameters()[0];
        this.mRhs = applicationTerm.getParameters()[1];
        this.mPoint = new ArrayList<ApplicationTerm>();
        int n3 = 0;
        while (n3 < this.getArguments().length) {
            this.mPoint.add((ApplicationTerm)this.getArguments()[n3]);
            ++n3;
        }
    }

    @Override
    public Term getSMTFormula(Theory theory) {
        return this.getTerm();
    }

    public CCEquality getCCEquality(Clausifier clausifier) {
        EqualityProxy equalityProxy = clausifier.createEqualityProxy(this.mLhs, this.mRhs, this.getSourceAnnotation());
        if (equalityProxy == EqualityProxy.getTrueProxy()) {
            return null;
        }
        assert (equalityProxy != EqualityProxy.getFalseProxy());
        CCEquality cCEquality = (CCEquality)equalityProxy.getLiteral(this.getSourceAnnotation());
        assert (cCEquality != null);
        return cCEquality;
    }

    public List<ApplicationTerm> getPoint() {
        return this.mPoint;
    }
}

