/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class TermContextTransformationEngine<C> {
    private static final boolean DEBUG_CHECK_INTERMEDIATE_RESULT = false;
    private static final boolean DEBUG_NONTERMINATION = false;
    private static final boolean SMART_REPETITIONS = true;
    private final Comparator<Term> mSiblingOrder;
    private final TermWalker<C> mTermWalker;
    private final ArrayDeque<Task> mStack;

    private TermContextTransformationEngine(TermWalker<C> termWalker, Comparator<Term> comparator) {
        this.mSiblingOrder = comparator;
        this.mTermWalker = termWalker;
        this.mStack = new ArrayDeque();
    }

    public static <C> Term transform(TermWalker<C> termWalker, Comparator<Term> comparator, C c, Term term) {
        return new TermContextTransformationEngine<C>(termWalker, comparator).transform(c, term);
    }

    private Term transform(C c, Term term) {
        DescendResult descendResult = this.mTermWalker.convert(c, term);
        Task task = this.constructTaskForDescendResult(c, descendResult);
        if (task instanceof AscendResultTask) {
            AscendResultTask ascendResultTask = (AscendResultTask)task;
            return ascendResultTask.getResult();
        }
        this.mStack.push(task);
        while (!this.mStack.isEmpty()) {
            Task task2 = this.mStack.peek().doStep();
            if (task2 instanceof AscendResultTask) {
                AscendResultTask ascendResultTask = (AscendResultTask)task2;
                if (this.mStack.isEmpty()) {
                    return ascendResultTask.getResult();
                }
                this.mStack.peek().integrateResult(ascendResultTask.getResult());
                continue;
            }
            this.mStack.push(task2);
        }
        throw new AssertionError((Object)"empty stack should have caused return");
    }

    private Task constructTaskForDescendResult(C c, DescendResult descendResult) {
        Task task;
        if (descendResult instanceof IntermediateResultForDescend) {
            task = this.constructTask(c, ((IntermediateResultForDescend)descendResult).getTerm());
        } else if (descendResult instanceof FinalResultForAscend) {
            task = new AscendResultTask(c, ((FinalResultForAscend)descendResult).getTerm());
        } else {
            throw new AssertionError((Object)("unknown result " + String.valueOf(descendResult)));
        }
        return task;
    }

    private Task constructTask(C c, Term term) {
        Task task;
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            task = new ApplicationTermTask(c, applicationTerm);
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            task = new QuantifiedFormulaTask(c, quantifiedFormula);
        } else {
            throw new AssertionError((Object)("unknown term " + String.valueOf(term)));
        }
        return task;
    }

    private static boolean isAbsorbingElementConDis(FunctionSymbol functionSymbol, Term term) {
        return (functionSymbol.getName().equals("and") || functionSymbol.getName().equals("or")) && SmtUtils.isAbsorbingElement(functionSymbol.getName(), term);
    }

    private static boolean isNeutralElementConDis(FunctionSymbol functionSymbol, Term term) {
        return (functionSymbol.getName().equals("and") || functionSymbol.getName().equals("or")) && SmtUtils.isNeutralElement(functionSymbol.getName(), term);
    }

    private class ApplicationTermTask
    extends Task {
        int mNext;
        final ApplicationTerm mOriginal;
        final Term[] mResult;
        int mPositionOfLastChange;
        int mRepetitions;

        public ApplicationTermTask(C c, ApplicationTerm applicationTerm) {
            super(c);
            this.mPositionOfLastChange = -1;
            this.mNext = 0;
            this.mOriginal = applicationTerm;
            this.mResult = Arrays.copyOf(applicationTerm.getParameters(), applicationTerm.getParameters().length);
            if (TermContextTransformationEngine.this.mSiblingOrder != null) {
                Arrays.sort(this.mResult, TermContextTransformationEngine.this.mSiblingOrder);
            }
            this.mRepetitions = 0;
        }

        @Override
        Task doStep() {
            Task task;
            if (this.mNext == this.mOriginal.getParameters().length && this.mPositionOfLastChange != -1 && TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() != Repetition.NO_REPETITION) {
                this.mNext = 0;
                ++this.mRepetitions;
            }
            if (this.mNext == this.mOriginal.getParameters().length || this.mPositionOfLastChange == this.mNext) {
                Term term = TermContextTransformationEngine.this.mTermWalker.constructResultForApplicationTerm(this.mContext, this.mOriginal, this.mResult);
                Task task2 = TermContextTransformationEngine.this.mStack.pop();
                assert (task2 == this);
                task = new AscendResultTask(this.mContext, term);
            } else if (TermContextTransformationEngine.isAbsorbingElementConDis(this.mOriginal.getFunction(), this.mResult[Math.floorMod(this.mNext - 1, this.mResult.length)])) {
                Term term = TermContextTransformationEngine.this.mTermWalker.constructResultForApplicationTerm(this.mContext, this.mOriginal, this.mResult);
                assert (SmtUtils.isAbsorbingElement(this.mOriginal.getFunction().getName(), term));
                Task task3 = TermContextTransformationEngine.this.mStack.pop();
                assert (task3 == this);
                task = new AscendResultTask(this.mContext, term);
            } else if (TermContextTransformationEngine.isNeutralElementConDis(this.mOriginal.getFunction(), this.mResult[this.mNext])) {
                task = TermContextTransformationEngine.this.constructTaskForDescendResult(this.mContext, new FinalResultForAscend(this.mResult[this.mNext]));
            } else {
                ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(this.mResult));
                arrayList.remove(this.mNext);
                Object c = TermContextTransformationEngine.this.mTermWalker.constructContextForApplicationTerm(this.mContext, this.mOriginal.getFunction(), Arrays.asList(this.mResult), this.mNext);
                DescendResult descendResult = TermContextTransformationEngine.this.mTermWalker.convert(c, this.mResult[this.mNext]);
                task = TermContextTransformationEngine.this.constructTaskForDescendResult(c, descendResult);
            }
            return task;
        }

        @Override
        void integrateResult(Term term) {
            assert (this.mNext < this.mOriginal.getParameters().length);
            if (this.updatePositionOfLastChange(term)) {
                this.mPositionOfLastChange = this.mNext;
            }
            this.mResult[this.mNext] = term;
            ++this.mNext;
        }

        private boolean updatePositionOfLastChange(Term term) {
            if (TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() == Repetition.NO_REPETITION) {
                return false;
            }
            assert (TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() == Repetition.REPEAT_UNTIL_NO_CHANGE || TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() == Repetition.REPEAT_UNTIL_NO_MAJOR_CHANGE);
            if (this.mResult[this.mNext].equals(term)) {
                return false;
            }
            if (TermContextTransformationEngine.isNeutralElementConDis(this.mOriginal.getFunction(), term)) {
                return false;
            }
            if (TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() == Repetition.REPEAT_UNTIL_NO_CHANGE) {
                return true;
            }
            assert (TermContextTransformationEngine.this.mTermWalker.applyRepeatedly() == Repetition.REPEAT_UNTIL_NO_MAJOR_CHANGE);
            if (term instanceof TermVariable) {
                return true;
            }
            if (!(term instanceof ApplicationTerm)) {
                return false;
            }
            String string = this.mOriginal.getFunction().getApplicationString();
            if (!string.equals("or") && !string.equals("and")) {
                throw new AssertionError((Object)string);
            }
            return ApplicationTermTask.isTermDualBooleanConnective(string, this.mResult[this.mNext]) && !ApplicationTermTask.isTermDualBooleanConnective(string, term);
        }

        private static boolean isTermDualBooleanConnective(String string, Term term) {
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                return QuantifierUtils.getDualBooleanConnective(string).equals(applicationTerm.getFunction().getApplicationString());
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("next:");
            stringBuilder.append(this.mNext);
            stringBuilder.append(" (");
            stringBuilder.append(this.mOriginal.getFunction().toString());
            stringBuilder.append(Arrays.stream(this.mResult).map(Term::toString).collect(Collectors.joining(" ")));
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private class AscendResultTask
    extends Task {
        final Term mResult;

        public AscendResultTask(C c, Term term) {
            super(c);
            this.mResult = term;
        }

        public Term getResult() {
            return this.mResult;
        }

        @Override
        Task doStep() {
            throw new AssertionError();
        }

        @Override
        void integrateResult(Term term) {
            throw new AssertionError();
        }
    }

    public static interface DescendResult {
        public Term getTerm();
    }

    public static class FinalResultForAscend
    implements DescendResult {
        private final Term mFinalResult;

        public FinalResultForAscend(Term term) {
            this.mFinalResult = term;
        }

        @Override
        public Term getTerm() {
            return this.mFinalResult;
        }
    }

    public static class IntermediateResultForDescend
    implements DescendResult {
        private final Term mIntermediateResult;

        public IntermediateResultForDescend(Term term) {
            this.mIntermediateResult = term;
        }

        @Override
        public Term getTerm() {
            return this.mIntermediateResult;
        }
    }

    private class QuantifiedFormulaTask
    extends Task {
        private final QuantifiedFormula mOriginal;
        private Term mResultSubformula;

        public QuantifiedFormulaTask(C c, QuantifiedFormula quantifiedFormula) {
            super(c);
            this.mOriginal = quantifiedFormula;
        }

        @Override
        Task doStep() {
            Task task;
            if (this.mResultSubformula != null) {
                Term term = TermContextTransformationEngine.this.mTermWalker.constructResultForQuantifiedFormula(this.mContext, this.mOriginal, this.mResultSubformula);
                Task task2 = TermContextTransformationEngine.this.mStack.pop();
                assert (task2 == this);
                task = new AscendResultTask(this.mContext, term);
            } else {
                Object c = TermContextTransformationEngine.this.mTermWalker.constructContextForQuantifiedFormula(this.mContext, this.mOriginal.getQuantifier(), Arrays.asList(this.mOriginal.getVariables()));
                DescendResult descendResult = TermContextTransformationEngine.this.mTermWalker.convert(c, this.mOriginal.getSubformula());
                task = TermContextTransformationEngine.this.constructTaskForDescendResult(c, descendResult);
            }
            return task;
        }

        @Override
        void integrateResult(Term term) {
            this.mResultSubformula = term;
        }

        public String toString() {
            return this.mOriginal.toStringDirect();
        }
    }

    public static enum Repetition {
        NO_REPETITION,
        REPEAT_UNTIL_NO_CHANGE,
        REPEAT_UNTIL_NO_MAJOR_CHANGE;

    }

    private abstract class Task {
        private final C mContext;

        public Task(C c) {
            this.mContext = c;
        }

        abstract Task doStep();

        abstract void integrateResult(Term var1);
    }

    public static abstract class TermWalker<C> {
        protected abstract C constructContextForApplicationTerm(C var1, FunctionSymbol var2, List<Term> var3, int var4);

        protected abstract Repetition applyRepeatedly();

        protected abstract C constructContextForQuantifiedFormula(C var1, int var2, List<TermVariable> var3);

        protected abstract DescendResult convert(C var1, Term var2);

        protected abstract Term constructResultForApplicationTerm(C var1, ApplicationTerm var2, Term[] var3);

        protected abstract Term constructResultForQuantifiedFormula(C var1, QuantifiedFormula var2, Term var3);

        protected abstract void checkIntermediateResult(C var1, Term var2, Term var3);
    }
}

