/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class DimacsMaxSatSolver<V>
extends AbstractMaxSatSolver<V> {
    public static final boolean ONLY_PRODUCE_OUTPUT_FILE = false;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String FILE_NAME_TMP = "dimacs.wcnf.tmp";
    private static final String EXTENSION = ".wcnf";
    private static final String PREFIX = "UAutomizer_";
    private static final String FILE_NAME_DEFAULT = "dimacs";
    private static final String ENCODING = "UTF-8";
    private static final boolean WRITE_TO_STD_OUT = false;
    private static final String AHMAXSAT_COMMAND = "./ahmaxsat-ls-1.68";
    private static final String RESULT_OUTPUT_BEGINNING = "s OPTIMUM FOUND";
    private static final String HEADER = DimacsMaxSatSolver.getHeader(false);
    private static final char BLANK = ' ';
    private static final char NEG = '-';
    private static final String END_LINE = " 0" + LINE_SEPARATOR;
    private static final String BLANK_STRING = " ";
    private static final CharSequence SOFT_CLAUSE_WEIGHT = "1 ";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final String mFilename;
    private final Appendable mWriter;
    private final Map<V, String> mVar2NumberString;
    private final ArrayList<V> mNumber2Var;
    private Map<V, Boolean> mVar2Assignment;

    public DimacsMaxSatSolver(AutomataLibraryServices automataLibraryServices) {
        this(automataLibraryServices, FILE_NAME_DEFAULT);
    }

    public DimacsMaxSatSolver(AutomataLibraryServices automataLibraryServices, String string) {
        super(automataLibraryServices);
        this.mFilename = PREFIX + string + EXTENSION;
        this.mWriter = DimacsMaxSatSolver.createWriter();
        this.mVar2NumberString = new HashMap<V, String>();
        this.mNumber2Var = new ArrayList();
    }

    @Override
    public void addVariable(V v) {
        this.mVar2NumberString.put((String)v, Integer.toString(this.getNumberOfVariables() + 1));
        this.mNumber2Var.add(v);
    }

    @Override
    public void addHornClause(V[] VArray, V v) {
        Object[] objectArray = v == null ? EMPTY_ARRAY : new Object[]{v};
        this.addClause(VArray, objectArray);
    }

    @Override
    public void addClause(V[] VArray, V[] VArray2) {
        ++this.mClauses;
        try {
            V v;
            V[] VArray3 = VArray;
            int n = VArray.length;
            int n2 = 0;
            while (n2 < n) {
                v = VArray3[n2];
                this.mWriter.append(' ').append('-').append(this.mVar2NumberString.get(v));
                ++n2;
            }
            VArray3 = VArray2;
            n = VArray2.length;
            n2 = 0;
            while (n2 < n) {
                v = VArray3[n2];
                this.mWriter.append(' ').append(this.mVar2NumberString.get(v));
                ++n2;
            }
            this.mWriter.append(END_LINE);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    @Override
    public boolean solve() throws AutomataOperationCanceledException {
        Process process;
        try {
            ((Writer)this.mWriter).close();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        this.fixFile();
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(AHMAXSAT_COMMAND);
        arrayList.add(this.mFilename);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        try {
            process = processBuilder.start();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return this.parseResult(process.getInputStream());
    }

    private static Writer createWriter() {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(FILE_NAME_TMP), ENCODING);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void fixFile() {
        String string = Integer.toString(this.getNumberOfVariables() + 1);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.mFilename), ENCODING);){
                ((Writer)outputStreamWriter).append(HEADER).append(Integer.toString(this.getNumberOfVariables())).append(' ').append(Integer.toString(this.mClauses)).append(' ').append(string).append(LINE_SEPARATOR);
                try {
                    Throwable throwable2 = null;
                    Object var6_11 = null;
                    try (Scanner scanner = new Scanner(new File(FILE_NAME_TMP), ENCODING);){
                        scanner.useDelimiter(LINE_SEPARATOR);
                        while (scanner.hasNext()) {
                            String string2 = scanner.next();
                            ((Writer)outputStreamWriter).append(string).append(string2).append(LINE_SEPARATOR);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new AssertionError((Object)fileNotFoundException);
                }
                this.addSoftClauses(outputStreamWriter);
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    private void addSoftClauses(Writer writer) throws IOException {
        for (String string : this.mVar2NumberString.values()) {
            writer.append(SOFT_CLAUSE_WEIGHT).append(string).append(END_LINE);
        }
    }

    private boolean parseResult(InputStream inputStream) {
        this.mVar2Assignment = new HashMap<V, Boolean>(this.mVar2NumberString.size());
        Throwable throwable = null;
        Object var3_4 = null;
        try (Scanner scanner = new Scanner(inputStream, ENCODING);){
            String string;
            scanner.useDelimiter(LINE_SEPARATOR);
            while (scanner.hasNext()) {
                string = scanner.next();
                if (string.startsWith(RESULT_OUTPUT_BEGINNING)) break;
            }
            scanner.useDelimiter(BLANK_STRING);
            if (scanner.hasNext()) {
                scanner.next();
            }
            while (scanner.hasNext()) {
                Boolean bl;
                string = scanner.next();
                if (string.startsWith(LINE_SEPARATOR)) {
                    break;
                }
                int n = Integer.parseInt(string);
                if (n < 0) {
                    n = -n;
                    bl = Boolean.FALSE;
                } else {
                    bl = Boolean.TRUE;
                }
                V v = this.mNumber2Var.get(--n);
                this.mVar2Assignment.put((Boolean)v, bl);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    @Override
    public Map<V, Boolean> getValues() {
        return this.mVar2Assignment;
    }

    @Override
    public VariableStatus getValue(V v) {
        return VariableStatus.UNSET;
    }

    @Override
    public int getNumberOfVariables() {
        return this.mVar2NumberString.size();
    }

    @Override
    public int getNumberOfClauses() {
        return this.mClauses;
    }

    @Override
    protected Boolean getPersistentAssignment(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void log() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected VariableStatus getTemporaryAssignment(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void backtrack(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void makeAssignmentPersistent() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void setVariable(V v, boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void decideOne() {
        throw new UnsupportedOperationException();
    }

    private static String getHeader(boolean bl) {
        String string = bl ? "c This file belongs to a set of benchmarks that was produced by a minimization \nc of visibly pushdown automata [1, 2]. This minimization encodes the existence \nc of an equivalence relation that is suitable for quotienting. The more soft \nc clauses can be set to true, the more pairs of states can be merged. The \nc input automata were produced by applying the interprocedural analysis [3] \nc of the software verifier Ultimate Automizer [4, 5] to C programs from \nc the SV-COMP 2016 [6].\nc\nc License \"https://creativecommons.org/licenses/by/4.0/\"\nc\nc 2017-05-22, \nc Matthias Heizmann (heizmann@informatik.uni-freiburg.de)\nc Christian Schilling (schillic@informatik.uni-freiburg.de)\nc\nc [1] Matthias Heizmann, Christian Schilling, Daniel Tischner:\nc Minimization of Visibly Pushdown Automata Using Partial Max-SAT.\nc TACAS (1) 2017: 461-478\nc [2] https://ultimate.informatik.uni-freiburg.de/automata_library\nc [3] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski:\nc Nested interpolants. POPL 2010: 471-482\nc [4] Matthias Heizmann, Jochen Hoenicke, Andreas Podelski:\nc Software Model Checking for People Who Love Automata.\nc CAV 2013: 36-52\nc [5] Matthias Heizmann, Yu-Fang Chen, Daniel Dietsch, Marius Greitschus,\nc Jochen Hoenicke, Yong Li, Alexander Nutz, Betim Musa, Christian Schilling,\nc Tanja Schindler, Andreas Podelski:\nc Ultimate Automizer and the Search for Perfect Interpolants - (Competition\nc Contribution).\nc TACAS (II) 2018: 447-451\nc [6] Dirk Beyer: Reliable and Reproducible Competition Results with \nc BenchExec and Witnesses (Report on SV-COMP 2016).\nc TACAS 2016: 887-904\np wcnf " : "p wcnf ";
        return string;
    }
}

