/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.CTrans;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.ITrans;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.RTrans;
import java.util.ArrayList;
import java.util.HashSet;

final class NwaWithArrays
implements Cloneable {
    int mNumStates;
    int mNumISyms;
    int mNumCSyms;
    int mNumRSyms;
    boolean[] mIsInitial;
    boolean[] mIsFinal;
    ITrans[] mITrans;
    CTrans[] mCTrans;
    RTrans[] mRTrans;

    NwaWithArrays() {
    }

    static boolean checkConsistency(NwaWithArrays nwaWithArrays) {
        Object object;
        if (nwaWithArrays.mNumStates < 0) {
            return false;
        }
        if (nwaWithArrays.mNumISyms < 0) {
            return false;
        }
        if (nwaWithArrays.mNumRSyms < 0) {
            return false;
        }
        if (nwaWithArrays.mNumCSyms < 0) {
            return false;
        }
        if (nwaWithArrays.mIsInitial == null || nwaWithArrays.mIsInitial.length != nwaWithArrays.mNumStates) {
            return false;
        }
        if (nwaWithArrays.mIsFinal == null || nwaWithArrays.mIsFinal.length != nwaWithArrays.mNumStates) {
            return false;
        }
        Object[] objectArray = nwaWithArrays.mITrans;
        int n = nwaWithArrays.mITrans.length;
        int n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (((ITrans)object).mSrc < 0 || ((ITrans)object).mSrc >= nwaWithArrays.mNumStates) {
                return false;
            }
            if (((ITrans)object).mSym < 0 || ((ITrans)object).mSym >= nwaWithArrays.mNumISyms) {
                return false;
            }
            if (((ITrans)object).mDst < 0 || ((ITrans)object).mDst >= nwaWithArrays.mNumStates) {
                return false;
            }
            ++n2;
        }
        objectArray = nwaWithArrays.mCTrans;
        n = nwaWithArrays.mCTrans.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (((CTrans)object).mSrc < 0 || ((CTrans)object).mSrc >= nwaWithArrays.mNumStates) {
                return false;
            }
            if (((CTrans)object).mSym < 0 || ((CTrans)object).mSym >= nwaWithArrays.mNumCSyms) {
                return false;
            }
            if (((CTrans)object).mDst < 0 || ((CTrans)object).mDst >= nwaWithArrays.mNumStates) {
                return false;
            }
            ++n2;
        }
        objectArray = nwaWithArrays.mRTrans;
        n = nwaWithArrays.mRTrans.length;
        n2 = 0;
        while (n2 < n) {
            object = objectArray[n2];
            if (((RTrans)object).mSrc < 0 || ((RTrans)object).mSrc >= nwaWithArrays.mNumStates) {
                return false;
            }
            if (((RTrans)object).mSym < 0 || ((RTrans)object).mSym >= nwaWithArrays.mNumRSyms) {
                return false;
            }
            if (((RTrans)object).mTop < 0 || ((RTrans)object).mTop >= nwaWithArrays.mNumStates) {
                return false;
            }
            if (((RTrans)object).mDst < 0 || ((RTrans)object).mDst >= nwaWithArrays.mNumStates) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean checkDeterminism(NwaWithArrays nwaWithArrays) {
        Object object;
        HashSet<ITrans> hashSet = new HashSet<ITrans>();
        ITrans[] iTransArray = nwaWithArrays.mITrans;
        int n = nwaWithArrays.mITrans.length;
        int n2 = 0;
        while (n2 < n) {
            object = iTransArray[n2];
            if (!hashSet.add(new ITrans(((ITrans)object).mSrc, ((ITrans)object).mSym, 0))) {
                return false;
            }
            ++n2;
        }
        object = new HashSet();
        CTrans[] cTransArray = nwaWithArrays.mCTrans;
        int n3 = nwaWithArrays.mCTrans.length;
        n = 0;
        while (n < n3) {
            CTrans cTrans = cTransArray[n];
            if (!((HashSet)object).add(new CTrans(cTrans.mSrc, cTrans.mSym, 0))) {
                return false;
            }
            ++n;
        }
        HashSet<RTrans> hashSet2 = new HashSet<RTrans>();
        RTrans[] rTransArray = nwaWithArrays.mRTrans;
        int n4 = nwaWithArrays.mRTrans.length;
        n3 = 0;
        while (n3 < n4) {
            RTrans rTrans = rTransArray[n3];
            if (!hashSet2.add(new RTrans(rTrans.mSrc, rTrans.mSym, rTrans.mTop, 0))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static ArrayList<Integer> computeInitialStates(NwaWithArrays nwaWithArrays) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < nwaWithArrays.mNumStates) {
            if (nwaWithArrays.mIsInitial[n]) {
                arrayList.add(n);
            }
            ++n;
        }
        return arrayList;
    }

    static ArrayList<Integer> computeFinalStates(NwaWithArrays nwaWithArrays) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < nwaWithArrays.mNumStates) {
            if (nwaWithArrays.mIsFinal[n]) {
                arrayList.add(n);
            }
            ++n;
        }
        return arrayList;
    }

    public NwaWithArrays clone() {
        NwaWithArrays nwaWithArrays = new NwaWithArrays();
        nwaWithArrays.mNumStates = this.mNumStates;
        nwaWithArrays.mNumISyms = this.mNumISyms;
        nwaWithArrays.mNumCSyms = this.mNumCSyms;
        nwaWithArrays.mNumRSyms = this.mNumRSyms;
        nwaWithArrays.mIsInitial = (boolean[])this.mIsInitial.clone();
        nwaWithArrays.mIsFinal = (boolean[])this.mIsFinal.clone();
        nwaWithArrays.mITrans = (ITrans[])this.mITrans.clone();
        nwaWithArrays.mCTrans = (CTrans[])this.mCTrans.clone();
        nwaWithArrays.mRTrans = (RTrans[])this.mRTrans.clone();
        return nwaWithArrays;
    }
}

