/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit;

import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntBenchmark;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.LiteralCollection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.BaseExplicitValueValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueEvaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValuePostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueWideningOperator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;

public class ExplicitValueDomain
implements IAbstractDomain<ExplicitValueState, IcfgEdge> {
    private final ILogger mLogger;
    private final LiteralCollection mLiteralCollection;
    private final IUltimateServiceProvider mServices;
    private final BoogieIcfgContainer mRootAnnotation;
    private final BoogieSymbolTable mSymbolTable;
    private IAbstractStateBinaryOperator<ExplicitValueState> mWideningOperator;
    private NonrelationalPostOperator<ExplicitValueState, BaseExplicitValueValue> mPostOperator;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IBoogieSymbolTableVariableProvider mBpl2SmtSymbolTable;

    public ExplicitValueDomain(ILogger iLogger, BoogieSymbolTable boogieSymbolTable, LiteralCollection literalCollection, IUltimateServiceProvider iUltimateServiceProvider, BoogieIcfgContainer boogieIcfgContainer, IBoogieSymbolTableVariableProvider iBoogieSymbolTableVariableProvider) {
        this.mLogger = iLogger;
        this.mLiteralCollection = literalCollection;
        this.mServices = iUltimateServiceProvider;
        this.mCfgSmtToolkit = boogieIcfgContainer.getCfgSmtToolkit();
        this.mRootAnnotation = boogieIcfgContainer;
        this.mSymbolTable = boogieSymbolTable;
        this.mBpl2SmtSymbolTable = iBoogieSymbolTableVariableProvider;
    }

    public ExplicitValueState createTopState() {
        return new ExplicitValueState(this.mLogger, false);
    }

    public ExplicitValueState createBottomState() {
        return new ExplicitValueState(this.mLogger, true);
    }

    public IAbstractStateBinaryOperator<ExplicitValueState> getWideningOperator() {
        if (this.mWideningOperator == null) {
            this.mWideningOperator = new ExplicitValueWideningOperator(this.mLiteralCollection);
        }
        return this.mWideningOperator;
    }

    public NonrelationalPostOperator<ExplicitValueState, BaseExplicitValueValue> getPostOperator() {
        if (this.mPostOperator == null) {
            IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
            int n = iPreferenceProvider.getInt("Parallel states before merging");
            int n2 = iPreferenceProvider.getInt("Maximum recursion depth of evaluation operations");
            ExplicitValueEvaluator explicitValueEvaluator = new ExplicitValueEvaluator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, n2);
            this.mPostOperator = new ExplicitValuePostOperator(this.mLogger, this.mSymbolTable, this.mBpl2SmtSymbolTable, n, this.mRootAnnotation.getBoogie2SMT(), this.mCfgSmtToolkit, explicitValueEvaluator);
        }
        return this.mPostOperator;
    }

    public boolean isAbstractable(Term term) {
        return false;
    }

    public void beforeFixpointComputation(Object ... objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof AbsIntBenchmark) {
                AbsIntBenchmark absIntBenchmark = (AbsIntBenchmark)object;
                this.getPostOperator().setAbsIntBenchmark(absIntBenchmark);
            }
            ++n2;
        }
    }
}

