/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UnaryOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;

public class UnaryExpressionAST
extends AtsASTNode {
    private static final long serialVersionUID = 1809386058471685881L;
    private UnaryOperatorAST moperator;

    public UnaryExpressionAST(ILocation iLocation) {
        super(iLocation);
        this.mReturnType = Integer.class;
        this.mExpectingType = this.mReturnType;
    }

    public UnaryExpressionAST(ILocation iLocation, VariableExpressionAST variableExpressionAST) {
        super(iLocation);
        this.mReturnType = Integer.class;
        this.mExpectingType = this.mReturnType;
        this.addOutgoingNode(variableExpressionAST);
    }

    public UnaryOperatorAST getOperator() {
        return this.moperator;
    }

    public void setOperator(UnaryOperatorAST unaryOperatorAST) {
        this.moperator = unaryOperatorAST;
    }

    public String toString() {
        return "UnaryExpression [" + UnaryExpressionAST.operatorToString(this.moperator) + "]";
    }

    private static String operatorToString(UnaryOperatorAST unaryOperatorAST) {
        return switch (unaryOperatorAST) {
            case UnaryOperatorAST.EXPR_PLUSPLUS -> " expr++ ";
            case UnaryOperatorAST.EXPR_MINUSMINUS -> " expr-- ";
            case UnaryOperatorAST.PLUSPLUS_EXPR -> " ++expr ";
            case UnaryOperatorAST.MINUSMINUS_EXPR -> " --expr ";
            default -> throw new MatchException(null, null);
        };
    }

    public String getOperatorAsString() {
        return UnaryExpressionAST.operatorToString(this.moperator);
    }

    @Override
    public String getAsString() {
        return switch (this.moperator) {
            case UnaryOperatorAST.EXPR_PLUSPLUS -> ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + "++";
            case UnaryOperatorAST.EXPR_MINUSMINUS -> ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + "--";
            case UnaryOperatorAST.PLUSPLUS_EXPR -> "++" + ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString();
            case UnaryOperatorAST.MINUSMINUS_EXPR -> "--" + ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString();
            default -> throw new MatchException(null, null);
        };
    }
}

