/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class Body
extends BoogieASTNode {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(Body.class);
    ILocation loc;
    VariableDeclaration[] localVars;
    Statement[] block;

    public Body(ILocation iLocation, VariableDeclaration[] variableDeclarationArray, Statement[] statementArray) {
        super(iLocation);
        this.loc = iLocation;
        this.localVars = variableDeclarationArray;
        this.block = statementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Body: " + String.valueOf((Object)this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Body").append('[');
        stringBuffer.append(this.loc);
        stringBuffer.append(',');
        if (this.localVars == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.localVars.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.localVars[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.block == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.block.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.block[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public ILocation getLoc() {
        return this.loc;
    }

    public void setLoc(ILocation iLocation) {
        if (this.loc != null && iLocation != this.loc) {
            throw new AssertionError((Object)"Value is only writeable once");
        }
        this.loc = iLocation;
    }

    public VariableDeclaration[] getLocalVars() {
        return this.localVars;
    }

    public Statement[] getBlock() {
        return this.block;
    }

    public void setBlock(Statement[] statementArray) {
        this.block = statementArray;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.localVars != null) {
            list.addAll(Arrays.asList(this.localVars));
        }
        if (this.block != null) {
            list.addAll(Arrays.asList(this.block));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.localVars != null) {
                boogieASTNodeArray = this.localVars;
                n2 = this.localVars.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VariableDeclaration)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.block != null) {
                boogieASTNodeArray = this.block;
                n2 = this.block.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Statement)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    public Body accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Body body = generatedBoogieAstTransformer.transform(this);
        if (body != this) {
            return body;
        }
        boolean bl = false;
        ArrayList<Statement[]> arrayList = new ArrayList<Statement[]>();
        if (this.localVars != null) {
            VariableDeclaration[] variableDeclarationArray = this.localVars;
            n = this.localVars.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = variableDeclarationArray[n2];
                object = (VariableDeclaration)((VariableDeclaration)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Statement[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.block != null) {
            object = this.block;
            int n3 = this.block.length;
            n = 0;
            while (n < n3) {
                Statement statement = object[n];
                Statement statement2 = statement.accept(generatedBoogieAstTransformer);
                bl = bl || statement2 != statement;
                ((ArrayList)object2).add(statement2);
                ++n;
            }
        }
        if (bl) {
            return new Body(this.loc, arrayList.toArray(new VariableDeclaration[0]), ((ArrayList)object2).toArray(new Statement[0]));
        }
        return this;
    }
}

