/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class HcPredicateSymbol {
    private final FunctionSymbol mFunctionSymbol;
    private final String mFunctionName;
    private final List<Sort> mParameterSorts;

    HcPredicateSymbol(HcSymbolTable hcSymbolTable, FunctionSymbol functionSymbol) {
        this.mFunctionSymbol = functionSymbol;
        if (functionSymbol == null) {
            assert (this instanceof HornClauseDontCarePredicateSymbol);
            this.mFunctionName = this.getName();
            this.mParameterSorts = null;
        } else {
            this.mFunctionName = functionSymbol.getName();
            this.mParameterSorts = Arrays.asList(functionSymbol.getParameterSorts());
        }
    }

    public FunctionSymbol getFunctionSymbol() {
        return this.mFunctionSymbol;
    }

    public String getName() {
        return this.mFunctionName;
    }

    public int getArity() {
        return this.mParameterSorts.size();
    }

    public List<Sort> getParameterSorts() {
        return this.mParameterSorts;
    }

    public String toString() {
        return this.mFunctionName;
    }

    public int hashCode() {
        return Objects.hash(this.mFunctionSymbol);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HcPredicateSymbol hcPredicateSymbol = (HcPredicateSymbol)object;
        return !(this.mFunctionSymbol == null ? hcPredicateSymbol.mFunctionSymbol != null : !this.mFunctionSymbol.equals(hcPredicateSymbol.mFunctionSymbol));
    }

    public static abstract class HornClauseConstantPredicateSymbol
    extends HcPredicateSymbol {
        HornClauseConstantPredicateSymbol(HcSymbolTable hcSymbolTable, FunctionSymbol functionSymbol, List<Sort> list) {
            super(hcSymbolTable, functionSymbol);
        }
    }

    public static class HornClauseDontCarePredicateSymbol
    extends HornClauseConstantPredicateSymbol {
        public HornClauseDontCarePredicateSymbol() {
            super(null, null, Collections.emptyList());
        }

        @Override
        public String getName() {
            return "DontCare";
        }

        @Override
        public int getArity() {
            return 0;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public static class HornClauseFalsePredicateSymbol
    extends HornClauseConstantPredicateSymbol {
        public HornClauseFalsePredicateSymbol(FunctionSymbol functionSymbol) {
            super(null, functionSymbol, Collections.emptyList());
        }

        @Override
        public String getName() {
            return "False";
        }

        @Override
        public int getArity() {
            return 0;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public static class HornClauseTruePredicateSymbol
    extends HornClauseConstantPredicateSymbol {
        public HornClauseTruePredicateSymbol(FunctionSymbol functionSymbol) {
            super(null, functionSymbol, Collections.emptyList());
        }

        @Override
        public String getName() {
            return "True";
        }

        @Override
        public int getArity() {
            return 0;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

