/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class YieldCode
implements ICode {
    private final EMatching mEMatching;
    private final QuantLiteral mQuantLiteral;
    private final TermVariable[] mVarOrder;
    private final Map<TermVariable, Integer> mVarPos;
    private final Map<Term, Integer> mEquivCCTermPos;

    public YieldCode(EMatching eMatching, QuantLiteral quantLiteral, TermVariable[] termVariableArray, Map<TermVariable, Integer> map, Map<Term, Integer> map2) {
        this.mEMatching = eMatching;
        this.mQuantLiteral = quantLiteral;
        this.mVarOrder = termVariableArray;
        this.mVarPos = map;
        this.mEquivCCTermPos = map2;
    }

    @Override
    public void execute(CCTerm[] cCTermArray, int n) {
        ArrayList<CCTerm> arrayList = new ArrayList<CCTerm>(this.mVarOrder.length);
        int n2 = 0;
        while (n2 < this.mVarOrder.length) {
            if (this.mVarPos.containsKey(this.mVarOrder[n2])) {
                arrayList.add(cCTermArray[this.mVarPos.get(this.mVarOrder[n2])]);
            } else {
                arrayList.add(null);
            }
            ++n2;
        }
        HashMap<Term, CCTerm> hashMap = new HashMap<Term, CCTerm>();
        for (Map.Entry<Term, Integer> entry : this.mEquivCCTermPos.entrySet()) {
            hashMap.put(entry.getKey(), cCTermArray[entry.getValue()]);
        }
        this.mEMatching.addInterestingSubstitution(this.mQuantLiteral, arrayList, hashMap, n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("yield(" + String.valueOf(this.mQuantLiteral));
        for (TermVariable termVariable : this.mVarPos.keySet()) {
            stringBuilder.append(", " + String.valueOf(termVariable));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

