/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ICoRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ConditionEventsCoRelationB32<LETTER, PLACE>
implements ICoRelation<LETTER, PLACE> {
    private static final boolean EXTENDED_ASSERTION_CHECKING = true;
    private long mQueryCounterYes;
    private long mQueryCounterNo;
    private final HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> mCoRelatedCutoffEvents = new HashRelation();
    private final HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> mCoRelatedNonCutoffEvents = new HashRelation();
    private final BranchingProcess<LETTER, PLACE> mBranchingProcess;

    public ConditionEventsCoRelationB32(BranchingProcess<LETTER, PLACE> branchingProcess) {
        this.mBranchingProcess = branchingProcess;
    }

    @Override
    public long getQueryCounterYes() {
        return this.mQueryCounterYes;
    }

    @Override
    public long getQueryCounterNo() {
        return this.mQueryCounterNo;
    }

    @Override
    public void initialize(Set<Condition<LETTER, PLACE>> set) {
    }

    private Stream<Event<LETTER, PLACE>> streamCoRelatedEvents(Condition<LETTER, PLACE> condition) {
        return Stream.concat(this.mCoRelatedCutoffEvents.getImage(condition).stream(), this.mCoRelatedNonCutoffEvents.getImage(condition).stream());
    }

    private Stream<Event<LETTER, PLACE>> streamNonCutoffCoRelatedEvents(Condition<LETTER, PLACE> condition) {
        return this.mCoRelatedNonCutoffEvents.getImage(condition).stream();
    }

    private Stream<Condition<LETTER, PLACE>> streamCoRelatedConditions(Condition<LETTER, PLACE> condition) {
        return Stream.concat(condition.getPredecessorEvent().getConditionMark().stream(), this.streamCoRelatedEvents(condition).flatMap(event -> event.getSuccessorConditions().stream()));
    }

    private Stream<Condition<LETTER, PLACE>> streamNonCutoffCoRelatedConditions(Condition<LETTER, PLACE> condition) {
        return Stream.concat(condition.getPredecessorEvent().getConditionMark().stream(), this.streamNonCutoffCoRelatedEvents(condition).flatMap(event -> event.getSuccessorConditions().stream()));
    }

    @Override
    public void update(Event<LETTER, PLACE> event) {
        if (event.getTransition() == null) {
            assert (event.getPredecessorConditions().isEmpty()) : "not initial event";
            return;
        }
        HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> hashRelation = event.isCutoffEvent() ? this.mCoRelatedCutoffEvents : this.mCoRelatedNonCutoffEvents;
        for (Condition<LETTER, PLACE> condition : event.getConditionMark()) {
            if (condition.getPredecessorEvent().equals(event)) continue;
            hashRelation.addPair(condition, event);
        }
        this.updateSingleMap(this.mCoRelatedCutoffEvents, hashRelation, event);
        this.updateSingleMap(this.mCoRelatedNonCutoffEvents, hashRelation, event);
    }

    private void updateSingleMap(HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> hashRelation, HashRelation<Condition<LETTER, PLACE>, Event<LETTER, PLACE>> hashRelation2, Event<LETTER, PLACE> event) {
        List list = event.getPredecessorConditions().stream().map(condition -> hashRelation.getImage(condition)).collect(Collectors.toList());
        Set set = DataStructureUtils.intersection(list);
        for (Event serializable : set) {
            for (Condition condition2 : serializable.getSuccessorConditions()) {
                hashRelation2.addPair(condition2, event);
            }
        }
        for (Condition condition3 : event.getSuccessorConditions()) {
            hashRelation.addAllPairs((Object)condition3, (Collection)set);
        }
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        boolean bl;
        boolean bl2 = bl = this.mCoRelatedNonCutoffEvents.containsPair(condition, condition2.getPredecessorEvent()) || this.mCoRelatedCutoffEvents.containsPair(condition, condition2.getPredecessorEvent()) || condition.getPredecessorEvent().conditionMarkContains(condition2);
        assert (bl == this.isInCoRelationNaive(condition, condition2)) : String.format("contradictory co-Relation for %s,%s: normal=%b != %b=naive", condition, condition2, bl, !bl);
        if (bl) {
            ++this.mQueryCounterYes;
        } else {
            ++this.mQueryCounterNo;
        }
        return bl;
    }

    private boolean isInCoRelationNaive(Condition<LETTER, PLACE> condition, Condition<LETTER, PLACE> condition2) {
        return !this.mBranchingProcess.inCausalRelation(condition, condition2) && !this.mBranchingProcess.inConflict(condition, condition2);
    }

    public boolean isInIrreflexiveCoRelation(Event<LETTER, PLACE> event, Event<LETTER, PLACE> event2) {
        if (event == event2) {
            return false;
        }
        if (this.mBranchingProcess.getDummyRoot() == event || this.mBranchingProcess.getDummyRoot() == event2) {
            return false;
        }
        Set<Condition<LETTER, PLACE>> set = event.getPredecessorConditions();
        Set<Condition<LETTER, PLACE>> set2 = event2.getPredecessorConditions();
        for (Condition condition : set) {
            if (!set2.contains(condition) && this.isCoset(set2, condition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInCoRelation(Condition<LETTER, PLACE> condition, Event<LETTER, PLACE> event) {
        if (event.getPredecessorConditions().contains(condition)) {
            return false;
        }
        return this.isCoset(event.getPredecessorConditions(), condition);
    }

    @Override
    public boolean isCoset(Collection<Condition<LETTER, PLACE>> collection, Condition<LETTER, PLACE> condition) {
        for (Condition<LETTER, PLACE> condition2 : collection) {
            if (this.isInCoRelation(condition, condition2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.mCoRelatedCutoffEvents.toString() + this.mCoRelatedNonCutoffEvents.toString();
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition) {
        Set<Condition<LETTER, PLACE>> set = this.streamCoRelatedConditions(condition).collect(Collectors.toSet());
        assert (set.equals(this.computeCoRelatatedConditionsInefficient(condition))) : "inconsistent co-relation information";
        return set;
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeNonCutoffCoRelatatedConditions(Condition<LETTER, PLACE> condition) {
        Set<Condition<LETTER, PLACE>> set = this.streamNonCutoffCoRelatedConditions(condition).collect(Collectors.toSet());
        return set;
    }

    private Set<Condition<LETTER, PLACE>> computeCoRelatatedConditionsInefficient(Condition<LETTER, PLACE> condition) {
        HashSet<Condition<LETTER, PLACE>> hashSet = new HashSet<Condition<LETTER, PLACE>>();
        for (Condition<LETTER, PLACE> condition2 : this.mBranchingProcess.getConditions()) {
            if (!this.isInCoRelation(condition, condition2)) continue;
            hashSet.add(condition2);
        }
        return hashSet;
    }

    @Override
    public int computeMaximalDegree() {
        ToIntFunction<Condition> toIntFunction = condition -> this.streamCoRelatedEvents((Condition<LETTER, PLACE>)condition).mapToInt(event -> event.getSuccessorConditions().size()).sum();
        return this.mCoRelatedCutoffEvents.getDomain().stream().mapToInt(toIntFunction).max().orElse(0);
    }

    @Override
    public Set<Condition<LETTER, PLACE>> computeCoRelatatedConditions(Condition<LETTER, PLACE> condition2, PLACE PLACE) {
        return this.streamCoRelatedConditions(condition2).filter(condition -> condition.getPlace().equals(PLACE)).collect(Collectors.toSet());
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Event<LETTER, PLACE> event) {
        Set<Condition<LETTER, PLACE>> set = event.getSuccessorConditions();
        if (set.isEmpty()) {
            throw new UnsupportedOperationException("event without successor conditions");
        }
        Iterator<Condition<LETTER, PLACE>> iterator = set.iterator();
        Condition<LETTER, PLACE> condition = iterator.next();
        Set<Event<LETTER, PLACE>> set2 = this.streamCoRelatedEvents(condition).collect(Collectors.toSet());
        while (iterator.hasNext()) {
            Condition<LETTER, PLACE> condition2 = iterator.next();
            Set set3 = this.streamCoRelatedEvents(condition2).collect(Collectors.toSet());
            set2.retainAll(set3);
        }
        return set2;
    }

    @Override
    public Set<Event<LETTER, PLACE>> computeCoRelatatedEvents(Condition<LETTER, PLACE> condition) {
        return this.streamCoRelatedEvents(condition).collect(Collectors.toSet());
    }
}

