/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsType;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.Collection;
import java.util.List;

public class TraceCheckStatisticsGenerator
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private int mNumberOfCodeBlocks = 0;
    private int mNumberOfCodeBlocksAsserted = 0;
    private int mNumberOfCheckSat = 0;
    private int mConstructedInterpolants = 0;
    private int mQuantifiedInterpolants = 0;
    private long mSizeOfPredicates = 0L;
    private int mNumberOfNonLiveVariables = 0;
    private int mConjunctsInSsa = 0;
    private int mConjunctsInUnsatCore = 0;
    private int mInterpolantComputations = 0;
    private int mPerfectInterpolantSequences = 0;
    private CoverageAnalysis.BackwardCoveringInformation mInterpolantCoveringCapability = new CoverageAnalysis.BackwardCoveringInformation(0, 0);
    private final boolean mCollectInterpolatSequenceStatistics;

    public TraceCheckStatisticsGenerator(boolean bl) {
        this.mCollectInterpolatSequenceStatistics = bl;
    }

    public IStatisticsType getBenchmarkType() {
        return TraceCheckStatisticsType.getInstance();
    }

    public void reportNewCodeBlocks(int n) {
        this.mNumberOfCodeBlocks += n;
    }

    public void reportNewAssertedCodeBlocks(int n) {
        this.mNumberOfCodeBlocksAsserted += n;
    }

    public void reportNewCheckSat() {
        ++this.mNumberOfCheckSat;
    }

    public void setConjunctsInSSA(int n, int n2) {
        assert (this.mConjunctsInSsa == 0) : "have already been set";
        assert (this.mConjunctsInUnsatCore == 0) : "have already been set";
        this.mConjunctsInSsa = n;
        this.mConjunctsInUnsatCore = n2;
    }

    public void reportSequenceOfInterpolants(List<IPredicate> list, InterpolantType interpolantType) {
        if (!this.mCollectInterpolatSequenceStatistics) {
            return;
        }
        for (IPredicate iPredicate : list) {
            boolean bl;
            ++this.mConstructedInterpolants;
            boolean bl2 = bl = !QuantifierUtils.isQuantifierFree((Term)iPredicate.getFormula());
            if (!bl) continue;
            ++this.mQuantifiedInterpolants;
        }
        this.mSizeOfPredicates += TraceCheckStatisticsGenerator.computeLongSumOfIntArray(PredicateUtils.computeDagSizeOfPredicates(list, (PredicateUtils.FormulaSize)PredicateUtils.FormulaSize.TREESIZE));
    }

    private static long computeLongSumOfIntArray(long[] lArray) {
        long l = 0L;
        long[] lArray2 = lArray;
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l2 = lArray2[n2];
            l += l2;
            ++n2;
        }
        return l;
    }

    public void reportNumberOfNonLiveVariables(int n, InterpolantType interpolantType) {
        this.mNumberOfNonLiveVariables += n;
    }

    public void reportInterpolantComputation() {
        ++this.mInterpolantComputations;
    }

    public void reportPerfectInterpolantSequences() {
        ++this.mPerfectInterpolantSequences;
    }

    public void addBackwardCoveringInformation(CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation) {
        this.mInterpolantCoveringCapability = new CoverageAnalysis.BackwardCoveringInformation(this.mInterpolantCoveringCapability, backwardCoveringInformation);
    }

    public Object getValue(String string) {
        Object object;
        TraceCheckStatisticsDefinitions traceCheckStatisticsDefinitions = TraceCheckStatisticsDefinitions.valueOf(string);
        switch (traceCheckStatisticsDefinitions) {
            case SsaConstructionTime: 
            case SatisfiabilityAnalysisTime: 
            case InterpolantComputationTime: {
                try {
                    object = this.getElapsedTime(string);
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            case NumberOfCodeBlocks: {
                object = this.mNumberOfCodeBlocks;
                break;
            }
            case NumberOfCodeBlocksAsserted: {
                object = this.mNumberOfCodeBlocksAsserted;
                break;
            }
            case NumberOfCheckSat: {
                object = this.mNumberOfCheckSat;
                break;
            }
            case ConstructedInterpolants: {
                object = this.mConstructedInterpolants;
                break;
            }
            case QuantifiedInterpolants: {
                object = this.mQuantifiedInterpolants;
                break;
            }
            case SizeOfPredicates: {
                object = this.mSizeOfPredicates;
                break;
            }
            case NumberOfNonLiveVariables: {
                object = this.mNumberOfNonLiveVariables;
                break;
            }
            case ConjunctsInSsa: {
                object = this.mConjunctsInSsa;
                break;
            }
            case ConjunctsInUnsatCore: {
                object = this.mConjunctsInUnsatCore;
                break;
            }
            case InterpolantComputations: {
                object = this.mInterpolantComputations;
                break;
            }
            case PerfectInterpolantSequences: {
                object = this.mPerfectInterpolantSequences;
                break;
            }
            case InterpolantCoveringCapability: {
                object = this.mInterpolantCoveringCapability;
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return object;
    }

    public String[] getStopwatches() {
        return new String[]{TraceCheckStatisticsDefinitions.SsaConstructionTime.toString(), TraceCheckStatisticsDefinitions.SatisfiabilityAnalysisTime.toString(), TraceCheckStatisticsDefinitions.InterpolantComputationTime.toString()};
    }

    public Collection<String> getKeys() {
        return TraceCheckStatisticsType.getInstance().getKeys();
    }

    public boolean isCollectingInterpolantSequenceStatistics() {
        return this.mCollectInterpolatSequenceStatistics;
    }

    public static enum InterpolantType {
        Craig,
        Forward,
        Backward;

    }
}

