/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EliminationTask;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.ArithmeticUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class DualJunctionDml
extends DualJunctionQuantifierElimination {
    private static final boolean POSTPONE_ELIMINATEES_NOT_YET_PROMISING = true;
    private static final boolean EXCLUDE_CORRESPONDING_FINITE_JUNCTIONS = true;
    private static final boolean OMIT_NON_PROMISING_DIV_ELIMINATIONS = true;

    public DualJunctionDml(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider);
    }

    @Override
    public String getName() {
        return "div mod liberation";
    }

    @Override
    public String getAcronym() {
        return "DML";
    }

    public List<DmlPossibility> findAllDmlPossibilities(EliminationTask eliminationTask) {
        ArrayList<DmlPossibility> arrayList = new ArrayList<DmlPossibility>();
        Term[] termArray = QuantifierUtils.getDualFiniteJuncts(eliminationTask.getQuantifier(), eliminationTask.getTerm());
        for (TermVariable termVariable : eliminationTask.getEliminatees()) {
            boolean bl = false;
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray2[n2];
                if (QuantifierUtils.isCorrespondingFiniteJunction(eliminationTask.getQuantifier(), term)) {
                    if (Arrays.asList(term.getFreeVars()).contains(termVariable)) {
                        bl = true;
                    }
                } else {
                    Set<ApplicationTerm> set = SmtUtils.extractApplicationTerms(Set.of("div", "mod"), term, false);
                    for (ApplicationTerm applicationTerm : set) {
                        assert (applicationTerm.getFunction().getApplicationString().equals("div") || applicationTerm.getFunction().getApplicationString().equals("mod"));
                        assert (applicationTerm.getParameters().length == 2);
                        Term term2 = applicationTerm.getParameters()[1];
                        Object object = SmtUtils.tryToConvertToLiteral(term2);
                        if (object == null) continue;
                        assert (!object.numerator().equals(BigInteger.ZERO));
                        assert (object.denominator().equals(BigInteger.ONE));
                        if (object.isNegative()) {
                            throw new AssertionError((Object)"UltimateNormalForm makes sure that divisors are non-negative");
                        }
                        BigInteger bigInteger = object.numerator();
                        term2 = applicationTerm.getParameters()[0];
                        if (!Arrays.asList(term2.getFreeVars()).contains(termVariable) || (object = CoeffcientEliminateeOffset.of(this.mScript, termVariable, term2)) == null) continue;
                        BigInteger bigInteger2 = bigInteger.gcd(((CoeffcientEliminateeOffset)object).getCoefficient());
                        if (bigInteger2.compareTo(BigInteger.ZERO) <= 0) {
                            throw new AssertionError((Object)"Expected that GCD is always positive");
                        }
                        if (!bigInteger2.equals(BigInteger.valueOf(1L))) continue;
                        Object object2 = ArithmeticUtils.multiplicativeInverse((BigInteger)((CoeffcientEliminateeOffset)object).getCoefficient(), (BigInteger)bigInteger);
                        Object object3 = ((CoeffcientEliminateeOffset)object).getCoefficient().compareTo(BigInteger.ZERO) < 0 ? ((BigInteger)object2).subtract(bigInteger.abs()) : object2;
                        object2 = new DmlPossibility(applicationTerm.getFunction().getApplicationString(), (CoeffcientEliminateeOffset)object, bigInteger, term, (BigInteger)object3, (Term)applicationTerm, bl);
                        arrayList.add((DmlPossibility)object2);
                    }
                }
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    public DualJunctionQuantifierElimination.EliminationResult tryToEliminate(EliminationTask eliminationTask) {
        List<DmlPossibility> list = this.findAllDmlPossibilities(eliminationTask);
        if (list.isEmpty()) {
            return null;
        }
        TreeSet<DualJunctionQuantifierElimination.EliminationResult> treeSet = new TreeSet<DualJunctionQuantifierElimination.EliminationResult>();
        for (DmlPossibility dmlPossibility : list) {
            DualJunctionQuantifierElimination.EliminationResult eliminationResult;
            if (dmlPossibility.getFunName().equals("mod")) {
                eliminationResult = this.applyElimination(eliminationTask, dmlPossibility);
            } else if (dmlPossibility.getFunName().equals("div")) {
                if (!dmlPossibility.getCoefficient().abs().equals(BigInteger.ONE)) continue;
                eliminationResult = this.applyElimination(eliminationTask, dmlPossibility);
            } else {
                throw new AssertionError();
            }
            DualJunctionQuantifierElimination.EliminationResult eliminationResult2 = this.tryImmediateDer(eliminationResult);
            assert (eliminationResult2.getNewEliminatees().size() <= 2);
            if (dmlPossibility.doesEliminateeOccurInCorrespondingFiniteJunction() && eliminationResult2.getNewEliminatees().size() > 0) continue;
            treeSet.add(eliminationResult2);
        }
        if (!treeSet.isEmpty()) {
            return (DualJunctionQuantifierElimination.EliminationResult)treeSet.iterator().next();
        }
        return null;
    }

    private DualJunctionQuantifierElimination.EliminationResult tryImmediateDer(DualJunctionQuantifierElimination.EliminationResult eliminationResult) {
        DualJunctionQuantifierElimination.EliminationResult eliminationResult2;
        DualJunctionDer dualJunctionDer = new DualJunctionDer(this.mMgdScript, this.mServices, false);
        EliminationTask eliminationTask = eliminationResult.integrateNewEliminatees();
        DualJunctionQuantifierElimination.EliminationResult eliminationResult3 = dualJunctionDer.tryToEliminate(eliminationTask);
        if (eliminationResult3 == null) {
            eliminationResult2 = eliminationResult;
        } else {
            if (!eliminationResult3.getNewEliminatees().isEmpty()) {
                throw new AssertionError((Object)"DER cannot add new eliminatees");
            }
            eliminationResult2 = this.extractNewEliminatees(eliminationResult3.getEliminationTask(), eliminationResult.getNewEliminatees());
        }
        return eliminationResult2;
    }

    private DualJunctionQuantifierElimination.EliminationResult extractNewEliminatees(EliminationTask eliminationTask, Set<TermVariable> set) {
        Set<TermVariable> set2 = eliminationTask.getEliminatees().stream().filter(termVariable -> !set.contains(termVariable)).collect(Collectors.toSet());
        Set<TermVariable> set3 = eliminationTask.getEliminatees().stream().filter(termVariable -> set.contains(termVariable)).collect(Collectors.toSet());
        EliminationTask eliminationTask2 = new EliminationTask(eliminationTask.getQuantifier(), set2, eliminationTask.getTerm(), eliminationTask.getContext());
        return new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, set3);
    }

    private DualJunctionQuantifierElimination.EliminationResult applyElimination(EliminationTask eliminationTask, DmlPossibility dmlPossibility) throws AssertionError {
        Term term;
        TermVariable termVariable = this.mMgdScript.constructFreshTermVariable("y", SmtSortUtils.getIntSort(this.mScript));
        TermVariable termVariable2 = this.mMgdScript.constructFreshTermVariable("z", SmtSortUtils.getIntSort(this.mScript));
        Term term2 = SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getDivisor());
        Term term3 = SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getInverse());
        if (dmlPossibility.getFunName().equals("mod")) {
            term = this.applyModElimination(eliminationTask, dmlPossibility, termVariable, termVariable2, term2, term3);
        } else if (dmlPossibility.getFunName().equals("div")) {
            term = this.applyDivElimination(eliminationTask, dmlPossibility, termVariable, termVariable2, term2, term3);
        } else {
            throw new AssertionError();
        }
        Term term4 = SmtUtils.simplify(this.mMgdScript, term, this.mServices, SmtUtils.SimplificationTechnique.POLY_PAC);
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(eliminationTask.getEliminatees());
        hashSet.remove(dmlPossibility.getEliminate());
        EliminationTask eliminationTask2 = new EliminationTask(eliminationTask.getQuantifier(), hashSet, term4, eliminationTask.getContext());
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>();
        hashSet2.add(termVariable);
        hashSet2.add(termVariable2);
        DualJunctionQuantifierElimination.EliminationResult eliminationResult = new DualJunctionQuantifierElimination.EliminationResult(eliminationTask2, hashSet2);
        return eliminationResult;
    }

    private Term applyModElimination(EliminationTask eliminationTask, DmlPossibility dmlPossibility, TermVariable termVariable, TermVariable termVariable2, Term term, Term term2) {
        Term term3 = this.replaceModTerm(eliminationTask, dmlPossibility, termVariable2, term);
        Term term4 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{term, termVariable});
        Term term5 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{term2, termVariable2});
        Term term6 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), term4, term5);
        Map<TermVariable, Term> map = Collections.singletonMap(dmlPossibility.getEliminate(), term6);
        Term term7 = Substitution.apply(this.mMgdScript, map, term3);
        term4 = this.constructInterval(eliminationTask.getQuantifier(), termVariable2, term);
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, eliminationTask.getQuantifier(), term7, term4);
    }

    private Term dissolveIte(Term term) {
        Term term2 = new IteRemover(this.mMgdScript).transform(term);
        return new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term2);
    }

    private Term constructInterval(int n, TermVariable termVariable, Term term) {
        Term term2;
        Term term3 = SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), BigInteger.ZERO);
        if (n == 0) {
            Term term4 = SmtUtils.geq(this.mScript, (Term)termVariable, term3);
            Term term5 = SmtUtils.less(this.mScript, (Term)termVariable, term);
            term2 = SmtUtils.and(this.mScript, term4, term5);
        } else if (n == 1) {
            Term term6 = SmtUtils.less(this.mScript, (Term)termVariable, term3);
            Term term7 = SmtUtils.geq(this.mScript, (Term)termVariable, term);
            term2 = SmtUtils.or(this.mScript, term6, term7);
        } else {
            throw new AssertionError((Object)"Illegal Quantifier");
        }
        return term2;
    }

    private Term replaceModTerm(EliminationTask eliminationTask, DmlPossibility dmlPossibility, TermVariable termVariable, Term term) {
        Object object;
        TermVariable termVariable2;
        if (SmtUtils.tryToConvertToLiteral(dmlPossibility.getOffset()) != null && SmtUtils.tryToConvertToLiteral(dmlPossibility.getOffset()).equals((Object)Rational.ZERO)) {
            termVariable2 = termVariable;
        } else {
            object = SmtUtils.mod(this.mScript, dmlPossibility.getOffset(), term);
            Term term2 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{termVariable, object});
            Term term3 = SmtUtils.minus(this.mScript, term2, term);
            Term term4 = SmtUtils.geq(this.mScript, term2, term);
            termVariable2 = SmtUtils.ite(this.mScript, term4, term3, term2);
        }
        object = Collections.singletonMap(dmlPossibility.getDmlSubterm(), termVariable2);
        return this.dissolveIte(Substitution.apply(this.mMgdScript, (Map<? extends Term, ? extends Term>)object, eliminationTask.getTerm()));
    }

    private Term replaceDivTerm(EliminationTask eliminationTask, DmlPossibility dmlPossibility, TermVariable termVariable, TermVariable termVariable2, Term term, Term term2) {
        Term term3;
        Term term4;
        Term term5 = SmtUtils.divInt(this.mScript, dmlPossibility.getOffset(), SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getDivisor()));
        Term term6 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getCoefficient()), termVariable});
        Term term7 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), term6, term5);
        Term term8 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{term2, termVariable2});
        Term term9 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), term7, term8);
        if (SmtUtils.tryToConvertToLiteral(dmlPossibility.getOffset()) != null && SmtUtils.tryToConvertToLiteral(dmlPossibility.getOffset()).equals((Object)Rational.ZERO)) {
            term4 = term9;
        } else {
            Term term10;
            term3 = SmtUtils.mod(this.mScript, dmlPossibility.getOffset(), SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getDivisor()));
            Term term11 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{term3, termVariable2});
            Term term12 = term10 = SmtUtils.less(this.mScript, term11, term);
            Term term13 = term9;
            Term term14 = SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), BigInteger.ONE);
            Term term15 = SmtUtils.sum(this.mScript, term9.getSort(), term9, term14);
            term4 = SmtUtils.ite(this.mScript, term12, term13, term15);
        }
        term3 = Collections.singletonMap(dmlPossibility.getDmlSubterm(), term4);
        return this.dissolveIte(Substitution.apply(this.mMgdScript, (Map<? extends Term, ? extends Term>)term3, eliminationTask.getTerm()));
    }

    private Term applyDivElimination(EliminationTask eliminationTask, DmlPossibility dmlPossibility, TermVariable termVariable, TermVariable termVariable2, Term term, Term term2) {
        BigInteger bigInteger = dmlPossibility.getCoefficient();
        BigInteger bigInteger2 = bigInteger.multiply(dmlPossibility.getInverse());
        BigInteger bigInteger3 = bigInteger2.divide(dmlPossibility.getDivisor());
        BigInteger bigInteger4 = bigInteger2.mod(dmlPossibility.getDivisor().abs());
        assert (bigInteger2.equals(bigInteger3.multiply(dmlPossibility.getDivisor()).add(BigInteger.ONE)));
        BigInteger bigInteger5 = bigInteger4.abs();
        int n = bigInteger5.intValue();
        if (n != 1) {
            throw new AssertionError((Object)"Remainder not 1");
        }
        Term term3 = SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), bigInteger3);
        bigInteger = this.replaceDivTerm(eliminationTask, dmlPossibility, termVariable, termVariable2, term, term3);
        bigInteger3 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{SmtUtils.constructIntegerValue(this.mScript, SmtSortUtils.getIntSort(this.mScript), dmlPossibility.getDivisor()), termVariable});
        bigInteger4 = SmtUtils.mul(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{term2, termVariable2});
        bigInteger5 = SmtUtils.sum(this.mScript, SmtSortUtils.getIntSort(this.mScript), new Term[]{bigInteger3, bigInteger4});
        Map<TermVariable, BigInteger> map = Collections.singletonMap(dmlPossibility.getEliminate(), bigInteger5);
        bigInteger2 = Substitution.apply(this.mMgdScript, map, (Term)bigInteger);
        bigInteger3 = this.constructInterval(eliminationTask.getQuantifier(), termVariable2, term);
        return QuantifierUtils.applyDualFiniteConnective(this.mScript, eliminationTask.getQuantifier(), new Term[]{bigInteger2, bigInteger3});
    }

    private static class CoeffcientEliminateeOffset {
        final BigInteger mCoefficient;
        final TermVariable mEliminatee;
        final Term mOffset;

        private CoeffcientEliminateeOffset(BigInteger bigInteger, TermVariable termVariable, Term term) {
            this.mCoefficient = bigInteger;
            this.mEliminatee = termVariable;
            this.mOffset = term;
        }

        public BigInteger getCoefficient() {
            return this.mCoefficient;
        }

        public TermVariable getEliminatee() {
            return this.mEliminatee;
        }

        public Term getOffset() {
            return this.mOffset;
        }

        public static CoeffcientEliminateeOffset of(Script script, TermVariable termVariable, Term term) {
            AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(script).transform(term);
            Map<Term, Rational> map = affineTerm.getVariable2Coefficient();
            HashMap<Term, Rational> hashMap = new HashMap<Term, Rational>();
            for (Map.Entry<Term, Rational> object2 : map.entrySet()) {
                if (object2.getKey() == termVariable) continue;
                hashMap.put(object2.getKey(), object2.getValue());
            }
            AffineTerm affineTerm2 = new AffineTerm(affineTerm.getSort(), affineTerm.getConstant(), (Map<Term, Rational>)hashMap);
            Term term2 = affineTerm2.toTerm(script);
            if (Arrays.asList(term2.getFreeVars()).contains(termVariable)) {
                return null;
            }
            Rational rational = map.get(termVariable);
            if (rational == null) {
                return null;
            }
            assert (rational.denominator().equals(BigInteger.ONE));
            return new CoeffcientEliminateeOffset(rational.numerator(), termVariable, term2);
        }
    }

    private static class DmlPossibility {
        private final String mFunName;
        final BigInteger mDivisor;
        final Term mContainingDualJunct;
        final BigInteger mInverse;
        final Term mDmlSubterm;
        private final CoeffcientEliminateeOffset mCeo;
        private final boolean mEliminateeOccursInCorrespondingFiniteJunction;

        DmlPossibility(String string, CoeffcientEliminateeOffset coeffcientEliminateeOffset, BigInteger bigInteger, Term term, BigInteger bigInteger2, Term term2, boolean bl) {
            if (!string.equals("div") && !string.equals("mod")) {
                throw new IllegalArgumentException("Neither div nor mod");
            }
            if (string.equals("mod") && coeffcientEliminateeOffset.getCoefficient().compareTo(BigInteger.ZERO) <= 0) {
                throw new IllegalArgumentException("For mod, the coefficient must be positive");
            }
            if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                throw new AssertionError((Object)"Negative divisors should have been replaced by our normal form.");
            }
            this.mCeo = coeffcientEliminateeOffset;
            this.mFunName = string;
            this.mDivisor = bigInteger;
            this.mContainingDualJunct = term;
            this.mInverse = bigInteger2;
            this.mDmlSubterm = term2;
            this.mEliminateeOccursInCorrespondingFiniteJunction = bl;
        }

        public String getFunName() {
            return this.mFunName;
        }

        public BigInteger getInverse() {
            return this.mInverse;
        }

        public BigInteger getCoefficient() {
            return this.mCeo.getCoefficient();
        }

        public Term getContainingDualJunct() {
            return this.mContainingDualJunct;
        }

        public Term getOffset() {
            return this.mCeo.getOffset();
        }

        public TermVariable getEliminate() {
            return this.mCeo.getEliminatee();
        }

        public Term getDmlSubterm() {
            return this.mDmlSubterm;
        }

        public BigInteger getDivisor() {
            return this.mDivisor;
        }

        public boolean doesEliminateeOccurInCorrespondingFiniteJunction() {
            return this.mEliminateeOccursInCorrespondingFiniteJunction;
        }
    }
}

