/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.SpoilerVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DelayedGameGraph<LETTER, STATE>
extends AGameGraph<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mBuechi;
    private long mGraphBuildTime;
    private final AutomataLibraryServices mServices;

    public DelayedGameGraph(AutomataLibraryServices automataLibraryServices, IMergeStateFactory<STATE> iMergeStateFactory, IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMergeStateFactory, iProgressAwareTimer, iLogger, iNestedWordAutomaton);
        INestedWordAutomaton iNestedWordAutomaton2 = this.getAutomaton();
        this.verifyAutomatonValidity(iNestedWordAutomaton2);
        this.mServices = automataLibraryServices;
        this.mBuechi = iNestedWordAutomaton2;
        this.mGraphBuildTime = 0L;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
        SimulationPerformance simulationPerformance = this.getSimulationPerformance();
        if (simulationPerformance != null) {
            simulationPerformance.startTimeMeasure(TimeMeasure.BUILD_RESULT);
        }
        ArrayList<STATE> arrayList = new ArrayList<STATE>(this.mBuechi.getStates());
        boolean[][] blArray = new boolean[arrayList.size()][arrayList.size()];
        for (SpoilerVertex object2 : this.getSpoilerVertices()) {
            boolean hashMap;
            if (object2.isB()) {
                hashMap = this.mBuechi.isFinal(object2.getQ0()) && !this.mBuechi.isFinal(object2.getQ1());
            } else {
                boolean bl = hashMap = !this.mBuechi.isFinal(object2.getQ0()) || this.mBuechi.isFinal(object2.getQ1());
            }
            if (hashMap && object2.getPM(null, this.getGlobalInfinity()) < this.getGlobalInfinity()) {
                blArray[arrayList.indexOf(object2.getQ0())][arrayList.indexOf(object2.getQ1())] = true;
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomaton/filling table");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        boolean[] blArray2 = new boolean[arrayList.size()];
        HashSet hashSet = new HashSet();
        HashMap hashMap = new HashMap();
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(this.mServices, this.mBuechi.getVpAlphabet(), this.getStateFactory());
        int STATE = 0;
        while (STATE < arrayList.size()) {
            if (!blArray2[STATE]) {
                hashSet.clear();
                hashSet.add(arrayList.get(STATE));
                blArray2[STATE] = true;
                boolean bl = this.mBuechi.isFinal(arrayList.get(STATE));
                boolean bl2 = this.mBuechi.isInitial(arrayList.get(STATE));
                int n = STATE;
                while (n < arrayList.size()) {
                    if (blArray[STATE][n] && blArray[n][STATE] && !blArray2[n]) {
                        hashSet.add(arrayList.get(n));
                        blArray2[n] = true;
                        if (this.mBuechi.isFinal(arrayList.get(n))) {
                            bl = true;
                        }
                        if (this.mBuechi.isInitial(arrayList.get(n))) {
                            bl2 = true;
                        }
                    }
                    ++n;
                }
                Iterator<Object> n2 = this.getStateFactory().merge(hashSet);
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    hashMap.put(object, n2);
                }
                nestedWordAutomaton.addState(bl2, bl, n2);
                blArray2[STATE] = true;
                if (this.getProgressTimer() != null && !this.getProgressTimer().continueProcessing()) {
                    this.getLogger().debug((Object)"Stopped in generateBuchiAutomaton/adding states to result BA");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
            ++STATE;
        }
        for (STATE STATE2 : this.mBuechi.getStates()) {
            for (Object LETTER : this.mBuechi.getVpAlphabet().getInternalAlphabet()) {
                for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(STATE2, LETTER)) {
                    Object v = hashMap.get(STATE2);
                    Object v2 = hashMap.get(outgoingInternalTransition.getSucc());
                    nestedWordAutomaton.addInternalTransition((Iterator<Object>)v, LETTER, (Iterator<Object>)v2);
                }
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateBuchiAutomaton/adding edges");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (simulationPerformance != null) {
            simulationPerformance.stopTimeMeasure(TimeMeasure.BUILD_RESULT);
            simulationPerformance.addTimeMeasureValue(TimeMeasure.BUILD_GRAPH, this.mGraphBuildTime);
        }
        return nestedWordAutomaton;
    }

    @Override
    public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
        Object object22;
        long l = System.currentTimeMillis();
        for (Object object22 : this.mBuechi.getStates()) {
            for (STATE STATE : this.mBuechi.getStates()) {
                SpoilerVertex spoilerVertex = new SpoilerVertex(0, false, object22, STATE);
                this.addSpoilerVertex(spoilerVertex);
                if (this.mBuechi.isFinal(STATE)) continue;
                spoilerVertex = new SpoilerVertex(1, true, object22, STATE);
                this.addSpoilerVertex(spoilerVertex);
                this.increaseGlobalInfinity();
            }
            if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
            this.getLogger().debug((Object)"Stopped in generateGameGraph/calculating v1");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        for (Object object22 : this.mBuechi.getStates()) {
            boolean bl = false;
            for (Iterator<STATE> iterator : this.mBuechi.getStates()) {
                for (LETTER LETTER : this.mBuechi.lettersInternalIncoming(object22)) {
                    Iterator<STATE> iterator2;
                    if (!this.mBuechi.internalPredecessors(object22, LETTER).iterator().hasNext()) continue;
                    DuplicatorVertex<LETTER, Iterator<STATE>> duplicatorVertex = new DuplicatorVertex<LETTER, Iterator<STATE>>(2, false, object22, iterator, LETTER);
                    this.addDuplicatorVertex(duplicatorVertex);
                    for (OutgoingInternalTransition<LETTER, Iterator<STATE>> outgoingInternalTransition : this.mBuechi.internalSuccessors(iterator, LETTER)) {
                        iterator2 = outgoingInternalTransition.getSucc();
                        this.addEdge(duplicatorVertex, this.getSpoilerVertex(object22, iterator2, false));
                    }
                    for (IncomingInternalTransition incomingInternalTransition : this.mBuechi.internalPredecessors(object22, LETTER)) {
                        iterator2 = incomingInternalTransition.getPred();
                        if (this.mBuechi.isFinal(object22)) continue;
                        this.addEdge(this.getSpoilerVertex(iterator2, iterator, false), duplicatorVertex);
                    }
                    duplicatorVertex = new DuplicatorVertex<LETTER, Iterator<Iterator<STATE>>>(2, true, object22, iterator, LETTER);
                    this.addDuplicatorVertex(duplicatorVertex);
                    for (OutgoingInternalTransition outgoingInternalTransition : this.mBuechi.internalSuccessors(iterator, LETTER)) {
                        iterator2 = outgoingInternalTransition.getSucc();
                        if (!this.mBuechi.isFinal(iterator2) && this.getAmountOfBitsForSpoilerVertices(object22, iterator2) > 1) {
                            this.addEdge(duplicatorVertex, this.getSpoilerVertex(object22, iterator2, true));
                            continue;
                        }
                        this.addEdge(duplicatorVertex, this.getSpoilerVertex(object22, iterator2, false));
                    }
                    for (IncomingInternalTransition incomingInternalTransition : this.mBuechi.internalPredecessors(object22, LETTER)) {
                        iterator2 = incomingInternalTransition.getPred();
                        if (this.getAmountOfBitsForSpoilerVertices(iterator2, iterator) > 1) {
                            this.addEdge(this.getSpoilerVertex(iterator2, iterator, true), duplicatorVertex);
                        }
                        if (!this.mBuechi.isFinal(object22)) continue;
                        this.addEdge(this.getSpoilerVertex(iterator2, iterator, false), duplicatorVertex);
                    }
                }
                bl = true;
                if (this.getProgressTimer() == null || this.getProgressTimer().continueProcessing()) continue;
                this.getLogger().debug((Object)"Stopped in generateGameGraph/calculating v0 and edges");
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        this.increaseGlobalInfinity();
        object22 = this.getLogger();
        if (object22.isDebugEnabled()) {
            object22.debug((Object)("Infinity is " + this.getGlobalInfinity()));
            object22.debug((Object)("Number of vertices in game graph: " + (this.getDuplicatorVertices().size() + this.getSpoilerVertices().size())));
            object22.debug((Object)("Number of vertices in v0: " + this.getDuplicatorVertices().size()));
            object22.debug((Object)("Number of vertices in v1: " + this.getSpoilerVertices().size()));
        }
        this.mGraphBuildTime = System.currentTimeMillis() - l;
    }

    private int getAmountOfBitsForSpoilerVertices(STATE STATE, STATE STATE2) {
        int n = 0;
        if (this.getSpoilerVertex(STATE, STATE2, false) != null) {
            ++n;
        }
        if (this.getSpoilerVertex(STATE, STATE2, true) != null) {
            ++n;
        }
        return n;
    }

    protected void setGraphBuildTime(long l) {
        this.mGraphBuildTime = l;
    }
}

