/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.IdentityHashSet;
import java.util.ArrayDeque;
import java.util.HashSet;

public class UnsatCoreCollector {
    private final Script mScript;

    public UnsatCoreCollector(Script script) {
        this.mScript = script;
    }

    public Term[] getUnsatCore(Clause clause) {
        try {
            HashSet<String> hashSet = this.run(clause);
            Term[] termArray = new Term[hashSet.size()];
            int n = -1;
            for (String string : hashSet) {
                termArray[++n] = this.mScript.term(string, new Term[0]);
            }
            return termArray;
        }
        catch (SMTLIBException sMTLIBException) {
            throw new InternalError(sMTLIBException.getMessage());
        }
    }

    private HashSet<String> run(Clause clause) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayDeque<Clause> arrayDeque = new ArrayDeque<Clause>();
        arrayDeque.push(clause);
        IdentityHashSet<Clause> identityHashSet = new IdentityHashSet<Clause>();
        while (!arrayDeque.isEmpty()) {
            Object object;
            Object object2;
            ProofNode proofNode;
            Clause clause2 = (Clause)arrayDeque.pop();
            if (!identityHashSet.add(clause2)) continue;
            if (clause2.getProof().isLeaf()) {
                proofNode = (LeafNode)clause2.getProof();
                if (((LeafNode)proofNode).getLeafKind() == -1 && ((LeafNode)proofNode).getTheoryAnnotation() instanceof SourceAnnotation) {
                    object2 = ((SourceAnnotation)((LeafNode)proofNode).getTheoryAnnotation()).getAnnotation();
                    if (((String)object2).isEmpty()) continue;
                    hashSet.add((String)object2);
                    continue;
                }
                if (((LeafNode)proofNode).getLeafKind() != -2 || ((String)(object = ((QuantAnnotation)(object2 = (QuantAnnotation)((LeafNode)proofNode).getTheoryAnnotation())).getSource().getAnnotation())).isEmpty()) continue;
                hashSet.add((String)object);
                continue;
            }
            proofNode = (ResolutionNode)clause2.getProof();
            arrayDeque.push(((ResolutionNode)proofNode).getPrimary());
            object2 = ((ResolutionNode)proofNode).getAntecedents();
            ResolutionNode.Antecedent[] antecedentArray = object2;
            int n = ((ResolutionNode.Antecedent[])object2).length;
            int n2 = 0;
            while (n2 < n) {
                object = antecedentArray[n2];
                arrayDeque.push(((ResolutionNode.Antecedent)object).mAntecedent);
                ++n2;
            }
        }
        return hashSet;
    }
}

