/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BenchmarkWithCounters
implements ICsvProviderProvider<Number> {
    private final Benchmark mWatchBenchmark = new Benchmark();
    private final Map<String, Integer> mCounters = new HashMap<String, Integer>();
    protected final List<String> mColumnTitles = new ArrayList<String>();
    protected final List<Number> mResults = new ArrayList<Number>();
    protected boolean mAlreadyGeneratedColumnTitlesAndResults = false;

    public void registerWatch(String string) {
        this.mWatchBenchmark.register(string);
    }

    public void unpauseWatch(String string) {
        this.mWatchBenchmark.unpause(string);
    }

    public void pauseWatch(String string) {
        this.mWatchBenchmark.pause(string);
    }

    public void registerCounter(String string) {
        if (this.mCounters.containsKey(string)) {
            throw new IllegalArgumentException("registering the same counter twice is forbidden: " + string);
        }
        this.mCounters.put(string, 0);
    }

    public void resetCounter(String string) {
        if (!this.mCounters.containsKey(string)) {
            throw new IllegalArgumentException("register this counter before resetting it: " + string);
        }
        this.mCounters.put(string, 0);
    }

    public void incrementCounter(String string) {
        Integer n = this.mCounters.get(string);
        if (n == null) {
            throw new IllegalArgumentException("register this counter before using it: " + string);
        }
        this.mCounters.put(string, n + 1);
    }

    public void registerCountersAndWatches(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.registerCounter(string);
            this.registerWatch(string);
            ++n2;
        }
    }

    protected void generateColumnTitlesAndResults() {
        if (this.mAlreadyGeneratedColumnTitlesAndResults) {
            return;
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        for (String object : this.mWatchBenchmark.getTitles()) {
            this.mColumnTitles.add(object + "(" + String.valueOf((Object)timeUnit) + ")");
            this.mResults.add(this.mWatchBenchmark.getElapsedTime(object, timeUnit));
        }
        for (Map.Entry entry : this.mCounters.entrySet()) {
            this.mColumnTitles.add("#" + (String)entry.getKey());
            this.mResults.add((Number)entry.getValue());
        }
        this.mAlreadyGeneratedColumnTitlesAndResults = true;
    }

    public String toString() {
        this.generateColumnTitlesAndResults();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        int n = 0;
        while (n < this.mColumnTitles.size()) {
            String string;
            Number number = this.mResults.get(n);
            if (number instanceof Double) {
                string = "%-50s : %15.2f %n";
            } else if (number instanceof Integer) {
                string = "%-50s : %15d %n";
            } else {
                throw new AssertionError((Object)"missed benchmark result case?");
            }
            stringBuilder.append(String.format(string, this.mColumnTitles.get(n), number));
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public ICsvProvider<Number> createCsvProvider() {
        this.generateColumnTitlesAndResults();
        SimpleCsvProvider<Number> simpleCsvProvider = new SimpleCsvProvider<Number>(this.mColumnTitles);
        simpleCsvProvider.addRow(this.mResults);
        return simpleCsvProvider;
    }
}

