/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class LibraryModelHandler {
    private final LocationFactory mLocationFactory;
    private final Map<String, ILibraryModel.IFunctionModelHandler> mFunctionModels = new HashMap<String, ILibraryModel.IFunctionModelHandler>();
    private final Map<String, ICType> mTypeModels = new HashMap<String, ICType>();
    private final Map<String, ILibraryModel.IConstantModelHandler> mConstantModels = new HashMap<String, ILibraryModel.IConstantModelHandler>();
    private final Map<String, IASTNode> mFunctionTable;
    private final FlatSymbolTable mSymboltable;
    private final boolean mCheckErrorFunction;
    private final ILogger mLogger;

    public LibraryModelHandler(ILogger iLogger, Map<String, IASTNode> map, FlatSymbolTable flatSymbolTable, boolean bl, LocationFactory locationFactory, List<ILibraryModel> list) {
        this.mLogger = iLogger;
        this.mFunctionTable = map;
        this.mSymboltable = flatSymbolTable;
        this.mCheckErrorFunction = bl;
        this.mLocationFactory = locationFactory;
        this.addModels(list);
    }

    public Result translateStandardFunction(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression) {
        IASTExpression iASTExpression = iASTFunctionCallExpression.getFunctionNameExpression();
        if (!(iASTExpression instanceof IASTIdExpression)) {
            return null;
        }
        IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTExpression;
        String string = iASTIdExpression.getName().toString();
        ILibraryModel.IFunctionModelHandler iFunctionModelHandler = this.mFunctionModels.get(string);
        if (iFunctionModelHandler == null) {
            return null;
        }
        String string2 = this.mSymboltable.applyMultiparseRenaming(iASTFunctionCallExpression.getContainingFilename(), string);
        IASTNode iASTNode = this.mFunctionTable.get(string2);
        if (iASTNode instanceof IASTFunctionDefinition) {
            if (this.mCheckErrorFunction && "reach_error".equals(string2)) {
                this.mLogger.warn("Function %s is already implemented but we override the implementation for the call at %s", new Object[]{string2, iASTFunctionCallExpression.getFileLocation()});
            } else {
                return null;
            }
        }
        CACSLLocation cACSLLocation = this.mLocationFactory.createCLocation((IASTNode)iASTFunctionCallExpression);
        return iFunctionModelHandler.handleFunction(iDispatcher, iASTFunctionCallExpression, cACSLLocation, string);
    }

    public Map<String, ICType> getTypeModels() {
        return Collections.unmodifiableMap(this.mTypeModels);
    }

    public Map<String, ILibraryModel.IConstantModelHandler> getConstantModels() {
        return Collections.unmodifiableMap(this.mConstantModels);
    }

    private void addModels(List<ILibraryModel> list) {
        ILibraryModel.IFunctionModelHandler iFunctionModelHandler = (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> {
            throw new UnsupportedSyntaxException(iLocation, "Unsupported function: " + string);
        };
        for (ILibraryModel iLibraryModel : list) {
            iLibraryModel.getFunctionModels().forEach(functionModel -> LibraryModelHandler.fill(this.mFunctionModels, functionModel.functionName(), functionModel.functionModel()));
            iLibraryModel.getUnsupportedFunctions().forEach(string -> LibraryModelHandler.fill(this.mFunctionModels, string, iFunctionModelHandler));
            iLibraryModel.getTypeModels().forEach(typeModel -> LibraryModelHandler.fill(this.mTypeModels, typeModel.typeName(), typeModel.cType()));
            iLibraryModel.getConstantModels().forEach(constantModel -> LibraryModelHandler.fill(this.mConstantModels, constantModel.name(), constantModel.model()));
        }
    }

    private static <K, V> void fill(Map<K, V> map, K k, V v) {
        V v2 = map.put(k, v);
        if (v2 != null) {
            throw new AssertionError((Object)("Accidentally overwrote definition for " + String.valueOf(k)));
        }
    }
}

