/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.ComplementDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerBuilder;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IntersectDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ReachableStatesCopy<LETTER, STATE>
extends DoubleDeckerBuilder<LETTER, STATE>
implements IOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final Map<STATE, STATE> mOld2new = new HashMap<STATE, STATE>();
    private final Map<STATE, STATE> mNew2old = new HashMap<STATE, STATE>();
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final boolean mComplement;

    public ReachableStatesCopy(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, false, false, false, false);
    }

    public ReachableStatesCopy(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        if (bl2 && !bl) {
            throw new IllegalArgumentException("complement requires totalize");
        }
        this.mComplement = bl2;
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mLogger.info((Object)this.startMessage());
        this.mTraversedNwa = new DoubleDeckerAutomaton(this.mServices, iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), (IEmptyStackStateFactory)iNwaOutgoingLetterAndTransitionProvider.getStateFactory());
        this.mRemoveDeadEnds = bl3;
        this.mRemoveNonLiveStates = bl4;
        boolean bl5 = this.mOperand.getInitialStates().iterator().hasNext();
        STATE STATE = null;
        if (bl || !bl5) {
            STATE = this.addSinkState();
        }
        this.traverseDoubleDeckerGraph();
        ((DoubleDeckerAutomaton)this.mTraversedNwa).setUp2Down(this.getUp2DownMapping());
        if (bl) {
            this.makeAutomatonTotal(STATE);
        }
        this.mLogger.info((Object)this.exitMessage());
    }

    private void makeAutomatonTotal(STATE STATE) throws AutomataOperationCanceledException {
        assert (STATE != null) : "sink state must not be null";
        for (Object STATE2 : this.mTraversedNwa.getStates()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            for (Object LETTER : this.mTraversedNwa.getVpAlphabet().getInternalAlphabet()) {
                if (this.mTraversedNwa.internalSuccessors(STATE2, LETTER).iterator().hasNext()) continue;
                ((NestedWordAutomaton)this.mTraversedNwa).addInternalTransition(STATE2, LETTER, STATE);
            }
            for (Object LETTER : this.mTraversedNwa.getVpAlphabet().getCallAlphabet()) {
                if (this.mTraversedNwa.callSuccessors(STATE2, LETTER).iterator().hasNext()) continue;
                ((NestedWordAutomaton)this.mTraversedNwa).addCallTransition(STATE2, LETTER, STATE);
            }
            this.makeAutomatonTotalReturn(STATE, STATE2);
        }
    }

    private void makeAutomatonTotalReturn(STATE STATE, STATE STATE2) {
        for (Object LETTER : this.mTraversedNwa.getVpAlphabet().getReturnAlphabet()) {
            for (Object STATE3 : this.mTraversedNwa.getStates()) {
                if (this.mTraversedNwa.returnSuccessors(STATE2, STATE3, LETTER).iterator().hasNext()) continue;
                ((NestedWordAutomaton)this.mTraversedNwa).addReturnTransition(STATE2, STATE3, LETTER, STATE);
            }
        }
    }

    private STATE addSinkState() {
        Object STATE = ((ISinkStateFactory)this.mTraversedNwa.getStateFactory()).createSinkStateContent();
        boolean bl = !this.mOperand.getInitialStates().iterator().hasNext();
        boolean bl2 = this.mComplement;
        ((NestedWordAutomaton)this.mTraversedNwa).addState(bl, bl2, STATE);
        return STATE;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". Operand " + this.mOperand.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mTraversedNwa.sizeInformation();
    }

    @Override
    protected Collection<STATE> getInitialStates() {
        ArrayList arrayList = new ArrayList();
        for (Object STATE : this.mOperand.getInitialStates()) {
            Object STATE2 = this.constructOrGetResState(STATE, true);
            arrayList.add(STATE2);
        }
        return arrayList;
    }

    private STATE constructOrGetResState(STATE STATE, boolean bl) {
        if (this.mOld2new.containsKey(STATE)) {
            return this.mOld2new.get(STATE);
        }
        STATE STATE2 = this.mOld2new.get(STATE);
        if (STATE2 == null) {
            STATE2 = STATE;
            boolean bl2 = this.mOperand.isFinal(STATE) ^ this.mComplement;
            ((NestedWordAutomaton)this.mTraversedNwa).addState(bl, bl2, STATE2);
            this.mOld2new.put(STATE, STATE2);
            this.mNew2old.put(STATE2, STATE);
        }
        return STATE2;
    }

    @Override
    protected Collection<STATE> buildInternalSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getUp();
        STATE STATE2 = this.mNew2old.get(STATE);
        for (LETTER LETTER : this.mOperand.lettersInternal(STATE2)) {
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mOperand.internalSuccessors(STATE2, LETTER)) {
                STATE STATE3 = this.constructOrGetResState(outgoingInternalTransition.getSucc(), false);
                ((NestedWordAutomaton)this.mTraversedNwa).addInternalTransition(STATE, LETTER, STATE3);
                arrayList.add(STATE3);
            }
        }
        return arrayList;
    }

    @Override
    protected Collection<STATE> buildReturnSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getDown();
        if (STATE == this.mTraversedNwa.getEmptyStackState()) {
            return arrayList;
        }
        STATE STATE2 = doubleDecker.getUp();
        STATE STATE3 = this.mNew2old.get(STATE2);
        STATE STATE4 = this.mNew2old.get(STATE);
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE3, STATE4)) {
            STATE STATE5 = this.constructOrGetResState(outgoingReturnTransition.getSucc(), false);
            ((NestedWordAutomaton)this.mTraversedNwa).addReturnTransition(STATE2, STATE, outgoingReturnTransition.getLetter(), STATE5);
            arrayList.add(STATE5);
        }
        return arrayList;
    }

    @Override
    protected Collection<STATE> buildCallSuccessors(DoubleDecker<STATE> doubleDecker) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        STATE STATE = doubleDecker.getUp();
        STATE STATE2 = this.mNew2old.get(STATE);
        for (LETTER LETTER : this.mOperand.lettersCall(STATE2)) {
            for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mOperand.callSuccessors(STATE2, LETTER)) {
                STATE STATE3 = this.constructOrGetResState(outgoingCallTransition.getSucc(), false);
                ((NestedWordAutomaton)this.mTraversedNwa).addCallTransition(STATE, LETTER, STATE3);
                arrayList.add(STATE3);
            }
        }
        return arrayList;
    }

    @Override
    public IDoubleDeckerAutomaton<LETTER, STATE> getResult() {
        return (IDoubleDeckerAutomaton)this.mTraversedNwa;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (!this.mRemoveNonLiveStates) {
            Object object;
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
            if (!this.mComplement) {
                object = this.mOperand;
            } else {
                Object object2;
                Object object3 = new IntersectDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand, this.mTraversedNwa).getResult();
                bl &= new IsEmpty(this.mServices, object3).getResult().booleanValue();
                object = object2 = new ComplementDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand).getResult();
            }
            bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mTraversedNwa).getResult().booleanValue();
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mTraversedNwa);
        }
        return bl;
    }
}

