/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import java.util.HashSet;

public class InterpolationPreferenceChecker {
    public static void check(String string, InterpolationTechnique interpolationTechnique, IUltimateServiceProvider iUltimateServiceProvider) {
        HashSet<SolverBuilder.SolverMode> hashSet = new HashSet<SolverBuilder.SolverMode>();
        switch (interpolationTechnique) {
            case Craig_NestedInterpolation: 
            case Craig_TreeInterpolation: {
                hashSet.add(SolverBuilder.SolverMode.Internal_SMTInterpol);
                hashSet.add(SolverBuilder.SolverMode.External_PrincessInterpolationMode);
                hashSet.add(SolverBuilder.SolverMode.External_SMTInterpolInterpolationMode);
                hashSet.add(SolverBuilder.SolverMode.External_Z3InterpolationMode);
                hashSet.add(SolverBuilder.SolverMode.External_MathsatInterpolationMode);
                break;
            }
            case ForwardPredicates: 
            case BackwardPredicates: 
            case FPandBP: 
            case PathInvariants: {
                hashSet.add(SolverBuilder.SolverMode.Internal_SMTInterpol);
                hashSet.add(SolverBuilder.SolverMode.External_ModelsAndUnsatCoreMode);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown option " + String.valueOf(interpolationTechnique)));
            }
        }
        SolverBuilder.SolverMode solverMode = (SolverBuilder.SolverMode)iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("SMT solver", SolverBuilder.SolverMode.class);
        if (!hashSet.contains(solverMode)) {
            String string2 = "Incompatible preferences. You want to use " + String.valueOf(interpolationTechnique) + " in the " + string + " plugin. This requires that SMT solver in the " + Activator.PLUGIN_ID + " has one of the following values. " + ((Object)hashSet).toString();
            throw new UnsupportedOperationException(string2);
        }
    }
}

