/*
 * Decompiled with CFR 0.152.
 */
package lazabs.viewer;

import ap.parser.SMTLineariser$;
import ap.theories.ADT;
import ap.theories.Heap;
import ap.types.Sort;
import java.io.Serializable;
import lazabs.ast.ASTree;
import lazabs.ast.ASTree$Addition$;
import lazabs.ast.ASTree$ArraySelect$;
import lazabs.ast.ASTree$ArrayUpdate$;
import lazabs.ast.ASTree$Conjunction$;
import lazabs.ast.ASTree$ConstArray$;
import lazabs.ast.ASTree$Disjunction$;
import lazabs.ast.ASTree$Division$;
import lazabs.ast.ASTree$Equality$;
import lazabs.ast.ASTree$GreaterThan$;
import lazabs.ast.ASTree$GreaterThanEqual$;
import lazabs.ast.ASTree$Inequality$;
import lazabs.ast.ASTree$Int2BitVec$;
import lazabs.ast.ASTree$LessThan$;
import lazabs.ast.ASTree$LessThanEqual$;
import lazabs.ast.ASTree$Minus$;
import lazabs.ast.ASTree$Modulo$;
import lazabs.ast.ASTree$Multiplication$;
import lazabs.ast.ASTree$Not$;
import lazabs.ast.ASTree$Subtraction$;
import lazabs.horn.global.Horn$;
import lazabs.horn.global.HornClause;
import lazabs.horn.global.HornLiteral;
import lazabs.horn.global.Interp;
import lazabs.horn.global.RelVar;
import lazabs.types.AdtType;
import lazabs.types.ArrayType;
import lazabs.types.BVType;
import lazabs.types.BooleanType;
import lazabs.types.HeapAddressType;
import lazabs.types.HeapType;
import lazabs.types.Type;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class HornSMTPrinter$ {
    public static HornSMTPrinter$ MODULE$;

    static {
        new HornSMTPrinter$();
    }

    public String apply(Seq<HornClause> system) {
        return new StringBuilder(143).append("(set-info :origin \"Horn problem converted to SMT-LIB2 using Eldarica (https://github.com/uuverifiers/eldarica)\")\n(set-logic HORN)\n").append(((TraversableOnce)((TraversableLike)((SeqLike)((GenericTraversableTemplate)system.map((Function1 & Serializable & scala.Serializable)x$1 -> Horn$.MODULE$.getRelVarSignatures((HornClause)x$1), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).distinct()).map((Function1 & Serializable & scala.Serializable)rv -> new StringBuilder(20).append("(declare-fun ").append(SMTLineariser$.MODULE$.quoteIdentifier((String)rv._1())).append(" ").append(((TraversableOnce)((TraversableLike)rv._2()).map((Function1 & Serializable & scala.Serializable)t -> MODULE$.type2String((Type)t), Seq$.MODULE$.canBuildFrom())).mkString("(", " ", ")")).append(" Bool)").toString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n").append(((TraversableOnce)system.map((Function1 & Serializable & scala.Serializable)h -> MODULE$.print((HornClause)h), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n(check-sat)").toString();
    }

    public String getAlphabeticChar(int i) {
        int alpha = i / 26;
        return new StringBuilder(0).append((char)(i % 26 + 65)).append(alpha > 0 ? Integer.toString(alpha) : "").toString().toString();
    }

    public String type2String(Type t) {
        Type type = t;
        if (type instanceof AdtType) {
            AdtType adtType = (AdtType)type;
            Sort s = adtType.s();
            return SMTLineariser$.MODULE$.sort2SMTString(s);
        }
        if (type instanceof BooleanType) {
            return "Bool";
        }
        if (type instanceof BVType) {
            BVType bVType = (BVType)type;
            int n = bVType.bits();
            return new StringBuilder(11).append("(_ BitVec ").append(n).append(")").toString();
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type index = arrayType.index();
            Type obj = arrayType.obj();
            return new StringBuilder(9).append("(Array ").append(this.type2String(index)).append(" ").append(this.type2String(obj)).append(")").toString();
        }
        if (type instanceof HeapType) {
            HeapType heapType = (HeapType)type;
            Sort s = heapType.s();
            return s.name();
        }
        if (type instanceof HeapAddressType) {
            HeapAddressType heapAddressType = (HeapAddressType)type;
            Heap heap = heapAddressType.h();
            return heap.AddressSort().name();
        }
        return "Int";
    }

    public String print(HornClause h) {
        return this.printFull(h, false);
    }

    public String printFull(HornClause h, boolean asDefineFun) {
        ASTree.BoolConst boolConst;
        boolean bl;
        Interp interp;
        ASTree.Expression expression;
        String string;
        ObjectRef varMap = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).empty());
        IntRef curVarCounter = IntRef.create((int)-1);
        String head = this.printHornLiteral$1(h.head(), varMap, curVarCounter);
        int n = h.body().size();
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = this.printHornLiteral$1((HornLiteral)h.body().head(), varMap, curVarCounter);
                break;
            }
            default: {
                Tuple2 tuple2 = h.body().partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HornSMTPrinter$.$anonfun$printFull$6(x$4)));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                List relVars = (List)tuple2._1();
                List other = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)relVars, (Object)other);
                List relVars2 = (List)tuple22._1();
                List other2 = (List)tuple22._2();
                List strings = (List)((List)relVars2.$plus$plus((GenTraversableOnce)other2, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)hl -> this.printHornLiteral$1((HornLiteral)hl, varMap, curVarCounter), List$.MODULE$.canBuildFrom());
                string = new StringBuilder(6).append("(and ").append(strings.mkString(" ")).append(")").toString();
                break;
            }
        }
        String body2 = string;
        if (asDefineFun) {
            HornLiteral hornLiteral = h.head();
            if (!(hornLiteral instanceof RelVar)) {
                throw new MatchError((Object)hornLiteral);
            }
            RelVar relVar = (RelVar)hornLiteral;
            String name = relVar.varName();
            List<ASTree.Parameter> params = relVar.params();
            Tuple2 tuple2 = new Tuple2((Object)name, params);
            String name2 = (String)tuple2._1();
            List params2 = (List)tuple2._2();
            String args = ((TraversableOnce)params2.map((Function1 & Serializable & scala.Serializable)p -> {
                Tuple2 tuple2 = (Tuple2)((Map)varMap$1.elem).apply((Object)p.name());
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int ind = tuple2._1$mcI$sp();
                Type t = (Type)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ind), (Object)t);
                int ind2 = tuple22._1$mcI$sp();
                Type t2 = (Type)tuple22._2();
                return new StringBuilder(3).append("(").append(MODULE$.getAlphabeticChar(ind2)).append(" ").append(MODULE$.type2String((Type)((Tuple2)((Map)varMap$1.elem).apply((Object)p.name()))._2())).append(")").toString();
            }, List$.MODULE$.canBuildFrom())).mkString(" ");
            return new StringBuilder(22).append("(define-fun ").append(SMTLineariser$.MODULE$.quoteIdentifier(name2)).append(" (").append(args).append(") Bool ").append(body2).append(")").toString();
        }
        String boundVars = ((TraversableOnce)((TraversableLike)((Map)varMap.elem).values().toSeq().sortWith((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> BoxesRunTime.boxToBoolean((boolean)HornSMTPrinter$.$anonfun$printFull$9(x$8, x$9)))).map((Function1 & Serializable & scala.Serializable)v -> new StringBuilder(3).append("(").append(MODULE$.getAlphabeticChar(v._1$mcI$sp())).append(" ").append(MODULE$.type2String((Type)v._2())).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" ");
        HornLiteral hornLiteral = h.head();
        if (hornLiteral instanceof Interp && (expression = (interp = (Interp)hornLiteral).value()) instanceof ASTree.BoolConst && !(bl = (boolConst = (ASTree.BoolConst)expression).value())) {
            if (boundVars.isEmpty()) {
                return new StringBuilder(20).append("(assert (=> ").append(body2).append(" false))").toString();
            }
            return new StringBuilder(32).append("(assert (forall (").append(boundVars).append(") (=> ").append(body2).append(" false)))").toString();
        }
        if (boundVars.isEmpty()) {
            return new StringBuilder(14).append("(assert(=> ").append(body2).append(" ").append(head).append("))").toString();
        }
        return new StringBuilder(27).append("(assert (forall (").append(boundVars).append(") ").append("(=> ").append(body2).append(" ").append(head).append(")))").toString();
    }

    private static final int getNewVarCounter$1(IntRef curVarCounter$1) {
        ++curVarCounter$1.elem;
        return curVarCounter$1.elem;
    }

    private final String printHornLiteral$1(HornLiteral hl, ObjectRef varMap$1, IntRef curVarCounter$1) {
        HornLiteral hornLiteral = hl;
        if (hornLiteral instanceof Interp) {
            Interp interp = (Interp)hornLiteral;
            ASTree.Expression v = interp.value();
            return this.printExp$1(v, (List)Nil$.MODULE$, varMap$1, curVarCounter$1);
        }
        if (hornLiteral instanceof RelVar) {
            RelVar relVar = (RelVar)hornLiteral;
            String varName = relVar.varName();
            List<ASTree.Parameter> params = relVar.params();
            if (params.isEmpty()) {
                return SMTLineariser$.MODULE$.quoteIdentifier(varName);
            }
            return new StringBuilder(3).append("(").append(SMTLineariser$.MODULE$.quoteIdentifier(varName)).append(" ").append(((TraversableOnce)params.map((Function1 & Serializable & scala.Serializable)p -> this.printParameter$1((ASTree.Parameter)p, varMap$1, curVarCounter$1), List$.MODULE$.canBuildFrom())).mkString(" ")).append(")").toString();
        }
        throw new MatchError((Object)hornLiteral);
    }

    private final String printParameter$1(ASTree.Parameter p, ObjectRef varMap$1, IntRef curVarCounter$1) {
        Option option = ((Map)varMap$1.elem).get((Object)p.name());
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 i = (Tuple2)some.value();
            return this.getAlphabeticChar(i._1$mcI$sp());
        }
        if (None$.MODULE$.equals(option)) {
            int newIndex = HornSMTPrinter$.getNewVarCounter$1(curVarCounter$1);
            varMap$1.elem = ((Map)varMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)p.name()), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)newIndex), (Object)p.typ())));
            return this.getAlphabeticChar(newIndex);
        }
        throw new MatchError((Object)option);
    }

    private final String printExp$1(ASTree.Expression e2, List vars, ObjectRef varMap$1, IntRef curVarCounter$1) {
        Option<Object> option;
        ASTree.Expression expression;
        ASTree.Variable variable;
        boolean bl;
        while (true) {
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option2;
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option3;
            bl = false;
            variable = null;
            expression = e2;
            if (expression instanceof ASTree.Existential) {
                String name;
                ASTree.Existential existential = (ASTree.Existential)expression;
                ASTree.BinderVariable v = existential.v();
                ASTree.Expression qe = existential.qe();
                String string = name = new StringBuilder(3).append("var").append(vars.size()).toString();
                return new StringBuilder(15).append("(exists ((").append(name).append(" ").append(this.type2String(v.stype())).append(")) ").append(this.printExp$1(qe, vars.$colon$colon((Object)string), varMap$1, curVarCounter$1)).append(")").toString();
            }
            if (expression instanceof ASTree.Universal) {
                String name;
                ASTree.Universal universal = (ASTree.Universal)expression;
                ASTree.BinderVariable v = universal.v();
                ASTree.Expression qe = universal.qe();
                String string = name = new StringBuilder(3).append("var").append(vars.size()).toString();
                return new StringBuilder(15).append("(forall ((").append(name).append(" ").append(this.type2String(v.stype())).append(")) ").append(this.printExp$1(qe, vars.$colon$colon((Object)string), varMap$1, curVarCounter$1)).append(")").toString();
            }
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option4 = ASTree$Conjunction$.MODULE$.unapply(expression);
            if (!option4.isEmpty()) {
                ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option4.get())._1();
                ASTree.Expression e22 = (ASTree.Expression)((Tuple2)option4.get())._2();
                return new StringBuilder(7).append("(and ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e22, vars, varMap$1, curVarCounter$1)).append(")").toString();
            }
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option5 = ASTree$Disjunction$.MODULE$.unapply(expression);
            if (!option5.isEmpty()) {
                ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option5.get())._1();
                ASTree.Expression e23 = (ASTree.Expression)((Tuple2)option5.get())._2();
                return new StringBuilder(6).append("(or ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e23, vars, varMap$1, curVarCounter$1)).append(")").toString();
            }
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option6 = ASTree$Equality$.MODULE$.unapply(expression);
            if (!option6.isEmpty()) {
                ASTree.Expression expression2 = (ASTree.Expression)((Tuple2)option6.get())._1();
                ASTree.Expression expression3 = (ASTree.Expression)((Tuple2)option6.get())._2();
                if (expression2 instanceof ASTree.NumericalConst) {
                    ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression2;
                    BigInt num = numericalConst.num();
                    if (expression3 instanceof ASTree.ADTtest) {
                        ASTree.ADTtest aDTtest = (ASTree.ADTtest)expression3;
                        ADT adt = aDTtest.adt();
                        int sortNum = aDTtest.sortNum();
                        ASTree.Expression expr = aDTtest.v();
                        return new StringBuilder(6).append("(is-").append(adt.getCtorPerSort(sortNum, num.toInt()).name()).append(" ").append(this.printExp$1(expr, vars, varMap$1, curVarCounter$1)).append(")").toString();
                    }
                }
            }
            if (!(option3 = ASTree$Equality$.MODULE$.unapply(expression)).isEmpty()) {
                ASTree.Expression expression4 = (ASTree.Expression)((Tuple2)option3.get())._1();
                ASTree.Expression expression5 = (ASTree.Expression)((Tuple2)option3.get())._2();
                if (expression4 instanceof ASTree.ADTtest) {
                    ASTree.ADTtest aDTtest = (ASTree.ADTtest)expression4;
                    ADT adt = aDTtest.adt();
                    int sortNum = aDTtest.sortNum();
                    ASTree.Expression expr = aDTtest.v();
                    if (expression5 instanceof ASTree.NumericalConst) {
                        ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression5;
                        BigInt num = numericalConst.num();
                        return new StringBuilder(6).append("(is-").append(adt.getCtorPerSort(sortNum, num.toInt()).name()).append(" ").append(this.printExp$1(expr, vars, varMap$1, curVarCounter$1)).append(")").toString();
                    }
                }
            }
            if (!(option2 = ASTree$Equality$.MODULE$.unapply(expression)).isEmpty()) {
                ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option2.get())._1();
                ASTree.Expression e24 = (ASTree.Expression)((Tuple2)option2.get())._2();
                return new StringBuilder(5).append("(= ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e24, vars, varMap$1, curVarCounter$1)).append(")").toString();
            }
            Option<Tuple2<ASTree.Expression, ASTree.Expression>> option7 = ASTree$Inequality$.MODULE$.unapply(expression);
            if (option7.isEmpty()) break;
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option7.get())._1();
            ASTree.Expression e25 = (ASTree.Expression)((Tuple2)option7.get())._2();
            e2 = ASTree$Not$.MODULE$.apply(ASTree$Equality$.MODULE$.apply(e1, e25));
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option8 = ASTree$LessThan$.MODULE$.unapply(expression);
        if (!option8.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option8.get())._1();
            ASTree.Expression e26 = (ASTree.Expression)((Tuple2)option8.get())._2();
            return new StringBuilder(5).append("(< ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e26, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option9 = ASTree$LessThanEqual$.MODULE$.unapply(expression);
        if (!option9.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option9.get())._1();
            ASTree.Expression e27 = (ASTree.Expression)((Tuple2)option9.get())._2();
            return new StringBuilder(6).append("(<= ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e27, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option10 = ASTree$GreaterThan$.MODULE$.unapply(expression);
        if (!option10.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option10.get())._1();
            ASTree.Expression e28 = (ASTree.Expression)((Tuple2)option10.get())._2();
            return new StringBuilder(5).append("(> ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e28, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option11 = ASTree$GreaterThanEqual$.MODULE$.unapply(expression);
        if (!option11.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option11.get())._1();
            ASTree.Expression e29 = (ASTree.Expression)((Tuple2)option11.get())._2();
            return new StringBuilder(6).append("(>= ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e29, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option12 = ASTree$Modulo$.MODULE$.unapply(expression);
        if (!option12.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option12.get())._1();
            ASTree.Expression e210 = (ASTree.Expression)((Tuple2)option12.get())._2();
            return new StringBuilder(7).append("(mod ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e210, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option13 = ASTree$Addition$.MODULE$.unapply(expression);
        if (!option13.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option13.get())._1();
            ASTree.Expression e211 = (ASTree.Expression)((Tuple2)option13.get())._2();
            return new StringBuilder(5).append("(+ ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e211, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option14 = ASTree$Subtraction$.MODULE$.unapply(expression);
        if (!option14.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option14.get())._1();
            ASTree.Expression e212 = (ASTree.Expression)((Tuple2)option14.get())._2();
            return new StringBuilder(5).append("(- ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e212, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option15 = ASTree$Multiplication$.MODULE$.unapply(expression);
        if (!option15.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option15.get())._1();
            ASTree.Expression e213 = (ASTree.Expression)((Tuple2)option15.get())._2();
            return new StringBuilder(5).append("(* ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e213, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option16 = ASTree$Division$.MODULE$.unapply(expression);
        if (!option16.isEmpty()) {
            ASTree.Expression e1 = (ASTree.Expression)((Tuple2)option16.get())._1();
            ASTree.Expression e214 = (ASTree.Expression)((Tuple2)option16.get())._2();
            return new StringBuilder(7).append("(div ").append(this.printExp$1(e1, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(e214, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.ADTctor) {
            ASTree.ADTctor aDTctor = (ASTree.ADTctor)expression;
            String name = aDTctor.name();
            Seq<ASTree.Expression> exprList = aDTctor.exprList();
            if (exprList.isEmpty()) {
                return SMTLineariser$.MODULE$.quoteIdentifier(name);
            }
            return new StringBuilder(3).append("(").append(SMTLineariser$.MODULE$.quoteIdentifier(name)).append(" ").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(" ")).append(")").toString();
        }
        if (expression instanceof ASTree.ADTsel) {
            ASTree.ADTsel aDTsel = (ASTree.ADTsel)expression;
            String name = aDTsel.name();
            Seq<ASTree.Expression> exprList = aDTsel.exprList();
            return new StringBuilder(3).append("(").append(SMTLineariser$.MODULE$.quoteIdentifier(name)).append(" ").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(" ")).append(")").toString();
        }
        if (expression instanceof ASTree.ADTsize) {
            ASTree.ADTsize aDTsize = (ASTree.ADTsize)expression;
            ASTree.Expression v = aDTsize.v();
            return new StringBuilder(8).append("(_size ").append(this.printExp$1(v, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple2<ASTree.Expression, ASTree.Expression>> option17 = ASTree$ArraySelect$.MODULE$.unapply(expression);
        if (!option17.isEmpty()) {
            ASTree.Expression ar = (ASTree.Expression)((Tuple2)option17.get())._1();
            ASTree.Expression ind = (ASTree.Expression)((Tuple2)option17.get())._2();
            return new StringBuilder(10).append("(select ").append(this.printExp$1(ar, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(ind, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<Tuple3<ASTree.Expression, ASTree.Expression, ASTree.Expression>> option18 = ASTree$ArrayUpdate$.MODULE$.unapply(expression);
        if (!option18.isEmpty()) {
            ASTree.Expression ar = (ASTree.Expression)((Tuple3)option18.get())._1();
            ASTree.Expression ind = (ASTree.Expression)((Tuple3)option18.get())._2();
            ASTree.Expression value = (ASTree.Expression)((Tuple3)option18.get())._3();
            return new StringBuilder(10).append("(store ").append(this.printExp$1(ar, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(ind, vars, varMap$1, curVarCounter$1)).append(" ").append(this.printExp$1(value, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<ASTree.Expression> option19 = ASTree$ConstArray$.MODULE$.unapply(expression);
        if (!option19.isEmpty()) {
            ASTree.Expression value = (ASTree.Expression)option19.get();
            return new StringBuilder(14).append("((as const ").append(this.type2String(e2.stype())).append(") ").append(this.printExp$1(value, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.HeapFun) {
            ASTree.HeapFun heapFun = (ASTree.HeapFun)expression;
            String name = heapFun.name();
            Seq<ASTree.Expression> exprList = heapFun.exprList();
            if (exprList.isEmpty()) {
                return SMTLineariser$.MODULE$.quoteIdentifier(name);
            }
            return new StringBuilder(3).append("(").append(SMTLineariser$.MODULE$.quoteIdentifier(name)).append(" ").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(" ")).append(")").toString();
        }
        if (expression instanceof ASTree.HeapPred) {
            ASTree.HeapPred heapPred = (ASTree.HeapPred)expression;
            String name = heapPred.name();
            Seq<ASTree.Expression> exprList = heapPred.exprList();
            return new StringBuilder(3).append("(").append(SMTLineariser$.MODULE$.quoteIdentifier(name)).append(" ").append(((TraversableOnce)exprList.map((Function1 & Serializable & scala.Serializable)e -> this.printExp$1((ASTree.Expression)e, vars, varMap$1, curVarCounter$1), Seq$.MODULE$.canBuildFrom())).mkString(" ")).append(")").toString();
        }
        Option<ASTree.Expression> option20 = ASTree$Not$.MODULE$.unapply(expression);
        if (!option20.isEmpty()) {
            ASTree.Expression e3 = (ASTree.Expression)option20.get();
            return new StringBuilder(6).append("(not ").append(this.printExp$1(e3, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        Option<ASTree.Expression> option21 = ASTree$Minus$.MODULE$.unapply(expression);
        if (!option21.isEmpty()) {
            ASTree.Expression e4 = (ASTree.Expression)option21.get();
            return new StringBuilder(4).append("(- ").append(this.printExp$1(e4, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.Variable) {
            bl = true;
            variable = (ASTree.Variable)expression;
            String name = variable.name();
            Option<Object> option22 = variable.deBruijn();
            if (None$.MODULE$.equals(option22)) {
                Option option23 = ((Map)varMap$1.elem).get((Object)name);
                if (option23 instanceof Some) {
                    Some some = (Some)option23;
                    Tuple2 i = (Tuple2)some.value();
                    return this.getAlphabeticChar(i._1$mcI$sp());
                }
                if (None$.MODULE$.equals(option23)) {
                    int newIndex = HornSMTPrinter$.getNewVarCounter$1(curVarCounter$1);
                    varMap$1.elem = ((Map)varMap$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)newIndex), (Object)variable.stype())));
                    return this.getAlphabeticChar(newIndex);
                }
                throw new MatchError((Object)option23);
            }
        }
        if (bl && (option = variable.deBruijn()) instanceof Some) {
            Some some = (Some)option;
            int index = BoxesRunTime.unboxToInt((Object)some.value());
            if (index < vars.size()) {
                return (String)vars.apply(index);
            }
            return this.getAlphabeticChar(index - vars.size());
        }
        if (expression instanceof ASTree.NumericalConst) {
            ASTree.NumericalConst numericalConst = (ASTree.NumericalConst)expression;
            BigInt num = numericalConst.num();
            if (num.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
                return new StringBuilder(4).append("(- ").append(num.abs()).append(")").toString();
            }
            return num.toString();
        }
        if (expression instanceof ASTree.BoolConst) {
            ASTree.BoolConst boolConst = (ASTree.BoolConst)expression;
            boolean v = boolConst.value();
            return SMTLineariser$.MODULE$.quoteIdentifier(Boolean.toString(v));
        }
        if (expression instanceof ASTree.BVconst) {
            ASTree.BVconst bVconst = (ASTree.BVconst)expression;
            int bits = bVconst.bits();
            BigInt v = bVconst.num();
            return new StringBuilder(7).append("(_ bv").append(v).append(" ").append(bits).append(")").toString();
        }
        Option<Tuple2<Object, ASTree.Expression>> option24 = ASTree$Int2BitVec$.MODULE$.unapply(expression);
        if (!option24.isEmpty()) {
            int bits = ((Tuple2)option24.get())._1$mcI$sp();
            ASTree.Expression e5 = (ASTree.Expression)((Tuple2)option24.get())._2();
            return new StringBuilder(14).append("((_ int2bv ").append(bits).append(") ").append(this.printExp$1(e5, vars, varMap$1, curVarCounter$1)).append(")").toString();
        }
        if (expression instanceof ASTree.UnaryExpression) {
            ASTree.UnaryExpression unaryExpression = (ASTree.UnaryExpression)expression;
            ASTree.UnaryOperator op = unaryExpression.op();
            ASTree.Expression e6 = unaryExpression.e();
            if (op instanceof ASTree.BVneg) {
                ASTree.BVneg bVneg = (ASTree.BVneg)op;
                return new StringBuilder(3).append("(").append(bVneg.st()).append(" ").append(this.printExp$1(e6, vars, varMap$1, curVarCounter$1)).append(")").toString();
            }
        }
        throw new Exception(new StringBuilder(19).append("Invalid expression ").append(e2).toString());
    }

    public static final /* synthetic */ boolean $anonfun$printFull$6(HornLiteral x$4) {
        return x$4 instanceof RelVar;
    }

    public static final /* synthetic */ boolean $anonfun$printFull$9(Tuple2 x$8, Tuple2 x$9) {
        return x$8._1$mcI$sp() < x$9._1$mcI$sp();
    }

    private HornSMTPrinter$() {
        MODULE$ = this;
    }
}

