/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.OctagonMatrix;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;

public final class OctagonState
implements IAbstractState<OctagonState> {
    public static final OctagonState TOP = new OctagonState(Map.of(), OctagonMatrix.NEW, true);
    private final Map<Term, Integer> mVarToIndex;
    private final OctagonMatrix mMatrix;
    private final boolean mAllVarsAreInt;

    public OctagonState(Map<Term, Integer> map, OctagonMatrix octagonMatrix, boolean bl) {
        this.mVarToIndex = map;
        this.mMatrix = octagonMatrix;
        this.mAllVarsAreInt = bl;
    }

    private Term[] getIndexToTermArray() {
        Term[] termArray = new Term[this.mVarToIndex.size()];
        for (Map.Entry<Term, Integer> entry : this.mVarToIndex.entrySet()) {
            termArray[entry.getValue().intValue()] = entry.getKey();
        }
        return termArray;
    }

    public Term toTerm(Script script) {
        return this.mMatrix.getTerm(script, this.getIndexToTermArray());
    }

    public String toString() {
        return Arrays.toString(this.getIndexToTermArray()) + "\n" + this.mMatrix.toString();
    }

    private OctagonMatrix cachedSelectiveClosure() {
        return this.mAllVarsAreInt ? this.mMatrix.cachedTightClosure() : this.mMatrix.cachedStrongClosure();
    }

    private OctagonState applyMergeOperator(OctagonState octagonState, BinaryOperator<OctagonMatrix> binaryOperator) {
        Object object2;
        HashMap<Term, Integer> hashMap = new HashMap<Term, Integer>();
        Set set = DataStructureUtils.union(this.mVarToIndex.keySet(), octagonState.mVarToIndex.keySet());
        int[] nArray = new int[set.size()];
        int[] nArray2 = new int[set.size()];
        int n = this.mVarToIndex.size();
        boolean bl = this.mAllVarsAreInt;
        for (Object object2 : set) {
            int n2 = this.mVarToIndex.getOrDefault(object2, -1);
            int n3 = octagonState.mVarToIndex.getOrDefault(object2, -1);
            if (n2 != -1) {
                hashMap.put((Term)object2, n2);
                nArray[n2] = n2;
                nArray2[n2] = n3;
                continue;
            }
            hashMap.put((Term)object2, n);
            nArray[n] = n2;
            nArray2[n] = n3;
            ++n;
            if (!bl || !SmtSortUtils.isRealSort((Sort)object2.getSort())) continue;
            bl = false;
        }
        object2 = OctagonState.rearrangeIfNecessary(this.bestAvailableClosure(), nArray);
        OctagonMatrix octagonMatrix = OctagonState.rearrangeIfNecessary(octagonState.bestAvailableClosure(), nArray2);
        return new OctagonState(hashMap, (OctagonMatrix)binaryOperator.apply((OctagonMatrix)object2, octagonMatrix), bl);
    }

    private static OctagonMatrix rearrangeIfNecessary(OctagonMatrix octagonMatrix, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != n) {
                return octagonMatrix.rearrange(nArray);
            }
            ++n;
        }
        return octagonMatrix;
    }

    private OctagonMatrix bestAvailableClosure() {
        if (this.mAllVarsAreInt && this.mMatrix.hasCachedTightClosure()) {
            return this.mMatrix.cachedTightClosure();
        }
        if (this.mMatrix.hasCachedStrongClosure()) {
            return this.mMatrix.cachedStrongClosure();
        }
        return this.mMatrix;
    }

    @Override
    public OctagonState widen(OctagonState octagonState) {
        return this.applyMergeOperator(octagonState, OctagonMatrix::widenSimple);
    }

    @Override
    public OctagonState join(OctagonState octagonState) {
        return this.applyMergeOperator(octagonState, OctagonMatrix::max);
    }

    @Override
    public boolean isBottom() {
        return this.cachedSelectiveClosure().hasNegativeSelfLoop();
    }
}

