/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser.yaml;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class Waypoint {
    private final String mConstraint;
    private final Location mLocation;
    private final String mConstraintFormat;

    protected Waypoint(String string, String string2, Location location) {
        this.mConstraint = string;
        this.mConstraintFormat = string2;
        this.mLocation = location;
    }

    public String getConstraint() {
        return this.mConstraint;
    }

    public Location getLocation() {
        return this.mLocation;
    }

    public abstract String getType();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getType()).append(' ').append(this.mLocation);
        if (this.mConstraint != null) {
            stringBuilder.append(": ").append(this.mConstraint);
        }
        return stringBuilder.toString();
    }

    public Map<String, Object> toMap(String string) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("type", this.getType());
        linkedHashMap.put("action", string);
        if (this.mConstraint != null) {
            LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
            linkedHashMap2.put("value", this.mConstraint);
            if (this.mConstraintFormat != null) {
                linkedHashMap2.put("format", this.mConstraintFormat);
            }
            linkedHashMap.put("constraint", linkedHashMap2);
        }
        linkedHashMap.put("location", this.mLocation.toMap());
        return linkedHashMap;
    }
}

