/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CompareReduceBuchiSimulation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.Minimize;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.hopcroft.MinimizeNftaHopcroft;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.performance.SinkMergeIntersectStateFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class CompareTaMinimization<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    public static final Path LOG_PATH = Paths.get(System.getProperty("user.home"), "Desktop", "performanceMeasurement");
    public static final String LOG_SEPARATOR = "\t";
    private static final String LOG_PATH_DATA = "testData.tsv";
    private final String mAutomatonName;
    private final List<String> mLoggedLines;
    private final ITreeAutomatonBU<LETTER, STATE> mOperand;
    private final SinkMergeIntersectStateFactory<STATE> mSinkAndMergeFactory;

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Parsing log file...");
        Path path = LOG_PATH.resolve(LOG_PATH_DATA);
        List<String> list = Files.readAllLines(path);
        System.out.println("Creating html files...");
        CompareReduceBuchiSimulation.tableToHtmlFile("instanceFullComparison", list);
        System.out.println("Terminated.");
    }

    private static void logHead(Path path) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("name");
        arrayList.add("size");
        arrayList.add("rules");
        arrayList.add("ordinary_type");
        arrayList.add("ordinary_time");
        arrayList.add("ordinary_timedOut");
        arrayList.add("ordinary_oom");
        arrayList.add("ordinary_size");
        arrayList.add("ordinary_rules");
        arrayList.add("hopcroft_type");
        arrayList.add("hopcroft_time");
        arrayList.add("hopcroft_timedOut");
        arrayList.add("hopcroft_oom");
        arrayList.add("hopcroft_size");
        arrayList.add("hopcroft_rules");
        String string = String.join((CharSequence)LOG_SEPARATOR, arrayList);
        try {
            Files.write(path, Collections.singletonList(string), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> CompareTaMinimization(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) {
        super(automataLibraryServices);
        this.mSinkAndMergeFactory = new SinkMergeIntersectStateFactory<STATE>(SF, SF, (IIntersectionStateFactory)SF);
        this.mOperand = iTreeAutomatonBU;
        this.mLoggedLines = new LinkedList<String>();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mAutomatonName = "";
        this.measurePerformances();
        this.flushLogToFile();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String getResult() {
        return "no result";
    }

    private void flushLogToFile() {
        Path path;
        if (!Files.exists(LOG_PATH, new LinkOption[0])) {
            try {
                Files.createDirectories(LOG_PATH, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (!Files.exists(path = LOG_PATH.resolve(LOG_PATH_DATA), new LinkOption[0])) {
            CompareTaMinimization.logHead(path);
        }
        try {
            Files.write(path, this.mLoggedLines, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mLoggedLines.clear();
        this.mLogger.info((Object)("Logged data to file (" + String.valueOf(path.toAbsolutePath()) + ")."));
    }

    private void logLine(String string) {
        this.mLoggedLines.add(string);
    }

    private void logResults(String[] ... stringArray2) {
        String[] stringArray3 = new String[]{this.mAutomatonName};
        String[] stringArray4 = new String[]{Integer.toString(this.mOperand.size()), Integer.toString(this.mOperand.getAmountOfRules())};
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray3));
        arrayList.addAll(Arrays.asList(stringArray4));
        Arrays.asList(stringArray2).forEach(stringArray -> {
            boolean bl = arrayList.addAll(Arrays.asList(stringArray));
        });
        String string = String.join((CharSequence)LOG_SEPARATOR, arrayList);
        this.logLine(string);
    }

    protected String[] measureMethodPerformance(String string) {
        String[] stringArray;
        GeneralOperation generalOperation;
        long l;
        boolean bl;
        boolean bl2;
        block7: {
            bl2 = false;
            bl = false;
            l = -1L;
            generalOperation = null;
            try {
                long l2;
                if (string.equalsIgnoreCase("ordinary")) {
                    l2 = System.currentTimeMillis();
                    generalOperation = new Minimize<LETTER, STATE>(this.mServices, this.mSinkAndMergeFactory, this.mOperand);
                    l = System.currentTimeMillis() - l2;
                    break block7;
                }
                if (string.equalsIgnoreCase("hopcroft")) {
                    l2 = System.currentTimeMillis();
                    generalOperation = new MinimizeNftaHopcroft<LETTER, STATE>(this.mServices, this.mSinkAndMergeFactory, this.mOperand);
                    l = System.currentTimeMillis() - l2;
                    break block7;
                }
                throw new IllegalArgumentException("Unsupported type of minimization");
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                this.mLogger.info((Object)"Method timed out.");
                bl2 = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.mLogger.info((Object)"Method has thrown an out of memory error.");
                bl = true;
            }
        }
        ITreeAutomatonBU iTreeAutomatonBU = null;
        if (generalOperation instanceof IOperation && (stringArray = ((IOperation)generalOperation).getResult()) instanceof ITreeAutomatonBU) {
            iTreeAutomatonBU = (ITreeAutomatonBU)stringArray;
        }
        if (iTreeAutomatonBU == null) {
            throw new AssertionError((Object)"Result is null but must not be. Cast-logic may be incorrect.");
        }
        stringArray = new String[]{string, Long.toString(l), Boolean.toString(bl2), Boolean.toString(bl), Integer.toString(iTreeAutomatonBU.size()), Integer.toString(iTreeAutomatonBU.getAmountOfRules())};
        return stringArray;
    }

    protected void measurePerformances() {
        String[] stringArray = this.measureMethodPerformance("ordinary");
        String[] stringArray2 = this.measureMethodPerformance("hopcroft");
        this.logResults(stringArray, stringArray2);
    }
}

