/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.EnumSet;

public class QuantifierOverapproximator
extends TermTransformer {
    private final Script mScript;
    private final Term mReplacement;
    private final EnumSet<Quantifier> mReplacedQuantifiers;

    private QuantifierOverapproximator(Script script) {
        this.mScript = script;
        this.mReplacement = this.mScript.term("true", new Term[0]);
        this.mReplacedQuantifiers = EnumSet.allOf(Quantifier.class);
    }

    private QuantifierOverapproximator(Script script, EnumSet<Quantifier> enumSet, Term term) {
        this.mScript = script;
        this.mReplacement = term;
        this.mReplacedQuantifiers = enumSet;
    }

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term term2 = SmtUtils.unzipNot((Term)applicationTerm);
            if (term2 != null) {
                if (!SmtUtils.isAtomicFormula(term2)) {
                    throw new AssertionError((Object)"NNF required for sound overapproximation.");
                }
                this.setResult(term);
                return;
            }
            super.convert(term);
            return;
        }
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            if (quantifiedFormula.getQuantifier() == 0) {
                if (this.mReplacedQuantifiers.contains((Object)Quantifier.EXISTS)) {
                    this.setResult(this.mReplacement);
                } else {
                    this.setResult(term);
                }
            } else if (quantifiedFormula.getQuantifier() == 1) {
                if (this.mReplacedQuantifiers.contains((Object)Quantifier.FORALL)) {
                    this.setResult(this.mReplacement);
                } else {
                    this.setResult(term);
                }
            } else {
                throw new AssertionError((Object)"Unknown quantifier");
            }
            return;
        }
        if (term instanceof TermVariable) {
            this.setResult(term);
            return;
        }
        if (term instanceof ConstantTerm) {
            this.setResult(term);
            return;
        }
        throw new UnsupportedOperationException("Unsupported kind of Term: " + term.getClass().getSimpleName());
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        this.setResult(SmtUtils.convertApplicationTerm(applicationTerm, termArray, this.mScript));
    }

    public static Term apply(Script script, Term term) {
        return new QuantifierOverapproximator(script).transform(term);
    }

    public static Term apply(Script script, EnumSet<Quantifier> enumSet, Term term, Term term2) {
        return new QuantifierOverapproximator(script, enumSet, term).transform(term2);
    }

    public static enum Quantifier {
        EXISTS,
        FORALL;

    }
}

