/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgStatementExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainStatementProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomainToolkit;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.Collections;
import java.util.List;

public class ArrayDomainPostOperator<STATE extends IAbstractState<STATE>>
implements IAbstractPostOperator<ArrayDomainState<STATE>, IcfgEdge> {
    private final ArrayDomainToolkit<STATE> mToolkit;
    private final RcfgStatementExtractor mStatementExtractor;
    private final ArrayDomainStatementProcessor<STATE> mStatementProcessor;

    public ArrayDomainPostOperator(ArrayDomainToolkit<STATE> arrayDomainToolkit) {
        this.mToolkit = arrayDomainToolkit;
        this.mStatementExtractor = new RcfgStatementExtractor();
        this.mStatementProcessor = new ArrayDomainStatementProcessor<STATE>(arrayDomainToolkit);
    }

    public List<ArrayDomainState<STATE>> apply(ArrayDomainState<STATE> arrayDomainState, IcfgEdge icfgEdge) {
        assert (arrayDomainState != null);
        assert (!arrayDomainState.isBottom()) : "You should not need to calculate post of a bottom state";
        assert (icfgEdge != null);
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        if (icfgEdge2 instanceof Summary) {
            if (!((Summary)icfgEdge2).calledProcedureHasImplementation()) {
                throw new UnsupportedOperationException("Summary for procedure without implementation: " + BoogiePrettyPrinter.print((Statement)((Summary)icfgEdge2).getCallStatement()));
            }
            return this.handleReturnTransition(arrayDomainState, arrayDomainState, icfgEdge2);
        }
        if (icfgEdge2 instanceof IIcfgInternalTransition) {
            return this.handleInternalTransition(arrayDomainState, icfgEdge2);
        }
        if (icfgEdge2 instanceof Call) {
            return this.handleCallTransition(arrayDomainState, arrayDomainState, (Call)icfgEdge2);
        }
        if (icfgEdge2 instanceof Return) {
            return this.handleReturnTransition(arrayDomainState, arrayDomainState, icfgEdge2);
        }
        throw new UnsupportedOperationException("Unknown transition type: " + String.valueOf(icfgEdge2.getClass()));
    }

    public List<ArrayDomainState<STATE>> apply(ArrayDomainState<STATE> arrayDomainState, ArrayDomainState<STATE> arrayDomainState2, IcfgEdge icfgEdge) {
        assert (arrayDomainState != null);
        assert (!arrayDomainState.isBottom()) : "You should not need to calculate post of a bottom state (BL)";
        assert (arrayDomainState2 != null);
        assert (!arrayDomainState2.isBottom()) : "You should not need to calculate post of a bottom state (AL)";
        assert (icfgEdge != null);
        IcfgEdge icfgEdge2 = icfgEdge.getLabel();
        assert (icfgEdge2 instanceof Call || icfgEdge2 instanceof Return || icfgEdge2 instanceof Summary) : "Cannot calculate hierachical post for non-hierachical transition";
        if (icfgEdge2 instanceof Call) {
            Call call = (Call)icfgEdge2;
            return this.handleCallTransition(arrayDomainState, arrayDomainState2, call);
        }
        if (icfgEdge2 instanceof Return || icfgEdge2 instanceof Summary) {
            return this.handleReturnTransition(arrayDomainState, arrayDomainState2, icfgEdge2);
        }
        throw new UnsupportedOperationException("Array domain does not support context switches other than Call and Return (yet)");
    }

    private List<ArrayDomainState<STATE>> handleCallTransition(ArrayDomainState<STATE> arrayDomainState, ArrayDomainState<STATE> arrayDomainState2, Call call) {
        throw new UnsupportedOperationException("Array domain does not support Call yet");
    }

    private List<ArrayDomainState<STATE>> handleReturnTransition(ArrayDomainState<STATE> arrayDomainState, ArrayDomainState<STATE> arrayDomainState2, IcfgEdge icfgEdge) {
        throw new UnsupportedOperationException("Array domain does not support Return yet");
    }

    private List<ArrayDomainState<STATE>> handleInternalTransition(ArrayDomainState<STATE> arrayDomainState, IcfgEdge icfgEdge) {
        ArrayDomainState<STATE> arrayDomainState2 = arrayDomainState;
        List<Statement> list = this.mStatementExtractor.process(icfgEdge.getLabel());
        for (Statement statement : list) {
            arrayDomainState2 = this.mStatementProcessor.process(arrayDomainState2, statement);
        }
        return Collections.singletonList(arrayDomainState2);
    }

    public IAbstractPostOperator.EvalResult evaluate(ArrayDomainState<STATE> arrayDomainState, Term term, Script script) {
        return this.mToolkit.evaluate(arrayDomainState.getSubState(), term, false);
    }
}

