/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAssertCodeBlocks;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAssertConjunctsOfCodeBlocks;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.RelevantTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.RelevantVariables;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TraceCheckSpWp<L extends IAction>
extends InterpolatingTraceCheck<L> {
    protected List<IPredicate> mInterpolantsFp;
    protected List<IPredicate> mInterpolantsBp;
    private final ITraceCheckPreferences.UnsatCores mUnsatCores;
    private final boolean mLiveVariables;
    private static final boolean USE_LIVE_VARIABLES_INSTEAD_OF_RELEVANT_VARIABLES = false;
    private static final boolean POST_PROCESS_FP_PREDICATES = false;
    private final boolean mConstructForwardInterpolantSequence;
    private static final boolean DEBUG_CHECK_SP_IMPLIES_WP = false;
    private final ConstructBackwardSequence mConstructBackwardInterpolantSequence;
    private AnnotateAndAssertConjunctsOfCodeBlocks<L> mAnnotateAndAsserterConjuncts;
    private final InterpolantComputationStatus mInterpolantComputationStatus;
    private int mNonLiveVariablesFp = 0;
    private int mNonLiveVariablesBp = 0;
    private boolean mPerfectForwardSequence;
    private boolean mPerfectBackwardSequence;
    private boolean mAlternatingQuantifierBailout;

    public TraceCheckSpWp(IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Counterexample<L> counterexample, CfgSmtToolkit cfgSmtToolkit, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, ITraceCheckPreferences.UnsatCores unsatCores, boolean bl, IUltimateServiceProvider iUltimateServiceProvider, boolean bl2, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, InterpolationTechnique interpolationTechnique, ManagedScript managedScript, SmtUtils.SimplificationTechnique simplificationTechnique, boolean bl3) {
        super(iPredicate, iPredicate2, sortedMap, counterexample, iUltimateServiceProvider, cfgSmtToolkit, managedScript, predicateFactory, iPredicateUnifier, assertCodeBlockOrder, bl2, bl3, simplificationTechnique);
        this.mUnsatCores = unsatCores;
        this.mLiveVariables = bl;
        switch (interpolationTechnique) {
            case ForwardPredicates: {
                this.mConstructForwardInterpolantSequence = true;
                this.mConstructBackwardInterpolantSequence = ConstructBackwardSequence.NO;
                this.mAlternatingQuantifierBailout = false;
                break;
            }
            case BackwardPredicates: {
                this.mConstructForwardInterpolantSequence = false;
                this.mConstructBackwardInterpolantSequence = ConstructBackwardSequence.YES;
                this.mAlternatingQuantifierBailout = false;
                break;
            }
            case FPandBP: {
                this.mConstructForwardInterpolantSequence = true;
                this.mConstructBackwardInterpolantSequence = ConstructBackwardSequence.YES;
                this.mAlternatingQuantifierBailout = false;
                break;
            }
            case FPandBPonlyIfFpWasNotPerfect: {
                this.mConstructForwardInterpolantSequence = true;
                this.mConstructBackwardInterpolantSequence = ConstructBackwardSequence.IF_FP_WAS_NOT_PERFECT;
                this.mAlternatingQuantifierBailout = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupportedInterpolation");
            }
        }
        Script.LBool lBool = this.isCorrect();
        if (lBool == Script.LBool.UNSAT) {
            InterpolantComputationStatus interpolantComputationStatus = null;
            try {
                this.computeInterpolants(interpolationTechnique);
                interpolantComputationStatus = new InterpolantComputationStatus();
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                throw toolchainCanceledException;
            }
            catch (Throwable throwable) {
                interpolantComputationStatus = new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CRASH, throwable);
            }
            this.mInterpolantComputationStatus = interpolantComputationStatus;
        } else {
            this.mInterpolantComputationStatus = lBool == Script.LBool.SAT ? new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.TRACE_FEASIBLE, null) : new InterpolantComputationStatus(InterpolantComputationStatus.ItpErrorStatus.SMT_SOLVER_CANNOT_INTERPOLATE_INPUT, null);
        }
    }

    @Override
    public void computeInterpolants(InterpolationTechnique interpolationTechnique) {
        this.mTraceCheckBenchmarkGenerator.start(TraceCheckStatisticsDefinitions.InterpolantComputationTime.toString());
        try {
            this.computeInterpolantsUsingUnsatCore();
        }
        finally {
            this.mTraceCheckBenchmarkGenerator.stop(TraceCheckStatisticsDefinitions.InterpolantComputationTime.toString());
        }
        this.mTraceCheckFinished = true;
    }

    public boolean wasForwardPredicateComputationRequested() {
        return this.mConstructForwardInterpolantSequence;
    }

    public boolean wasBackwardsPredicatesComputationRequested() {
        return this.mConstructBackwardInterpolantSequence == ConstructBackwardSequence.YES || this.mConstructBackwardInterpolantSequence == ConstructBackwardSequence.IF_FP_WAS_NOT_PERFECT && !this.isForwardSequencePerfect();
    }

    public boolean wasBackwardSequenceConstructed() {
        return this.mInterpolantsBp != null;
    }

    public List<IPredicate> getForwardPredicates() {
        assert (this.mInterpolantsFp != null) : "Forwards predicates not computed!";
        return this.mInterpolantsFp;
    }

    public TracePredicates getForwardIpp() {
        return new TracePredicates(this.getPrecondition(), this.getPostcondition(), this.getForwardPredicates());
    }

    public List<IPredicate> getBackwardPredicates() {
        assert (this.mInterpolantsBp != null) : "Backwards predicates not computed!";
        return this.mInterpolantsBp;
    }

    public TracePredicates getBackwardIpp() {
        return new TracePredicates(this.getPrecondition(), this.getPostcondition(), this.getBackwardPredicates());
    }

    private void computeInterpolantsUsingUnsatCore() {
        IterativePredicateTransformer<L> iterativePredicateTransformer;
        ArrayList<IterativePredicateTransformer.IPredicatePostprocessor> arrayList;
        HashSet<Term> hashSet = new HashSet<Term>(Arrays.asList(this.mTcSmtManager.getScript().getUnsatCore()));
        this.cleanupAndUnlockSolver();
        int n = this.mAnnotateAndAsserterConjuncts.getAnnotated2Original().size();
        int n2 = this.mUnsatCores == ITraceCheckPreferences.UnsatCores.IGNORE ? 0 : hashSet.size();
        if (this.mLogger.isInfoEnabled()) {
            arrayList = "Trace formula consists of " + n + " conjuncts, " + hashSet.size() + " conjuncts are in the unsatisfiable core";
            if (hashSet.size() * 2 >= n) {
                this.mLogger.warn((Object)arrayList);
            } else {
                this.mLogger.info((Object)arrayList);
            }
        }
        this.mTraceCheckBenchmarkGenerator.setConjunctsInSSA(n, n2);
        NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas = this.constructRelevantTransFormulas(hashSet);
        assert (this.stillInfeasible(nestedFormulas)) : "incorrect Unsatisfiable Core! trace length " + this.mTrace.length() + " unsat-core size " + hashSet.size();
        arrayList = new RelevantVariables<L>(nestedFormulas, this.mCsToolkit.getModifiableGlobalsTable());
        Set<IProgramVar>[] setArray = ((RelevantVariables)((Object)arrayList)).getRelevantVariables();
        if (this.mConstructForwardInterpolantSequence) {
            this.mLogger.info((Object)"Computing forward predicates...");
            try {
                arrayList = new ArrayList<IterativePredicateTransformer.IPredicatePostprocessor>();
                if (this.mLiveVariables) {
                    arrayList.add(new LiveVariablesPostprocessorForward(setArray));
                }
                arrayList.add(new IterativePredicateTransformer.QuantifierEliminationPostprocessor(this.mServices, this.mCfgManagedScript, (BasicPredicateFactory)this.mPredicateFactory, this.mSimplificationTechnique));
                arrayList.add(new UnifyPostprocessor(this.mPredicateUnifier));
                iterativePredicateTransformer = new IterativePredicateTransformer<L>((BasicPredicateFactory)this.mPredicateFactory, this.mCfgManagedScript, this.mCsToolkit.getModifiableGlobalsTable(), this.mServices, this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, null, this.mSimplificationTechnique, this.mBoogie2SmtSymbolTable);
                this.mInterpolantsFp = iterativePredicateTransformer.computeStrongestPostconditionSequence(nestedFormulas, arrayList).getPredicates();
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing forward predicates"));
                throw toolchainCanceledException;
            }
            assert (TraceCheckUtils.checkInterpolantsInductivityForward(this.mInterpolantsFp, (NestedWord<? extends IAction>)this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, "FP", this.mCsToolkit, this.mLogger)) : "invalid Hoare triple in FP";
            this.mTraceCheckBenchmarkGenerator.reportSequenceOfInterpolants(this.mInterpolantsFp, TraceCheckStatisticsGenerator.InterpolantType.Forward);
            this.mTraceCheckBenchmarkGenerator.reportNumberOfNonLiveVariables(this.mNonLiveVariablesFp, TraceCheckStatisticsGenerator.InterpolantType.Forward);
            this.mTraceCheckBenchmarkGenerator.reportInterpolantComputation();
            this.mPerfectForwardSequence = this.checkPerfectSequence(this.getForwardIpp());
        }
        if (this.mConstructBackwardInterpolantSequence == ConstructBackwardSequence.IF_FP_WAS_NOT_PERFECT && this.isForwardSequencePerfect()) {
            this.mLogger.info((Object)"Omiting computation of backward sequence because forward sequence was already perfect");
        }
        if (this.wasBackwardsPredicatesComputationRequested()) {
            this.mLogger.info((Object)"Computing backward predicates...");
            try {
                arrayList = new ArrayList();
                if (this.mLiveVariables) {
                    arrayList.add(new LiveVariablesPostprocessorBackward(setArray));
                }
                arrayList.add(new IterativePredicateTransformer.QuantifierEliminationPostprocessor(this.mServices, this.mCfgManagedScript, (BasicPredicateFactory)this.mPredicateFactory, this.mSimplificationTechnique));
                arrayList.add(new UnifyPostprocessor(this.mPredicateUnifier));
                iterativePredicateTransformer = new IterativePredicateTransformer((BasicPredicateFactory)this.mPredicateFactory, this.mCfgManagedScript, this.mCsToolkit.getModifiableGlobalsTable(), this.mServices, this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, null, this.mSimplificationTechnique, this.mBoogie2SmtSymbolTable);
                this.mInterpolantsBp = iterativePredicateTransformer.computeWeakestPreconditionSequence(nestedFormulas, arrayList, false, this.mAlternatingQuantifierBailout).getPredicates();
                assert (TraceCheckUtils.checkInterpolantsInductivityBackward(this.mInterpolantsBp, (NestedWord<? extends IAction>)this.mTrace, this.mPrecondition, this.mPostcondition, this.mPendingContexts, "BP", this.mCsToolkit, this.mLogger, this.mCfgManagedScript)) : "invalid Hoare triple in BP";
                this.mTraceCheckBenchmarkGenerator.reportSequenceOfInterpolants(this.mInterpolantsBp, TraceCheckStatisticsGenerator.InterpolantType.Backward);
                this.mTraceCheckBenchmarkGenerator.reportNumberOfNonLiveVariables(this.mNonLiveVariablesBp, TraceCheckStatisticsGenerator.InterpolantType.Backward);
                this.mTraceCheckBenchmarkGenerator.reportInterpolantComputation();
                this.mPerfectBackwardSequence = this.checkPerfectSequence(this.getBackwardIpp());
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing backward predicates"));
                throw toolchainCanceledException;
            }
            catch (IterativePredicateTransformer.TraceInterpolationException traceInterpolationException) {
                if (traceInterpolationException.getReason() == IterativePredicateTransformer.TraceInterpolationException.Reason.ALTERNATING_QUANTIFIER_BAILOUT) {
                    this.mInterpolantsBp = null;
                }
                throw new AssertionError("unknown reason", traceInterpolationException);
            }
        }
        if (this.mConstructForwardInterpolantSequence) {
            this.wasBackwardSequenceConstructed();
        }
        if (this.mConstructForwardInterpolantSequence && this.wasBackwardSequenceConstructed()) {
            this.mInterpolants = null;
        } else if (this.mConstructForwardInterpolantSequence) {
            this.mInterpolants = this.mInterpolantsFp.toArray(new IPredicate[this.mInterpolantsFp.size()]);
        } else if (this.wasBackwardSequenceConstructed()) {
            this.mInterpolants = this.mInterpolantsBp.toArray(new IPredicate[this.mInterpolantsBp.size()]);
        } else {
            throw new AssertionError((Object)"illegal choice");
        }
    }

    private NestedFormulas<L, UnmodifiableTransFormula, IPredicate> constructRelevantTransFormulas(Set<Term> set) {
        return switch (this.mUnsatCores) {
            case ITraceCheckPreferences.UnsatCores.IGNORE -> new DefaultTransFormulas(this.mNestedFormulas.getCounterexample(), this.mPrecondition, this.mPostcondition, (SortedMap<Integer, IPredicate>)this.mPendingContexts, this.mCsToolkit.getOldVarsAssignmentCache(), false);
            case ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL -> new RelevantTransFormulas<L>(this.mNestedFormulas, this.mPrecondition, this.mPostcondition, (SortedMap<Integer, IPredicate>)this.mPendingContexts, set, this.mCsToolkit.getOldVarsAssignmentCache(), this.mCfgManagedScript, this.mAAA, this.mAnnotateAndAsserterConjuncts);
            case ITraceCheckPreferences.UnsatCores.STATEMENT_LEVEL -> {
                boolean[] var2_2 = new boolean[this.mTrace.length()];
                boolean[] var3_3 = new boolean[this.mTrace.length()];
                Set<L> var4_4 = this.filterOutIrrelevantStatements(this.mTrace, set, var2_2, var3_3);
                yield new RelevantTransFormulas(this.mNestedFormulas.getCounterexample(), this.mPrecondition, this.mPostcondition, (SortedMap<Integer, IPredicate>)this.mPendingContexts, var4_4, this.mCsToolkit.getOldVarsAssignmentCache(), var2_2, var3_3, this.mCfgManagedScript);
            }
            default -> throw new MatchException(null, null);
        };
    }

    private void selectListOFPredicatesFromBothTypes() {
        assert (this.mInterpolantsFp.size() == this.mInterpolantsBp.size());
        this.mInterpolants = new IPredicate[this.mInterpolantsBp.size()];
        int n = 0;
        int n2 = this.mInterpolantsBp.size();
        while (n != n2) {
            if (QuantifierUtils.isQuantifierFree((Term)this.mInterpolantsBp.get(n2 - 1).getFormula())) {
                this.mInterpolants[n2 - 1] = this.mInterpolantsBp.get(n2 - 1);
                --n2;
                continue;
            }
            if (QuantifierUtils.isQuantifierFree((Term)this.mInterpolantsFp.get(n).getFormula())) {
                this.mInterpolants[n] = this.mInterpolantsFp.get(n);
                ++n;
                continue;
            }
            throw new UnsupportedOperationException("removed in refactoring");
        }
    }

    private boolean stillInfeasible(NestedFormulas<L, UnmodifiableTransFormula, IPredicate> nestedFormulas) {
        TraceCheck<L> traceCheck = new TraceCheck<L>(nestedFormulas.getPrecondition(), nestedFormulas.getPostcondition(), new TreeMap<Integer, IPredicate>(), nestedFormulas, this.mServices, this.mCsToolkit, ITraceCheckPreferences.AssertCodeBlockOrder.NOT_INCREMENTALLY, false, true, true);
        boolean bl = traceCheck.isCorrect() != Script.LBool.SAT;
        return bl;
    }

    private Set<L> filterOutIrrelevantStatements(NestedWord<L> nestedWord, Set<Term> set, boolean[] blArray, boolean[] blArray2) {
        HashSet<IAction> hashSet = new HashSet<IAction>();
        int n = 0;
        while (n < nestedWord.length()) {
            if (!nestedWord.isCallPosition(n) && set.contains(this.mAAA.getAnnotatedSsa().getFormulaFromNonCallPos(n))) {
                hashSet.add((IAction)nestedWord.getSymbol(n));
            } else if (nestedWord.isCallPosition(n) && (set.contains(this.mAAA.getAnnotatedSsa().getGlobalVarAssignment(n)) || set.contains(this.mAAA.getAnnotatedSsa().getOldVarAssignment(n)))) {
                if (set.contains(this.mAAA.getAnnotatedSsa().getLocalVarAssignment(n))) {
                    blArray[n] = true;
                }
                if (set.contains(this.mAAA.getAnnotatedSsa().getOldVarAssignment(n))) {
                    blArray2[n] = true;
                }
                hashSet.add((IAction)nestedWord.getSymbol(n));
            } else if (nestedWord.getSymbol(n) instanceof ICallAction && set.contains(this.mAAA.getAnnotatedSsa().getLocalVarAssignment(n))) {
                blArray[n] = true;
            }
            ++n;
        }
        return hashSet;
    }

    private static Set<TermVariable> computeIrrelevantVariables(Set<IProgramVar> set, IPredicate iPredicate) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            if (set.contains(iProgramVar)) continue;
            hashSet.add(iProgramVar.getTermVariable());
        }
        return hashSet;
    }

    private void checkSPImpliesWP(List<IPredicate> list, List<IPredicate> list2) {
        this.mLogger.debug((Object)"Checking implication of SP and WP...");
        MonolithicImplicationChecker monolithicImplicationChecker = new MonolithicImplicationChecker(this.mServices, this.mCfgManagedScript);
        int n = 0;
        while (n < list.size()) {
            IncrementalPlicationChecker.Validity validity = monolithicImplicationChecker.checkImplication(list.get(n), false, list2.get(n), false);
            this.mLogger.debug((Object)("SP {" + String.valueOf(list.get(n)) + "} ==> WP {" + String.valueOf(list2.get(n)) + "} is " + String.valueOf(validity == IncrementalPlicationChecker.Validity.VALID ? "valid" : (validity == IncrementalPlicationChecker.Validity.INVALID ? "not valid" : validity))));
            assert (validity == IncrementalPlicationChecker.Validity.VALID || validity == IncrementalPlicationChecker.Validity.UNKNOWN) : "checkSPImpliesWP failed";
            ++n;
        }
    }

    @Override
    protected AnnotateAndAssertCodeBlocks<L> getAnnotateAndAsserterCodeBlocks(NestedFormulas<L, Term, Term> nestedFormulas) {
        if (this.mAnnotateAndAsserterConjuncts == null) {
            this.mAnnotateAndAsserterConjuncts = new AnnotateAndAssertConjunctsOfCodeBlocks<L>(this.mTcSmtManager, this.mTraceCheckLock, nestedFormulas, this.mNestedFormulas, this.mLogger, this.mCfgManagedScript);
        }
        return this.mAnnotateAndAsserterConjuncts;
    }

    public boolean isForwardSequencePerfect() {
        if (this.mInterpolantsFp == null) {
            throw new UnsupportedOperationException("forward sequence not constructed");
        }
        return this.mPerfectForwardSequence;
    }

    public boolean isBackwardSequencePerfect() {
        if (this.mInterpolantsBp == null) {
            throw new UnsupportedOperationException("backward sequence not constructed");
        }
        return this.mPerfectBackwardSequence;
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mInterpolantComputationStatus;
    }

    private static enum ConstructBackwardSequence {
        YES,
        NO,
        IF_FP_WAS_NOT_PERFECT;

    }

    public class LiveVariablesPostprocessorBackward
    implements IterativePredicateTransformer.IPredicatePostprocessor {
        private final Set<IProgramVar>[] mRelevantVars;

        public LiveVariablesPostprocessorBackward(Set<IProgramVar>[] setArray) {
            this.mRelevantVars = setArray;
        }

        @Override
        public IPredicate postprocess(IPredicate iPredicate, int n) {
            assert (TraceCheckSpWp.this.mLiveVariables) : "use this postprocessor only if mLiveVariables";
            Set<TermVariable> set = TraceCheckSpWp.computeIrrelevantVariables(this.mRelevantVars[n], iPredicate);
            Term term = SmtUtils.quantifier((Script)TraceCheckSpWp.this.mCfgManagedScript.getScript(), (int)1, set, (Term)iPredicate.getFormula());
            Term term2 = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)TraceCheckSpWp.this.mServices, (ManagedScript)TraceCheckSpWp.this.mCfgManagedScript, (Term)term);
            BasicPredicate basicPredicate = TraceCheckSpWp.this.mPredicateFactory.newPredicate(term2);
            TraceCheckSpWp.this.mNonLiveVariablesBp += set.size();
            return basicPredicate;
        }
    }

    public class LiveVariablesPostprocessorForward
    implements IterativePredicateTransformer.IPredicatePostprocessor {
        private final Set<IProgramVar>[] mRelevantVars;

        public LiveVariablesPostprocessorForward(Set<IProgramVar>[] setArray) {
            this.mRelevantVars = setArray;
        }

        @Override
        public IPredicate postprocess(IPredicate iPredicate, int n) {
            assert (TraceCheckSpWp.this.mLiveVariables) : "use this postprocessor only if mLiveVariables";
            Set<TermVariable> set = TraceCheckSpWp.computeIrrelevantVariables(this.mRelevantVars[n], iPredicate);
            Term term = SmtUtils.quantifier((Script)TraceCheckSpWp.this.mCfgManagedScript.getScript(), (int)0, set, (Term)iPredicate.getFormula());
            Term term2 = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)TraceCheckSpWp.this.mServices, (ManagedScript)TraceCheckSpWp.this.mCfgManagedScript, (Term)term);
            BasicPredicate basicPredicate = TraceCheckSpWp.this.mPredicateFactory.newPredicate(term2);
            TraceCheckSpWp.this.mNonLiveVariablesFp += set.size();
            return basicPredicate;
        }
    }

    public static class UnifyPostprocessor
    implements IterativePredicateTransformer.IPredicatePostprocessor {
        private final IPredicateUnifier mPredicateUnifier;

        public UnifyPostprocessor(IPredicateUnifier iPredicateUnifier) {
            this.mPredicateUnifier = iPredicateUnifier;
        }

        @Override
        public IPredicate postprocess(IPredicate iPredicate, int n) {
            IPredicate iPredicate2 = this.mPredicateUnifier.getOrConstructPredicate(iPredicate.getFormula());
            return iPredicate2;
        }
    }
}

