/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import java.util.Set;

public final class ChcSolution
extends BasePayloadContainer {
    private static final long serialVersionUID = -4389502364282768199L;
    private final Script.LBool mSatisfiability;
    private final Model mModel;
    private final Derivation mDerivation;
    private final Set<HornClause> mUnsatCore;

    private ChcSolution(Script.LBool lBool, Model model, Derivation derivation, Set<HornClause> set) {
        this.mSatisfiability = lBool;
        this.mModel = model;
        this.mDerivation = derivation;
        this.mUnsatCore = set;
    }

    public static ChcSolution sat(Model model) {
        return new ChcSolution(Script.LBool.SAT, model, null, null);
    }

    public static ChcSolution unsat(Derivation derivation, Set<HornClause> set) {
        return new ChcSolution(Script.LBool.UNSAT, null, derivation, set);
    }

    public static ChcSolution unknown() {
        return new ChcSolution(Script.LBool.UNKNOWN, null, null, null);
    }

    public Script.LBool getSatisfiability() {
        return this.mSatisfiability;
    }

    public Model getModel() {
        return this.mModel;
    }

    public Derivation getDerivation() {
        return this.mDerivation;
    }

    public Set<HornClause> getUnsatCore() {
        return this.mUnsatCore;
    }
}

