/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.ACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CLocation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.BacktranslatedACSLValue;
import java.util.EnumSet;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IPointerType;

public class CACSLBacktranslationValueProvider
implements IBacktranslationValueProvider<CACSLLocation, BacktranslatedACSLValue> {
    public int getStartLineNumberFromStep(CACSLLocation cACSLLocation) {
        return cACSLLocation.getStartLine();
    }

    public int getEndLineNumberFromStep(CACSLLocation cACSLLocation) {
        return cACSLLocation.getEndLine();
    }

    public int getLineNumberFromStep(CACSLLocation cACSLLocation, EnumSet<AtomicTraceElement.StepInfo> enumSet) {
        if (enumSet.contains(AtomicTraceElement.StepInfo.PROC_CALL) || enumSet.contains(AtomicTraceElement.StepInfo.PROC_RETURN)) {
            return cACSLLocation.getEndLine();
        }
        if ((enumSet.contains(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE) || enumSet.contains(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) && cACSLLocation instanceof CLocation) {
            CLocation cLocation = ((CLocation)cACSLLocation).getParent();
            return cLocation != null ? cLocation.getStartLine() : -1;
        }
        return cACSLLocation.getStartLine();
    }

    public int getColumnNumberFromStep(CACSLLocation cACSLLocation, EnumSet<AtomicTraceElement.StepInfo> enumSet) {
        if (enumSet.contains(AtomicTraceElement.StepInfo.PROC_CALL) || enumSet.contains(AtomicTraceElement.StepInfo.PROC_RETURN)) {
            return cACSLLocation.getEndColumn() - 1;
        }
        if ((enumSet.contains(AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE) || enumSet.contains(AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE)) && cACSLLocation instanceof CLocation) {
            CLocation cLocation = (CLocation)cACSLLocation;
            CLocation cLocation2 = cLocation.getParent();
            return cLocation2 == null ? -1 : cLocation2.getStartColumn();
        }
        return cACSLLocation.getStartColumn();
    }

    public String getFunctionFromStep(CACSLLocation cACSLLocation) {
        return cACSLLocation.getFunction();
    }

    public String getStringFromStep(CACSLLocation cACSLLocation) {
        if (cACSLLocation instanceof CLocation) {
            return this.getStringFromIASTNode(((CLocation)cACSLLocation).getNode());
        }
        if (cACSLLocation instanceof ACSLLocation) {
            return ACSLPrettyPrinter.print((ACSLNode)((ACSLLocation)cACSLLocation).getNode());
        }
        throw new UnsupportedOperationException();
    }

    public String getStringFromTraceElement(CACSLLocation cACSLLocation) {
        return this.getStringFromStep(cACSLLocation);
    }

    public String getStringFromExpression(BacktranslatedACSLValue backtranslatedACSLValue) {
        return backtranslatedACSLValue.toString();
    }

    private String getStringFromIASTNode(IASTNode iASTNode) {
        Object object = iASTNode.getRawSignature();
        if (iASTNode instanceof IASTIdExpression) {
            IASTIdExpression iASTIdExpression = (IASTIdExpression)iASTNode;
            object = iASTIdExpression.getExpressionType() instanceof IPointerType ? "\\read(" + this.getPointerStars((IPointerType)iASTIdExpression.getExpressionType()) + (String)object + ")" : "\\read(" + (String)object + ")";
        }
        return object;
    }

    private String getPointerStars(IPointerType iPointerType) {
        if (iPointerType.getType() instanceof IPointerType) {
            return "*" + this.getPointerStars((IPointerType)iPointerType.getType());
        }
        return "*";
    }

    public String getFileNameFromStep(CACSLLocation cACSLLocation) {
        return cACSLLocation.getFileName();
    }

    public String getOriginFileNameFromStep(CACSLLocation cACSLLocation) {
        return cACSLLocation.getFileName();
    }

    public boolean isValidAssumptionLocation(CACSLLocation cACSLLocation) {
        if (cACSLLocation instanceof CLocation) {
            IASTNode iASTNode = ((CLocation)cACSLLocation).getNode();
            if (iASTNode instanceof IASTFunctionCallExpression) {
                return false;
            }
            return iASTNode instanceof IASTStatement || iASTNode instanceof IASTSimpleDeclaration || iASTNode.getParent() instanceof IASTExpressionStatement || iASTNode.getParent() instanceof IASTIfStatement;
        }
        return false;
    }
}

