/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.FalseFlag;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IAutomatonStatePartition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IBlock;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IFlag;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import java.util.Set;

public class MinimizeSevpa<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    private static final boolean ONLY_ONE_TO_WORK_LIST = false;
    private static final boolean SPLIT_ALL_RETURNS_LIN = false;
    private static final boolean SPLIT_ALL_RETURNS_HIER = false;
    private static final boolean STATISTICS = false;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mDoubleDecker;
    private int mEquivalenceClassId;
    private Partition mPartition;
    private int mSplitsWithChange;
    private int mSplitsWithoutChange;
    private final IFlag mTimeout;
    private boolean mConstructionInterrupted;
    private final boolean mInitialPartitionSeparatesFinalsAndNonfinals;

    public MinimizeSevpa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, null, false, false);
    }

    public MinimizeSevpa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, boolean bl2) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, new FalseFlag(), bl2);
    }

    public MinimizeSevpa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, IFlag iFlag, boolean bl2) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        if (iNestedWordAutomaton instanceof IDoubleDeckerAutomaton) {
            this.mDoubleDecker = (IDoubleDeckerAutomaton)iNestedWordAutomaton;
        } else {
            if (!this.isFiniteAutomaton()) {
                throw new IllegalArgumentException("The input must either be a finite automaton or an IDoubleDeckerAutomaton.");
            }
            this.mDoubleDecker = null;
        }
        this.mTimeout = iFlag;
        this.mInitialPartitionSeparatesFinalsAndNonfinals = bl2;
        this.minimize(partitionBackedSetOfPairs, bl);
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private void minimize(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) throws AutomataOperationCanceledException {
        if (this.isCancellationRequested()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
        StatesContainer statesContainer = new StatesContainer(this.mOperand);
        this.mergeStates(statesContainer, partitionBackedSetOfPairs, bl);
    }

    private void mergeStates(StatesContainer statesContainer, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl) throws AutomataOperationCanceledException {
        assert (this.mPartition == null);
        if (partitionBackedSetOfPairs == null) {
            this.mPartition = this.createInitialPartition(statesContainer);
        } else {
            Object object = partitionBackedSetOfPairs.getRelation();
            this.mPartition = new Partition(this.mOperand, statesContainer.size());
            if (this.mInitialPartitionSeparatesFinalsAndNonfinals) {
                assert (this.assertStatesSeparation((Collection<Set<STATE>>)object)) : "initial partition does not separate final/non-final states";
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Set set = (Set)iterator.next();
                    assert (!set.isEmpty());
                    this.mPartition.addEquivalenceClass(new EquivalenceClass(set, this.mOperand.isFinal(set.iterator().next())));
                }
            } else {
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Set set = (Set)iterator.next();
                    for (Object e : set) {
                        if (this.mOperand.isFinal(e)) {
                            hashSet.add(e);
                            continue;
                        }
                        hashSet2.add(e);
                    }
                    if (!hashSet.isEmpty()) {
                        this.mPartition.addEquivalenceClass(new EquivalenceClass(hashSet, true));
                        hashSet = new HashSet();
                    }
                    if (hashSet2.isEmpty()) continue;
                    this.mPartition.addEquivalenceClass(new EquivalenceClass(hashSet2, false));
                    hashSet2 = new HashSet();
                }
            }
        }
        statesContainer.delete();
        statesContainer = null;
        this.refinePartition();
        this.constructAutomaton(bl);
    }

    private boolean assertStatesSeparation(Collection<Set<STATE>> collection) {
        for (Set<STATE> set : collection) {
            Iterator<STATE> iterator = set.iterator();
            assert (iterator.hasNext());
            boolean bl = this.mOperand.isFinal(iterator.next());
            while (iterator.hasNext()) {
                if (bl == this.mOperand.isFinal(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    private Partition createInitialPartition(StatesContainer statesContainer) {
        Object object;
        Partition partition2;
        HashSet<Object> hashSet;
        HashSet<Object> hashSet2;
        if (statesContainer.wasCopied()) {
            hashSet2 = statesContainer.getFinals();
            hashSet = statesContainer.getNonfinals();
        } else {
            hashSet2 = new HashSet(MinimizeSevpa.computeHashCap(this.mOperand.getFinalStates().size()));
            hashSet = new HashSet(MinimizeSevpa.computeHashCap(this.mOperand.size() - this.mOperand.getFinalStates().size()));
            for (Partition partition2 : this.mOperand.getStates()) {
                if (this.mOperand.isFinal(partition2)) {
                    hashSet2.add(partition2);
                    continue;
                }
                hashSet.add(partition2);
            }
        }
        partition2 = new Partition(this.mOperand, hashSet2.size() + hashSet.size());
        if (!hashSet2.isEmpty()) {
            object = new EquivalenceClass(hashSet2, true, true);
            partition2.addEquivalenceClass((EquivalenceClass)object);
        }
        if (!hashSet.isEmpty()) {
            object = new EquivalenceClass(hashSet, false, true);
            partition2.addEquivalenceClass((EquivalenceClass)object);
        }
        return partition2;
    }

    /*
     * Unable to fully structure code
     */
    private void refinePartition() throws AutomataOperationCanceledException {
        var1_1 = true;
        var2_2 = true;
        var3_3 = this.mPartition.getEquivalenceClasses().size();
        while (true) {
            if (!this.mTimeout.getStatus()) ** GOTO lbl47
            this.mConstructionInterrupted = true;
            break;
lbl-1000:
            // 1 sources

            {
                var4_4 = new TargetSet(this.mPartition.popFromWorkList());
                if (!MinimizeSevpa.$assertionsDisabled && var4_4.isEmpty()) {
                    throw new AssertionError();
                }
                var8_8 = new HashSet<LETTER>();
                if (var1_1) {
                    var5_5 = new HashSet<LETTER>();
                    var6_6 = new HashSet<LETTER>();
                    var7_7 = new HashSet<LETTER>();
                    var9_9 = var4_4.iterator();
                    while (var9_9.hasNext()) {
                        var10_10 = var9_9.next();
                        var5_5.addAll(this.mOperand.lettersInternalIncoming(var10_10));
                        var6_6.addAll(this.mOperand.lettersCallIncoming(var10_10));
                        var8_8.addAll(this.mOperand.lettersReturnIncoming(var10_10));
                        var7_7.addAll(this.mOperand.lettersReturn(var10_10));
                    }
                } else {
                    var5_5 = null;
                    var6_6 = null;
                    var7_7 = null;
                    var9_9 = var4_4.iterator();
                    while (var9_9.hasNext()) {
                        var10_10 = var9_9.next();
                        var8_8.addAll(this.mOperand.lettersReturnIncoming(var10_10));
                    }
                }
                if (var1_1) {
                    this.findXByInternalOrCall(var4_4, this.mPartition, var5_5, new InternalPredecessorSetFinder(this.mPartition, var4_4));
                    this.findXByInternalOrCall(var4_4, this.mPartition, var6_6, new CallPredecessorSetFinder(this.mPartition, var4_4));
                }
                this.findXByReturn(var4_4, this.mPartition, var8_8, var1_1);
                if (var1_1) {
                    this.findXByOutgoingReturn(var4_4, this.mPartition, var7_7, new ReturnSuccessorSetFinder(this.mPartition, var4_4));
                }
                var4_4.delete();
                if (!this.isCancellationRequested()) continue;
                throw new AutomataOperationCanceledException(this.getClass());
lbl47:
                // 2 sources

                ** while (!this.mPartition.workListIsEmpty())
            }
lbl48:
            // 1 sources

            if (var2_2) {
                var2_2 = false;
            } else {
                if (this.mPartition.getEquivalenceClasses().size() == var3_3) break;
                if (!MinimizeSevpa.$assertionsDisabled && this.mPartition.getEquivalenceClasses().size() <= var3_3) {
                    throw new AssertionError();
                }
            }
            var1_1 = var1_1 == false;
            var3_3 = this.mPartition.getEquivalenceClasses().size();
            this.putAllToWorkList(this.mPartition, var1_1);
        }
    }

    private void findXByInternalOrCall(TargetSet targetSet, Partition partition, Collection<LETTER> collection, APredecessorSetFinder aPredecessorSetFinder) {
        for (LETTER LETTER : collection) {
            PredecessorSet predecessorSet = aPredecessorSetFinder.find(LETTER);
            this.searchY(partition, targetSet, predecessorSet);
        }
    }

    private void findXByReturn(TargetSet targetSet, Partition partition, Collection<LETTER> collection, boolean bl) {
        if (bl) {
            this.findXByLinPred(targetSet, partition, collection);
            this.findXByHierPred(targetSet, partition, collection);
        } else {
            this.findXByDownStates(targetSet, partition, collection);
        }
    }

    private void findXByLinPred(TargetSet targetSet, Partition partition, Collection<LETTER> collection) {
        for (LETTER LETTER : collection) {
            IncomingReturnTransition incomingReturnTransition2;
            Object object;
            HashMap hashMap = new HashMap();
            Iterator iterator = targetSet.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                for (IncomingReturnTransition incomingReturnTransition2 : partition.hierPredIncoming(object, LETTER)) {
                    EquivalenceClass equivalenceClass = partition.getEquivalenceClass(incomingReturnTransition2.getHierPred());
                    HashSet hashSet = (HashSet)hashMap.get(equivalenceClass);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        hashMap.put(equivalenceClass, hashSet);
                    }
                    for (IncomingReturnTransition incomingReturnTransition3 : partition.linPredIncoming(object, incomingReturnTransition2.getHierPred(), LETTER)) {
                        hashSet.add(incomingReturnTransition3.getLinPred());
                    }
                }
            }
            incomingReturnTransition2 = hashMap.values().iterator();
            while (incomingReturnTransition2.hasNext()) {
                object = (HashSet)incomingReturnTransition2.next();
                PredecessorSet predecessorSet = new PredecessorSet(object);
                this.searchY(partition, targetSet, predecessorSet);
            }
        }
    }

    private void findXByHierPred(TargetSet targetSet, Partition partition, Collection<LETTER> collection) {
        for (LETTER LETTER : collection) {
            HashMap hashMap = new HashMap();
            Iterator iterator = targetSet.iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                for (IncomingReturnTransition incomingReturnTransition : partition.hierPredIncoming(object2, LETTER)) {
                    Object STATE = incomingReturnTransition.getHierPred();
                    Object STATE2 = incomingReturnTransition.getLinPred();
                    EquivalenceClass equivalenceClass = partition.getEquivalenceClass(STATE2);
                    HashSet hashSet = (HashSet)hashMap.get(equivalenceClass);
                    if (hashSet == null) {
                        hashSet = new HashSet();
                        hashMap.put(equivalenceClass, hashSet);
                    }
                    hashSet.add(STATE);
                }
            }
            for (Object object2 : hashMap.values()) {
                PredecessorSet predecessorSet = new PredecessorSet(object2);
                this.searchY(partition, targetSet, predecessorSet);
            }
        }
    }

    private void findXByDownStates(TargetSet targetSet, Partition partition, Collection<LETTER> collection) {
        for (LETTER LETTER : collection) {
            HashMap<EquivalenceClass, HashMap<EquivalenceClass, List<Set<ReturnTransition>>>> hashMap = new HashMap<EquivalenceClass, HashMap<EquivalenceClass, List<Set<ReturnTransition>>>>();
            Iterator iterator = targetSet.iterator();
            while (iterator.hasNext()) {
                Object STATE = iterator.next();
                HashSet hashSet = new HashSet();
                for (IncomingReturnTransition incomingReturnTransition : partition.hierPredIncoming(STATE, LETTER)) {
                    Object STATE2 = incomingReturnTransition.getHierPred();
                    if (!hashSet.add(STATE2)) continue;
                    EquivalenceClass equivalenceClass = partition.getEquivalenceClass(STATE2);
                    HashMap<EquivalenceClass, List<Set<ReturnTransition>>> hashMap2 = hashMap.get(equivalenceClass);
                    if (hashMap2 == null) {
                        hashMap2 = new HashMap();
                        hashMap.put(equivalenceClass, hashMap2);
                    }
                    for (IncomingReturnTransition incomingReturnTransition2 : partition.linPredIncoming(STATE, STATE2, LETTER)) {
                        ReturnTransition returnTransition;
                        Set<ReturnTransition> set;
                        Object STATE3 = incomingReturnTransition2.getLinPred();
                        EquivalenceClass equivalenceClass2 = partition.getEquivalenceClass(STATE3);
                        List<Set<ReturnTransition>> list = hashMap2.get(equivalenceClass2);
                        if (list == null) {
                            list = new LinkedList<Set<ReturnTransition>>();
                            hashMap2.put(equivalenceClass2, list);
                        }
                        if ((set = this.getSimilarSet(partition, returnTransition = new ReturnTransition(STATE3, STATE2, STATE), LETTER, list)) == null) {
                            set = new HashSet<ReturnTransition>();
                            list.add(set);
                        }
                        set.add(returnTransition);
                    }
                }
            }
            this.createAndSplitXByDownStates(targetSet, partition, hashMap);
        }
    }

    private Set<ReturnTransition> getSimilarSet(Partition partition, ReturnTransition returnTransition, LETTER LETTER, List<Set<ReturnTransition>> list) {
        for (Set<ReturnTransition> set : list) {
            boolean bl = true;
            for (ReturnTransition returnTransition2 : set) {
                if (returnTransition.isSimilar(partition, returnTransition2, LETTER)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return set;
        }
        return null;
    }

    private void createAndSplitXByDownStates(TargetSet targetSet, Partition partition, HashMap<EquivalenceClass, HashMap<EquivalenceClass, List<Set<ReturnTransition>>>> hashMap) {
        for (HashMap<EquivalenceClass, List<Set<ReturnTransition>>> hashMap2 : hashMap.values()) {
            for (List<Set<ReturnTransition>> list : hashMap2.values()) {
                for (Set<ReturnTransition> set : list) {
                    int n = MinimizeSevpa.computeHashCap(set.size());
                    HashSet hashSet = new HashSet(n);
                    HashSet hashSet2 = new HashSet(n);
                    for (ReturnTransition returnTransition : set) {
                        hashSet.add(returnTransition.getLin());
                        hashSet2.add(returnTransition.getHier());
                    }
                    PredecessorSet predecessorSet = new PredecessorSet(hashSet);
                    this.searchY(partition, targetSet, predecessorSet);
                    PredecessorSet object2 = new PredecessorSet(hashSet2);
                    this.searchY(partition, targetSet, object2);
                }
            }
        }
    }

    private void findXByOutgoingReturn(TargetSet targetSet, Partition partition, Collection<LETTER> collection, ReturnSuccessorSetFinder returnSuccessorSetFinder) {
        for (LETTER LETTER : collection) {
            PredecessorSet predecessorSet = returnSuccessorSetFinder.find(LETTER);
            this.searchY(partition, targetSet, predecessorSet);
        }
    }

    private void searchY(Partition partition, TargetSet targetSet, PredecessorSet predecessorSet) {
        assert (predecessorSet.size() > 0);
        LinkedList<EquivalenceClass> linkedList = new LinkedList<EquivalenceClass>();
        Iterator iterator = predecessorSet.iterator();
        while (iterator.hasNext()) {
            Object STATE = iterator.next();
            EquivalenceClass equivalenceClass = partition.getEquivalenceClass(STATE);
            assert (equivalenceClass != null);
            equivalenceClass.moveState(STATE, linkedList);
            assert (equivalenceClass.getIntersection(linkedList).contains(STATE));
            assert (!equivalenceClass.getCollection().contains(STATE));
        }
        predecessorSet.delete();
        this.split(partition, targetSet, linkedList);
    }

    private void split(Partition partition, TargetSet targetSet, LinkedList<EquivalenceClass> linkedList) {
        for (EquivalenceClass equivalenceClass : linkedList) {
            if (!equivalenceClass.isEmpty()) {
                ++this.mSplitsWithChange;
                EquivalenceClass equivalenceClass2 = equivalenceClass.split(partition);
                if (equivalenceClass.isInTargetSet()) {
                    targetSet.addEquivalenceClass(equivalenceClass2);
                }
                if (!equivalenceClass.isInWorkList()) {
                    assert (!equivalenceClass2.isInWorkList());
                    partition.addToWorkList(equivalenceClass);
                    partition.addToWorkList(equivalenceClass2);
                }
                partition.addReturnsToWorkList(equivalenceClass2);
            } else {
                ++this.mSplitsWithoutChange;
            }
            equivalenceClass.resetIntersection();
        }
    }

    private void putAllToWorkList(Partition partition, boolean bl) {
        if (bl) {
            for (EquivalenceClass equivalenceClass : partition.getEquivalenceClasses()) {
                if (!equivalenceClass.wasSplitDuringSecondPhase()) continue;
                partition.addToWorkList(equivalenceClass);
            }
        } else {
            for (EquivalenceClass equivalenceClass : partition.getEquivalenceClasses()) {
                if (!equivalenceClass.hasIncomingReturns(partition)) continue;
                partition.addToWorkList(equivalenceClass);
            }
        }
    }

    private void constructAutomaton(boolean bl) {
        this.mPartition.markInitials();
        boolean bl2 = this.mPartition.removeEmptyEquivalenceClasses();
        if (bl2) {
            throw new AssertionError((Object)"Please report this error to (schillic@informatik.uni-freiburg.de).");
        }
        this.constructResultFromPartition(this.mPartition, bl);
    }

    protected boolean getConstructionInterrupted() {
        return this.mConstructionInterrupted;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    abstract class APredecessorSetFinder {
        protected Partition mPartition;
        protected TargetSet mTargetSet;

        public APredecessorSetFinder(Partition partition, TargetSet targetSet) {
            this.mPartition = partition;
            this.mTargetSet = targetSet;
        }

        protected PredecessorSet find(LETTER LETTER) {
            PredecessorSet predecessorSet = new PredecessorSet();
            Iterator iterator = this.mTargetSet.iterator();
            while (iterator.hasNext()) {
                Object STATE = iterator.next();
                this.addPred(STATE, LETTER, predecessorSet);
            }
            return predecessorSet;
        }

        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            throw new AbstractMethodError();
        }
    }

    class CallPredecessorSetFinder
    extends APredecessorSetFinder {
        public CallPredecessorSetFinder(Partition partition, TargetSet targetSet) {
            super(partition, targetSet);
        }

        @Override
        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.mPartition.addPredCall(STATE, LETTER, predecessorSet);
        }
    }

    public class EquivalenceClass
    implements IBlock<STATE> {
        private Set<STATE> mCollection;
        private boolean mInW;
        private boolean mInA;
        private boolean mIsFinal;
        private boolean mIsInitial;
        private HashSet<STATE> mIntersection;
        private final int mId;
        private boolean mIncomingReturns;
        private boolean mWasSplit;

        public EquivalenceClass(Collection<STATE> collection, boolean bl) {
            this(collection, bl, true);
        }

        public EquivalenceClass(Collection<STATE> collection, boolean bl, boolean bl2) {
            this(bl, bl2, false);
            assert (!collection.isEmpty());
            if (collection instanceof Set) {
                this.mCollection = (Set)collection;
            } else {
                this.mCollection = new HashSet(MinimizeSevpa.computeHashCap(collection.size()));
                this.mCollection.addAll(collection);
            }
        }

        private EquivalenceClass(boolean bl, boolean bl2, boolean bl3) {
            this.mIsFinal = bl;
            this.mInW = bl2;
            this.mInA = bl3;
            this.mWasSplit = true;
            this.mIntersection = null;
            this.mId = MinimizeSevpa.this.mEquivalenceClassId++;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() == this.getClass()) {
                return this.mId == ((EquivalenceClass)object).mId;
            }
            return false;
        }

        public int hashCode() {
            return this.mId;
        }

        Collection<STATE> getCollection() {
            return this.mCollection;
        }

        boolean isInWorkList() {
            return this.mInW;
        }

        private void setInWorkList(boolean bl) {
            this.mInW = bl;
        }

        boolean isInTargetSet() {
            return this.mInA;
        }

        void setInTargetSet(boolean bl) {
            this.mInA = bl;
        }

        @Override
        public boolean isFinal() {
            return this.mIsFinal;
        }

        void setWasSplit() {
            this.mWasSplit = true;
        }

        Collection<STATE> getIntersection(Collection<EquivalenceClass> collection) {
            if (this.mIntersection == null) {
                this.mIntersection = new HashSet();
                collection.add(this);
            }
            return this.mIntersection;
        }

        void resetIntersection() {
            if (this.mCollection.isEmpty()) {
                this.mCollection = this.mIntersection;
            }
            this.mIntersection = null;
        }

        int size() {
            return this.mCollection.size();
        }

        boolean isEmpty() {
            return this.mCollection.isEmpty();
        }

        boolean add(STATE STATE) {
            return this.mCollection.add(STATE);
        }

        public void moveState(STATE STATE, Collection<EquivalenceClass> collection) {
            assert (this.mCollection.contains(STATE));
            this.mCollection.remove(STATE);
            this.getIntersection(collection).add(STATE);
        }

        void markAsInitial() {
            this.mIsInitial = true;
        }

        public EquivalenceClass split(Partition partition) {
            EquivalenceClass equivalenceClass = new EquivalenceClass(this.getIntersection(null), this.isFinal(), this.isInWorkList());
            partition.addEquivalenceClass(equivalenceClass);
            this.mWasSplit = true;
            for (Object STATE : equivalenceClass.getCollection()) {
                partition.setEquivalenceClass(STATE, equivalenceClass);
            }
            return equivalenceClass;
        }

        boolean hasIncomingReturns(Partition partition) {
            if (this.mWasSplit) {
                this.mWasSplit = false;
                this.mIncomingReturns = false;
                for (Object STATE : this.mCollection) {
                    if (!partition.hasIncomingReturns(STATE)) continue;
                    this.mIncomingReturns = true;
                    break;
                }
            }
            return this.mIncomingReturns;
        }

        boolean wasSplitDuringSecondPhase() {
            if (this.mWasSplit) {
                this.mWasSplit = false;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[");
            for (Object STATE : this.mCollection) {
                stringBuilder.append(STATE.toString());
                stringBuilder.append(", ");
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append("]");
            if (this.mIsFinal) {
                stringBuilder.append("f");
            }
            if (this.mInW) {
                stringBuilder.append("w");
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean isInitial() {
            return this.mIsInitial;
        }

        @Override
        public STATE minimize(IMergeStateFactory<STATE> iMergeStateFactory) {
            return iMergeStateFactory.merge(this.mCollection);
        }

        @Override
        public Iterator<STATE> iterator() {
            return this.mCollection.iterator();
        }

        @Override
        public boolean isRepresentativeIndependentInternalsCalls() {
            return !MinimizeSevpa.this.getConstructionInterrupted();
        }
    }

    class InternalPredecessorSetFinder
    extends APredecessorSetFinder {
        public InternalPredecessorSetFinder(Partition partition, TargetSet targetSet) {
            super(partition, targetSet);
        }

        @Override
        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.mPartition.addPredInternal(STATE, LETTER, predecessorSet);
        }
    }

    public class Partition
    implements IAutomatonStatePartition<STATE> {
        private final INestedWordAutomaton<LETTER, STATE> mParentOperand;
        private final LinkedList<EquivalenceClass> mEquivalenceClasses;
        private final WorkList mWorkList;
        private final HashMap<STATE, EquivalenceClass> mMapState2EquivalenceClass;

        Partition(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, int n) {
            this.mParentOperand = iNestedWordAutomaton;
            this.mEquivalenceClasses = new LinkedList();
            this.mWorkList = new WorkList(this.mParentOperand.size() / 2);
            this.mMapState2EquivalenceClass = new HashMap(MinimizeSevpa.computeHashCap(n));
        }

        public boolean removeEmptyEquivalenceClasses() {
            ListIterator listIterator = this.mEquivalenceClasses.listIterator();
            boolean bl = false;
            while (listIterator.hasNext()) {
                EquivalenceClass equivalenceClass = (EquivalenceClass)listIterator.next();
                if (!equivalenceClass.isEmpty()) continue;
                listIterator.remove();
                bl = true;
            }
            return bl;
        }

        public void markInitials() {
            for (Object e : this.mParentOperand.getInitialStates()) {
                EquivalenceClass equivalenceClass = this.mMapState2EquivalenceClass.get(e);
                if (equivalenceClass == null) continue;
                assert (!equivalenceClass.isEmpty());
                equivalenceClass.markAsInitial();
            }
        }

        LinkedList<EquivalenceClass> getEquivalenceClasses() {
            return this.mEquivalenceClasses;
        }

        @Override
        public IBlock<STATE> getBlock(STATE STATE) {
            return this.mMapState2EquivalenceClass.get(STATE);
        }

        public Set<STATE> getContainingSet(STATE STATE) {
            return this.mMapState2EquivalenceClass.get(STATE).mCollection;
        }

        public int size() {
            return this.mEquivalenceClasses.size();
        }

        void addEquivalenceClass(EquivalenceClass equivalenceClass) {
            this.mEquivalenceClasses.add(equivalenceClass);
            if (equivalenceClass.isInWorkList()) {
                this.mWorkList.add(equivalenceClass);
            }
            for (Object STATE : equivalenceClass.getCollection()) {
                this.mMapState2EquivalenceClass.put(STATE, equivalenceClass);
            }
        }

        EquivalenceClass getEquivalenceClass(STATE STATE) {
            return this.mMapState2EquivalenceClass.get(STATE);
        }

        protected void setEquivalenceClass(STATE STATE, EquivalenceClass equivalenceClass) {
            this.mMapState2EquivalenceClass.put(STATE, equivalenceClass);
        }

        boolean workListIsEmpty() {
            return this.mWorkList.isEmpty();
        }

        void addToWorkList(EquivalenceClass equivalenceClass) {
            this.mWorkList.add(equivalenceClass);
            equivalenceClass.setInWorkList(true);
        }

        void addReturnsToWorkList(EquivalenceClass equivalenceClass) {
            Collection collection = equivalenceClass.getCollection();
            for (Object STATE : collection) {
                EquivalenceClass equivalenceClass2;
                for (Object LETTER : this.mParentOperand.lettersReturn(STATE)) {
                    equivalenceClass2 = this.hierPred(STATE, LETTER);
                    for (Object STATE2 : equivalenceClass2) {
                        Iterable iterable = this.succReturn(STATE, STATE2, LETTER);
                        for (OutgoingReturnTransition outgoingReturnTransition : iterable) {
                            Object STATE3 = outgoingReturnTransition.getSucc();
                            EquivalenceClass equivalenceClass3 = this.getEquivalenceClass(STATE3);
                            if (equivalenceClass3.isInWorkList()) continue;
                            this.addToWorkList(equivalenceClass3);
                        }
                    }
                }
                for (SummaryReturnTransition summaryReturnTransition : this.mParentOperand.summarySuccessors(STATE)) {
                    equivalenceClass2 = this.getEquivalenceClass(summaryReturnTransition.getSucc());
                    if (equivalenceClass2.isInWorkList()) continue;
                    this.addToWorkList(equivalenceClass2);
                }
            }
        }

        EquivalenceClass popFromWorkList() {
            EquivalenceClass equivalenceClass = this.mWorkList.pop();
            equivalenceClass.setInWorkList(false);
            return equivalenceClass;
        }

        public boolean hasIncomingReturns(STATE STATE) {
            return !this.mParentOperand.lettersReturnIncoming(STATE).isEmpty();
        }

        private Collection<STATE> neighbors(Iterable<STATE> iterable) {
            LinkedList linkedList = new LinkedList();
            for (Object STATE : iterable) {
                if (this.mMapState2EquivalenceClass.get(STATE) == null) continue;
                linkedList.add(STATE);
            }
            return linkedList;
        }

        Iterable<OutgoingInternalTransition<LETTER, STATE>> succInternal(STATE STATE, LETTER LETTER) {
            return this.mParentOperand.internalSuccessors(STATE, LETTER);
        }

        Iterable<OutgoingCallTransition<LETTER, STATE>> succCall(STATE STATE, LETTER LETTER) {
            return this.mParentOperand.callSuccessors(STATE, LETTER);
        }

        Iterable<OutgoingReturnTransition<LETTER, STATE>> succReturn(STATE STATE, STATE STATE2, LETTER LETTER) {
            return this.mParentOperand.returnSuccessors(STATE, STATE2, LETTER);
        }

        Iterable<STATE> hierPred(STATE STATE, LETTER LETTER) {
            return this.mParentOperand.hierarchicalPredecessorsOutgoing(STATE, LETTER);
        }

        Iterable<IncomingReturnTransition<LETTER, STATE>> linPredIncoming(STATE STATE, STATE STATE2, LETTER LETTER) {
            return this.mParentOperand.returnPredecessors(STATE, STATE2, LETTER);
        }

        Iterable<IncomingReturnTransition<LETTER, STATE>> hierPredIncoming(STATE STATE, LETTER LETTER) {
            return this.mParentOperand.returnPredecessors(STATE, LETTER);
        }

        private void addNeighbors(Iterable<STATE> iterable, PredecessorSet predecessorSet) {
            for (Object STATE : iterable) {
                if (this.mMapState2EquivalenceClass.get(STATE) == null) continue;
                predecessorSet.add(STATE);
            }
        }

        private void addNeighborsEfficient(Iterable<STATE> iterable, PredecessorSet predecessorSet) {
            for (Object STATE : iterable) {
                predecessorSet.add(STATE);
            }
        }

        private void addNeighborsEfficientLin(Iterable<IncomingReturnTransition<LETTER, STATE>> iterable, PredecessorSet predecessorSet) {
            for (IncomingReturnTransition incomingReturnTransition : iterable) {
                predecessorSet.add(incomingReturnTransition.getLinPred());
            }
        }

        private void addNeighborsEfficientHier(Iterable<IncomingReturnTransition<LETTER, STATE>> iterable, PredecessorSet predecessorSet) {
            for (IncomingReturnTransition incomingReturnTransition : iterable) {
                predecessorSet.add(incomingReturnTransition.getHierPred());
            }
        }

        void addPredInternal(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.addNeighborsEfficient(new InternalTransitionIterator(this.mParentOperand.internalPredecessors(STATE, LETTER)), predecessorSet);
        }

        void addPredCall(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.addNeighborsEfficient(new CallTransitionIterator(this.mParentOperand.callPredecessors(STATE, LETTER)), predecessorSet);
        }

        void addPredReturnLin(STATE STATE, LETTER LETTER, STATE STATE2, PredecessorSet predecessorSet) {
            this.addNeighborsEfficientLin(this.mParentOperand.returnPredecessors(STATE, STATE2, LETTER), predecessorSet);
        }

        void addPredReturnHier(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.addNeighborsEfficientHier(this.mParentOperand.returnPredecessors(STATE, LETTER), predecessorSet);
        }

        void addSuccReturnHier(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            HashSet hashSet = new HashSet();
            for (Object STATE2 : this.mParentOperand.hierarchicalPredecessorsOutgoing(STATE, LETTER)) {
                hashSet.add(STATE2);
            }
            this.addNeighborsEfficient(hashSet, predecessorSet);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{ ");
            for (EquivalenceClass equivalenceClass : this.mEquivalenceClasses) {
                stringBuilder.append(equivalenceClass.toString());
                stringBuilder.append(",\n");
            }
            if (stringBuilder.length() > 2) {
                stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }

        @Override
        public Iterator<IBlock<STATE>> blocksIterator() {
            return new Iterator<IBlock<STATE>>(){
                protected Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public IBlock<STATE> next() {
                    return this.mIt.next();
                }
            };
        }

        public Iterator<Set<STATE>> iterator() {
            return new Iterator<Set<STATE>>(){
                private final Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public Set<STATE> next() {
                    return this.mIt.next().mCollection;
                }
            };
        }

        class CallTransitionIterator
        implements Iterable<STATE> {
            protected final Iterable<IncomingCallTransition<LETTER, STATE>> mIterable;

            public CallTransitionIterator(Iterable<IncomingCallTransition<LETTER, STATE>> iterable) {
                this.mIterable = iterable;
            }

            @Override
            public Iterator<STATE> iterator() {
                final Iterator iterator = this.mIterable.iterator();
                return new Iterator<STATE>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public STATE next() {
                        return ((IncomingCallTransition)iterator.next()).getPred();
                    }
                };
            }
        }

        class InternalTransitionIterator
        implements Iterable<STATE> {
            protected final Iterable<IncomingInternalTransition<LETTER, STATE>> mIterable;

            public InternalTransitionIterator(Iterable<IncomingInternalTransition<LETTER, STATE>> iterable) {
                this.mIterable = iterable;
            }

            @Override
            public Iterator<STATE> iterator() {
                final Iterator iterator = this.mIterable.iterator();
                return new Iterator<STATE>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public STATE next() {
                        return ((IncomingInternalTransition)iterator.next()).getPred();
                    }
                };
            }
        }
    }

    class PredecessorSet {
        protected HashSet<STATE> mCollection;

        public PredecessorSet() {
            this(new HashSet());
        }

        public PredecessorSet(HashSet<STATE> hashSet) {
            assert (hashSet != null);
            this.mCollection = hashSet;
        }

        Iterator<STATE> iterator() {
            return this.mCollection.iterator();
        }

        void add(STATE STATE) {
            this.mCollection.add(STATE);
        }

        void meld(PredecessorSet predecessorSet) {
            this.mCollection.addAll(predecessorSet.mCollection);
        }

        int size() {
            return this.mCollection.size();
        }

        boolean isEmpty() {
            return this.mCollection.isEmpty();
        }

        void delete() {
            this.mCollection = null;
        }

        public String toString() {
            return this.mCollection.toString();
        }
    }

    class ReturnPredecessorLinSetFinder
    extends APredecessorSetFinder {
        public ReturnPredecessorLinSetFinder(Partition partition, TargetSet targetSet) {
            super(partition, targetSet);
        }

        @Override
        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            for (IncomingReturnTransition incomingReturnTransition : this.mPartition.hierPredIncoming(STATE, LETTER)) {
                this.mPartition.addPredReturnLin(STATE, LETTER, incomingReturnTransition.getHierPred(), predecessorSet);
            }
        }
    }

    class ReturnPredecessorLinSetGivenHierFinder
    extends APredecessorSetFinder {
        protected STATE mHier;

        public ReturnPredecessorLinSetGivenHierFinder(Partition partition, TargetSet targetSet, STATE STATE) {
            super(partition, targetSet);
            this.mHier = STATE;
        }

        @Override
        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.mPartition.addPredReturnLin(STATE, LETTER, this.mHier, predecessorSet);
        }
    }

    class ReturnSuccessorSetFinder
    extends APredecessorSetFinder {
        public ReturnSuccessorSetFinder(Partition partition, TargetSet targetSet) {
            super(partition, targetSet);
        }

        @Override
        protected void addPred(STATE STATE, LETTER LETTER, PredecessorSet predecessorSet) {
            this.mPartition.addSuccReturnHier(STATE, LETTER, predecessorSet);
        }
    }

    protected class ReturnTransition {
        private final STATE mLin;
        private final STATE mHier;
        private final STATE mSucc;

        protected ReturnTransition(STATE STATE, STATE STATE2, STATE STATE3) {
            this.mLin = STATE;
            this.mHier = STATE2;
            this.mSucc = STATE3;
        }

        public STATE getLin() {
            return this.mLin;
        }

        public STATE getHier() {
            return this.mHier;
        }

        public STATE getSucc() {
            return this.mSucc;
        }

        private boolean isSimilar(Partition partition, ReturnTransition returnTransition, LETTER LETTER) {
            Object STATE = returnTransition.mLin;
            Object STATE2 = this.mHier;
            EquivalenceClass equivalenceClass = partition.getEquivalenceClass(returnTransition.mSucc);
            if (!this.isSimilarHelper(partition, LETTER, STATE, STATE2, equivalenceClass)) {
                return false;
            }
            STATE = this.mLin;
            STATE2 = returnTransition.mHier;
            equivalenceClass = partition.getEquivalenceClass(this.mSucc);
            return this.isSimilarHelper(partition, LETTER, STATE, STATE2, equivalenceClass);
        }

        private boolean isSimilarHelper(Partition partition, LETTER LETTER, STATE STATE, STATE STATE2, EquivalenceClass equivalenceClass) {
            return !MinimizeSevpa.this.mDoubleDecker.isDoubleDecker(STATE, STATE2) || this.checkExistenceOfSimilarTransition(partition, partition.succReturn(STATE, STATE2, LETTER), equivalenceClass);
        }

        private boolean checkExistenceOfSimilarTransition(Partition partition, Iterable<OutgoingReturnTransition<LETTER, STATE>> iterable, EquivalenceClass equivalenceClass) {
            for (OutgoingReturnTransition outgoingReturnTransition : iterable) {
                Object STATE = outgoingReturnTransition.getSucc();
                if (!partition.getEquivalenceClass(STATE).equals(equivalenceClass)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.mLin.toString());
            stringBuilder.append(", ");
            stringBuilder.append(this.mHier.toString());
            stringBuilder.append(", ");
            stringBuilder.append(this.mSucc.toString());
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    class StatesContainer {
        private final INestedWordAutomaton<LETTER, STATE> mParentOperand;
        private HashSet<STATE> mFinals;
        private HashSet<STATE> mNonfinals;
        private final StatesContainerMode mMode;

        StatesContainer(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
            this.mParentOperand = iNestedWordAutomaton;
            this.mMode = StatesContainerMode.NONE;
            switch (this.mMode) {
                case MAKE_COPY: {
                    this.mFinals = new HashSet(MinimizeSevpa.computeHashCap(this.mParentOperand.getFinalStates().size()));
                    this.mNonfinals = new HashSet(MinimizeSevpa.computeHashCap(this.mParentOperand.size() - this.mParentOperand.getFinalStates().size()));
                    break;
                }
                case SAVE_REMOVED: {
                    this.mFinals = new HashSet();
                    this.mNonfinals = new HashSet();
                    break;
                }
                case NONE: {
                    this.mFinals = null;
                    this.mNonfinals = null;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        public boolean hasFinals() {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return !this.mFinals.isEmpty();
                }
                case SAVE_REMOVED: {
                    return this.mParentOperand.getFinalStates().size() - this.mFinals.size() > 0;
                }
                case NONE: {
                    return !this.mParentOperand.getFinalStates().isEmpty();
                }
            }
            assert (false);
            return false;
        }

        HashSet<STATE> getNonfinals() {
            assert (this.mMode == StatesContainerMode.MAKE_COPY);
            return this.mNonfinals;
        }

        Iterator<STATE> getNonfinalsIterator() {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return this.mNonfinals.iterator();
                }
                case SAVE_REMOVED: {
                    return new Iterator<STATE>(){
                        private final Iterator<STATE> mIterator;
                        private STATE mNext;
                        {
                            this.mIterator = StatesContainer.this.mParentOperand.getStates().iterator();
                            this.mNext = this.computeNext();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mNext != null;
                        }

                        @Override
                        public STATE next() {
                            if (!$assertionsDisabled && this.mNext == null) {
                                throw new AssertionError();
                            }
                            Object STATE = this.mNext;
                            this.mNext = this.computeNext();
                            return STATE;
                        }

                        private STATE computeNext() {
                            while (this.mIterator.hasNext()) {
                                Object STATE = this.mIterator.next();
                                if (StatesContainer.this.mParentOperand.isFinal(STATE) || !StatesContainer.this.contains(STATE)) continue;
                                return STATE;
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                case NONE: {
                    assert (false);
                    return null;
                }
            }
            assert (false);
            return null;
        }

        HashSet<STATE> getFinals() {
            assert (this.mMode == StatesContainerMode.MAKE_COPY);
            return this.mFinals;
        }

        Iterator<STATE> getFinalsIterator() {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return this.mFinals.iterator();
                }
                case SAVE_REMOVED: {
                    return new Iterator<STATE>(){
                        private final Iterator<STATE> mIterator;
                        private STATE mNext;
                        {
                            this.mIterator = StatesContainer.this.mParentOperand.getFinalStates().iterator();
                            this.mNext = this.computeNext();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.mNext != null;
                        }

                        @Override
                        public STATE next() {
                            if (!$assertionsDisabled && this.mNext == null) {
                                throw new AssertionError();
                            }
                            Object STATE = this.mNext;
                            this.mNext = this.computeNext();
                            return STATE;
                        }

                        private STATE computeNext() {
                            while (this.mIterator.hasNext()) {
                                Object STATE = this.mIterator.next();
                                if (!StatesContainer.this.contains(STATE)) continue;
                                return STATE;
                            }
                            return null;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
                case NONE: {
                    return this.mParentOperand.getFinalStates().iterator();
                }
            }
            assert (false);
            return null;
        }

        int getRemovedSize(boolean bl) {
            assert (this.mMode == StatesContainerMode.SAVE_REMOVED);
            if (bl) {
                return this.mFinals.size();
            }
            return this.mNonfinals.size();
        }

        Collection<STATE> getTrivialAutomatonStates() {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return this.mNonfinals;
                }
                case SAVE_REMOVED: {
                    LinkedList linkedList = new LinkedList();
                    Iterator iterator = this.getNonfinalsIterator();
                    while (iterator.hasNext()) {
                        linkedList.add(iterator.next());
                    }
                    return linkedList;
                }
                case NONE: {
                    return this.mParentOperand.getStates();
                }
            }
            assert (false);
            return null;
        }

        int size() {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return this.mFinals.size() + this.mNonfinals.size();
                }
                case SAVE_REMOVED: {
                    return this.mParentOperand.size() - this.mFinals.size() - this.mNonfinals.size();
                }
                case NONE: {
                    return this.mParentOperand.size();
                }
            }
            assert (false);
            return 0;
        }

        boolean contains(STATE STATE) {
            switch (this.mMode) {
                case MAKE_COPY: {
                    return this.mNonfinals.contains(STATE) || this.mFinals.contains(STATE);
                }
                case SAVE_REMOVED: {
                    return !this.mNonfinals.contains(STATE) && !this.mFinals.contains(STATE);
                }
                case NONE: {
                    return this.mParentOperand.getStates().contains(STATE);
                }
            }
            assert (false);
            return false;
        }

        void addState(STATE STATE) {
            switch (this.mMode) {
                case MAKE_COPY: {
                    if (this.mParentOperand.isFinal(STATE)) {
                        this.mFinals.add(STATE);
                    } else {
                        this.mNonfinals.add(STATE);
                    }
                    return;
                }
            }
            assert (false);
        }

        public void addAll(Collection<STATE> collection) {
            switch (this.mMode) {
                case MAKE_COPY: {
                    for (Object STATE : collection) {
                        this.addState(STATE);
                    }
                    return;
                }
            }
            assert (false);
        }

        void removeState(STATE STATE) {
            switch (this.mMode) {
                case MAKE_COPY: {
                    if (!this.mNonfinals.remove(STATE)) {
                        this.mFinals.remove(STATE);
                    }
                    return;
                }
                case SAVE_REMOVED: {
                    if (this.mParentOperand.isFinal(STATE)) {
                        this.mFinals.add(STATE);
                    } else {
                        this.mNonfinals.add(STATE);
                    }
                    return;
                }
            }
            assert (false);
        }

        boolean wasCopied() {
            return this.mMode == StatesContainerMode.MAKE_COPY;
        }

        void delete() {
            switch (this.mMode) {
                case MAKE_COPY: 
                case SAVE_REMOVED: {
                    this.mFinals = null;
                    this.mNonfinals = null;
                    return;
                }
                case NONE: {
                    return;
                }
            }
            assert (false);
        }
    }

    private static enum StatesContainerMode {
        MAKE_COPY,
        SAVE_REMOVED,
        NONE;

    }

    class TargetSet {
        protected LinkedList<EquivalenceClass> mEquivalenceClasses;

        public TargetSet(EquivalenceClass equivalenceClass) {
            assert (equivalenceClass != null);
            this.mEquivalenceClasses = new LinkedList();
            this.mEquivalenceClasses.add(equivalenceClass);
            equivalenceClass.setInTargetSet(true);
        }

        Iterator<STATE> iterator() {
            return new Iterator<STATE>(){
                private final ListIterator<EquivalenceClass> mListIterator;
                private Iterator<STATE> mEquivalenceClassIterator;
                private STATE mNext;
                {
                    this.mListIterator = TargetSet.this.mEquivalenceClasses.listIterator();
                    this.mNext = this.initialize();
                }

                @Override
                public boolean hasNext() {
                    return this.mNext != null;
                }

                @Override
                public STATE next() {
                    if (!$assertionsDisabled && this.mNext == null) {
                        throw new AssertionError();
                    }
                    Object STATE = this.mNext;
                    this.computeNext();
                    return STATE;
                }

                private STATE initialize() {
                    this.mEquivalenceClassIterator = this.mListIterator.next().getCollection().iterator();
                    this.computeNext();
                    return this.mNext;
                }

                /*
                 * Unable to fully structure code
                 */
                private void computeNext() {
                    block1: {
                        if (!this.mEquivalenceClassIterator.hasNext()) ** GOTO lbl8
                        this.mNext = this.mEquivalenceClassIterator.next();
                        break block1;
lbl-1000:
                        // 1 sources

                        {
                            this.mEquivalenceClassIterator = this.mListIterator.next().getCollection().iterator();
                            if (!this.mEquivalenceClassIterator.hasNext()) continue;
                            this.mNext = this.mEquivalenceClassIterator.next();
                            return;
lbl8:
                            // 2 sources

                            ** while (this.mListIterator.hasNext())
                        }
lbl9:
                        // 1 sources

                        this.mNext = null;
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        void addEquivalenceClass(EquivalenceClass equivalenceClass) {
            this.mEquivalenceClasses.add(equivalenceClass);
            equivalenceClass.setInTargetSet(true);
        }

        void delete() {
            for (EquivalenceClass equivalenceClass : this.mEquivalenceClasses) {
                equivalenceClass.setInTargetSet(false);
            }
            this.mEquivalenceClasses = null;
        }

        boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (EquivalenceClass equivalenceClass : this.mEquivalenceClasses) {
                stringBuilder.append(equivalenceClass.toString());
                stringBuilder.append("\n");
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }

    class WorkList {
        protected PriorityQueue<EquivalenceClass> mQueue;

        public WorkList(int n) {
            if (n == 0) {
                n = 1;
            }
            this.mQueue = new PriorityQueue(n, (equivalenceClass, equivalenceClass2) -> equivalenceClass.size() - equivalenceClass2.size());
        }

        public void add(EquivalenceClass equivalenceClass) {
            assert (!this.mQueue.contains(equivalenceClass));
            this.mQueue.add(equivalenceClass);
        }

        public EquivalenceClass pop() {
            return this.mQueue.poll();
        }

        public boolean isEmpty() {
            return this.mQueue.isEmpty();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append(this.mQueue.toString());
            stringBuilder.append("}");
            return stringBuilder.toString();
        }
    }
}

