/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.ComplementNwaOutgoingLetterAndTransitionAdapter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.LassoConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GeneralizedNestedWordAutomatonReachableStatesAntichain<LETTER, STATE>
extends AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> {
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final ComplementNwaOutgoingLetterAndTransitionAdapter<LETTER, STATE> mSndOperand;
    private final Map<STATE, ProductStateContainer> mStates = new HashMap<STATE, ProductStateContainer>();
    private final Map<STATE, Map<STATE, ProductStateContainer>> mFst2snd2res = new HashMap<STATE, Map<STATE, ProductStateContainer>>();
    private final ReachableStatesComputation mReach;
    private final IBuchiIntersectStateFactory<STATE> mStateFactory;
    private final STATE mEmptyStackState;
    private final int mAcceptanceSize;
    private static int mNumber = 0;
    private NestedLassoRun<LETTER, STATE> mLasso = null;

    public <FACTORY extends IBuchiIntersectStateFactory<STATE> & IEmptyStackStateFactory<STATE>> GeneralizedNestedWordAutomatonReachableStatesAntichain(AutomataLibraryServices automataLibraryServices, IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iGeneralizedNwaOutgoingLetterAndTransitionProvider, ComplementNwaOutgoingLetterAndTransitionAdapter<LETTER, STATE> complementNwaOutgoingLetterAndTransitionAdapter, FACTORY FACTORY) throws AutomataLibraryException {
        super(automataLibraryServices, iGeneralizedNwaOutgoingLetterAndTransitionProvider.getVpAlphabet());
        this.mFstOperand = iGeneralizedNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = complementNwaOutgoingLetterAndTransitionAdapter;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "Unable to apply operation to automata with different alphabets.");
        }
        this.mStateFactory = FACTORY;
        this.mEmptyStackState = this.mStateFactory.createEmptyStackState();
        this.mDownStates.add(this.mEmptyStackState);
        this.mAcceptanceSize = iGeneralizedNwaOutgoingLetterAndTransitionProvider.getAcceptanceSize() + 1;
        try {
            this.mReach = new ReachableStatesComputation();
            this.mFinalStates.clear();
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            throw toolchainCanceledException;
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.stateContainerInformation());
        }
    }

    @Override
    protected StateContainer<LETTER, STATE> getStateContainer(STATE STATE) {
        return this.mStates.get(STATE);
    }

    private String stateContainerInformation() {
        return this.mStates.size() + " StateContainers ";
    }

    @Override
    public Boolean isEmpty() {
        return this.mReach.mIsEmpty;
    }

    @Override
    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() throws AutomataOperationCanceledException {
        if (this.mReach.mIsEmpty.booleanValue()) {
            return null;
        }
        if (this.mLasso == null) {
            for (List list : this.mReach.mSccList) {
                LassoConstructor lassoConstructor = new LassoConstructor(this.mServices, this, list);
                NestedLassoRun nestedLassoRun = lassoConstructor.getNestedLassoRun();
                if (this.mLasso != null && this.mLasso.getStem().getLength() + this.mLasso.getLoop().getLength() <= nestedLassoRun.getStem().getLength() + nestedLassoRun.getLoop().getLength()) continue;
                this.mLasso = nestedLassoRun;
            }
        }
        return this.mLasso;
    }

    private void print(String string, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        try {
            HashSet<Object> hashSet22;
            PrintWriter printWriter = new PrintWriter(new FileWriter("./" + string));
            ArrayList<HashSet<Object>> arrayList = new ArrayList<HashSet<Object>>();
            for (HashSet<Object> hashSet22 : iNwaOutgoingLetterAndTransitionProvider.getInitialStates()) {
                printWriter.println("Initial States: " + String.valueOf(this.mSndOperand.getNCSB(hashSet22)) + " final: " + this.mSndOperand.isFinal(hashSet22));
                arrayList.add(hashSet22);
            }
            hashSet22 = new HashSet();
            HashMap hashMap = new HashMap();
            int n = 0;
            for (Object object : iNwaOutgoingLetterAndTransitionProvider.getAlphabet()) {
                hashMap.put(object, n);
                ++n;
            }
            while (!arrayList.isEmpty()) {
                Object object;
                object = arrayList.remove(arrayList.size() - 1);
                if (hashSet22.contains(object)) continue;
                hashSet22.add(object);
                printWriter.println("State " + String.valueOf(this.mSndOperand.getNCSB(object)) + " final: " + this.mSndOperand.isFinal(object));
                HashSet hashSet3 = new HashSet();
                for (OutgoingInternalTransition outgoingInternalTransition : iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(object)) {
                    hashSet3.add(outgoingInternalTransition.getSucc());
                    if (hashSet22.contains(outgoingInternalTransition.getSucc())) continue;
                    arrayList.add((HashSet<Object>)outgoingInternalTransition.getSucc());
                }
                Iterator<OutgoingInternalTransition<LETTER, Object>> iterator = hashSet3.iterator();
                while (iterator.hasNext()) {
                    Object object2 = iterator.next();
                    printWriter.println("-> " + String.valueOf(this.mSndOperand.getNCSB(object2)));
                }
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean reachable(STATE STATE, STATE STATE2, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        HashSet hashSet = new HashSet();
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        arrayList.add(STATE);
        while (!arrayList.isEmpty()) {
            Object e = arrayList.remove(arrayList.size() - 1);
            if (STATE2.equals(e)) {
                return true;
            }
            if (hashSet.contains(e)) continue;
            hashSet.add(e);
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iNwaOutgoingLetterAndTransitionProvider.internalSuccessors(e)) {
                if (hashSet.contains(outgoingInternalTransition.getSucc())) continue;
                arrayList.add(outgoingInternalTransition.getSucc());
            }
        }
        return false;
    }

    private GeneralizedNestedWordAutomatonReachableStatesAntichain<LETTER, STATE> getReach() {
        return this;
    }

    @Override
    protected void removeStates(STATE STATE) {
        this.mStates.remove(STATE);
        this.mInitialStates.remove(STATE);
        this.mFinalStates.remove(STATE);
    }

    private AutomataLibraryServices getServices() {
        return this.mServices;
    }

    private RunningTaskInfo constructRunningTaskInfo() {
        String string = GeneralizedNestedWordAutomatonReachableStatesAntichain.constructRunningTaskInfoMessage(this.mNumberOfConstructedStates, this.getClass());
        RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), string);
        return runningTaskInfo;
    }

    @Override
    public Set<STATE> getStates() {
        return this.mStates.keySet();
    }

    @Override
    public Set<STATE> getInitialStates() {
        return Collections.unmodifiableSet(this.mInitialStates);
    }

    @Override
    public Collection<STATE> getFinalStates() {
        return Collections.unmodifiableSet(this.mFinalStates);
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersInternalIncoming();
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return this.mStates.get(STATE).internalPredecessors();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalSuccessors(LETTER);
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return this.size() + " states";
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mEmptyStackState;
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mInitialStates.contains(STATE);
    }

    @Override
    public int getAcceptanceSize() {
        return this.mAcceptanceSize;
    }

    @Override
    public boolean isFinal(STATE STATE, int n) {
        return this.mStates.get(STATE).mProdState.mAcceptanceSet.contains(n);
    }

    @Override
    public Set<Integer> getAcceptanceLabels(STATE STATE) {
        return this.mStates.get(STATE).mProdState.mAcceptanceSet;
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return !this.getAcceptanceLabels(STATE).isEmpty();
    }

    private class Antichain {
        private final Map<STATE, List<ProductState>> mResStateMap = new HashMap();

        void clear() {
            this.mResStateMap.clear();
        }

        Set<STATE> getStates() {
            return this.mResStateMap.keySet();
        }

        public boolean addState(ProductState productState) {
            Object STATE = productState.getFst();
            List<ProductState> list = this.mResStateMap.get(STATE);
            if (list == null) {
                list = new ArrayList<ProductState>();
            }
            ArrayList<ProductState> arrayList = new ArrayList<ProductState>();
            int n = 0;
            while (n < list.size()) {
                ProductState productState2 = list.get(n);
                if (!productState2.coveredBy(productState)) {
                    if (productState.coveredBy(productState2)) {
                        return false;
                    }
                    arrayList.add(productState2);
                }
                ++n;
            }
            arrayList.add(productState);
            this.mResStateMap.put(STATE, arrayList);
            return true;
        }

        public boolean covers(ProductState productState) {
            List<ProductState> list = this.mResStateMap.get(productState.getFst());
            if (list == null) {
                return false;
            }
            for (ProductState productState2 : list) {
                if (!productState.coveredBy(productState2)) continue;
                return true;
            }
            return false;
        }

        public ProductState coveringProductState(ProductState productState) {
            List<ProductState> list = this.mResStateMap.get(productState.getFst());
            if (list == null) {
                return null;
            }
            for (ProductState productState2 : list) {
                if (!productState.coveredBy(productState2)) continue;
                return productState2;
            }
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry entry : this.mResStateMap.entrySet()) {
                stringBuilder.append(String.valueOf(entry.getKey()) + " -> " + String.valueOf(entry.getValue()) + "\n");
            }
            return stringBuilder.toString();
        }
    }

    private static class AsccPair<LETTER, STATE> {
        final STATE mState;
        final Set<Integer> mLabels;

        AsccPair(STATE STATE, Set<Integer> set) {
            this.mState = STATE;
            this.mLabels = set;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AsccPair asccPair = (AsccPair)object;
            return this.mState.equals(asccPair.mState) && this.mLabels.equals(asccPair.mLabels);
        }

        public int hashCode() {
            return this.mState.hashCode() + this.mLabels.hashCode();
        }
    }

    private class ProductState {
        private final STATE mFst;
        private final STATE mSnd;
        private final STATE mRes;
        private Set<Integer> mAcceptanceSet;

        ProductState(STATE STATE, STATE STATE2, STATE STATE3) {
            this.mFst = STATE;
            this.mSnd = STATE2;
            this.mRes = STATE3;
        }

        public STATE getFst() {
            return this.mFst;
        }

        public STATE getSnd() {
            return this.mSnd;
        }

        public STATE getRes() {
            return this.mRes;
        }

        public void setAcceptanceSet(Set<Integer> set) {
            this.mAcceptanceSet = set;
        }

        public boolean coveredBy(ProductState productState) {
            return this.mFst.equals(productState.mFst) && GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mSndOperand.coveredBy(this.mSnd, productState.mSnd);
        }

        public Set<Integer> getAcceptanceSet() {
            return this.mAcceptanceSet;
        }

        public String toString() {
            return "<" + this.mFst.toString() + "," + this.mSnd.toString() + "," + this.mAcceptanceSet.toString() + ">";
        }
    }

    private class ProductStateContainer
    extends StateContainer<LETTER, STATE> {
        ProductState mProdState;

        public ProductStateContainer(STATE STATE, ProductState productState) {
            super(STATE);
            this.mProdState = productState;
        }

        ProductState getProd() {
            return this.mProdState;
        }
    }

    class ReachableStatesComputation {
        private int mCnt;
        private final Stack<AsccPair<LETTER, STATE>> mSCCs;
        private final Map<STATE, Integer> mDfsNum;
        private final Stack<STATE> mAct;
        private final Set<STATE> mQPrime;
        private final List<LinkedList<STATE>> mSccList;
        private Boolean mIsEmpty = null;
        private final Antichain mEmp;

        public ReachableStatesComputation() throws AutomataOperationCanceledException {
            Object object2;
            GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mNumberOfConstructedStates = 0;
            this.computeInitialStates();
            this.mCnt = 0;
            this.mDfsNum = new HashMap();
            this.mAct = new Stack();
            this.mSccList = new ArrayList();
            this.mSCCs = new Stack();
            this.mQPrime = new HashSet();
            this.mEmp = new Antichain();
            boolean bl = false;
            for (Object object2 : GeneralizedNestedWordAutomatonReachableStatesAntichain.this.getInitialStates()) {
                if (this.mDfsNum.containsKey(object2)) continue;
                boolean bl2 = this.construct(object2);
                boolean bl3 = bl = bl2 || bl;
            }
            this.mIsEmpty = !bl;
            object2 = new HashSet(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.keySet());
            for (Iterator iterator : object2) {
                if (this.mQPrime.contains(iterator)) {
                    assert (!this.mEmp.covers(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState)) : "Wrong Coverage: " + String.valueOf(generalizedNestedWordAutomatonReachableStatesAntichain.mStates.get(iterator).mProdState.mFst) + ", " + String.valueOf(generalizedNestedWordAutomatonReachableStatesAntichain.mSndOperand.getNCSB(generalizedNestedWordAutomatonReachableStatesAntichain.mStates.get(iterator).mProdState.mSnd)) + "\n" + String.valueOf(this.mEmp.coveringProductState((ProductState)generalizedNestedWordAutomatonReachableStatesAntichain.mStates.get(iterator).mProdState).mFst) + ", " + String.valueOf(generalizedNestedWordAutomatonReachableStatesAntichain.mSndOperand.getNCSB(this.mEmp.coveringProductState((ProductState)generalizedNestedWordAutomatonReachableStatesAntichain.mStates.get(iterator).mProdState).mSnd));
                    continue;
                }
                if (this.mEmp.covers(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState)) {
                    StateContainer stateContainer = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator);
                    HashSet hashSet = new HashSet();
                    for (IncomingInternalTransition incomingInternalTransition : stateContainer.internalPredecessors()) {
                        Object object3;
                        if (!GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mServices.getProgressAwareTimer().continueProcessing()) {
                            object3 = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.constructRunningTaskInfo();
                            throw new AutomataOperationCanceledException((RunningTaskInfo)object3);
                        }
                        object3 = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(incomingInternalTransition.getPred());
                        if (object3 != null) {
                            ((StateContainer)object3).removeSuccessor(iterator);
                        }
                        hashSet.add(incomingInternalTransition.getPred());
                    }
                    stateContainer.removePredecessors(hashSet);
                } else assert (false) : "You should never be here: " + String.valueOf(generalizedNestedWordAutomatonReachableStatesAntichain.mStates.get(iterator).mProdState);
                GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.remove(iterator);
                GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mInitialStates.remove(iterator);
                GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFinalStates.remove(iterator);
            }
            this.asccClear();
        }

        private void asccClear() {
            this.mDfsNum.clear();
            this.mQPrime.clear();
            this.mEmp.clear();
        }

        private void computeInitialStates() {
            for (Object STATE : GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFstOperand.getInitialStates()) {
                for (Object STATE2 : GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mSndOperand.getInitialStates()) {
                    Object STATE3 = this.getOrConstructState(STATE, STATE2);
                    GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mInitialStates.add(STATE3);
                }
            }
        }

        private STATE getOrConstructState(STATE STATE, STATE STATE2) {
            ProductStateContainer productStateContainer;
            Map map = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFst2snd2res.get(STATE);
            if (map == null) {
                map = new HashMap();
                GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFst2snd2res.put(STATE, map);
            }
            if ((productStateContainer = map.get(STATE2)) == null) {
                Object STATE3 = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStateFactory.intersectBuchi(STATE, STATE2, 1);
                ProductState productState = new ProductState(STATE, STATE2, STATE3);
                productState.setAcceptanceSet(this.computeAcceptance(STATE, STATE2));
                productStateContainer = new ProductStateContainer(STATE3, productState);
                map.put(STATE2, productStateContainer);
                GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.put(STATE3, productStateContainer);
                if (!productState.mAcceptanceSet.isEmpty()) {
                    GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFinalStates.add(STATE3);
                }
                ++GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mNumberOfConstructedStates;
            }
            return productStateContainer.getState();
        }

        private Set<Integer> computeAcceptance(STATE STATE, STATE STATE2) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Set<Integer> set = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFstOperand.getAcceptanceLabels(STATE);
            hashSet.addAll(set);
            int n = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFstOperand.getAcceptanceSize();
            if (GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mSndOperand.isFinal(STATE2)) {
                hashSet.add(n);
            }
            if (hashSet.isEmpty()) {
                return Collections.emptySet();
            }
            return hashSet;
        }

        boolean construct(STATE STATE) throws AutomataOperationCanceledException {
            ProductStateContainer productStateContainer = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(STATE);
            boolean bl = false;
            ++this.mCnt;
            this.mDfsNum.put(STATE, this.mCnt);
            this.mAct.push(STATE);
            this.mSCCs.push(new AsccPair(STATE, productStateContainer.mProdState.getAcceptanceSet()));
            for (OutgoingInternalTransition object : GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mFstOperand.internalSuccessors(productStateContainer.mProdState.getFst())) {
                for (OutgoingInternalTransition outgoingInternalTransition : GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mSndOperand.internalSuccessors(productStateContainer.mProdState.getSnd(), object.getLetter())) {
                    Object STATE2;
                    Object object2;
                    if (!GeneralizedNestedWordAutomatonReachableStatesAntichain.this.getServices().getProgressAwareTimer().continueProcessing()) {
                        object2 = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)object2);
                    }
                    object2 = this.getOrConstructState(object.getSucc(), outgoingInternalTransition.getSucc());
                    ProductState productState = GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(object2).getProd();
                    productStateContainer.addInternalOutgoing(new OutgoingInternalTransition(object.getLetter(), (RunningTaskInfo)object2));
                    GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(object2).addInternalIncoming(new IncomingInternalTransition(STATE, object.getLetter()));
                    if (this.mQPrime.contains(object2)) {
                        bl = true;
                        continue;
                    }
                    if (this.mEmp.covers(productState)) continue;
                    if (!this.mAct.contains(object2)) {
                        boolean bl2 = this.construct(object2);
                        bl = bl2 || bl;
                        continue;
                    }
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    do {
                        AsccPair asccPair = this.mSCCs.pop();
                        STATE2 = asccPair.mState;
                        hashSet.addAll(asccPair.mLabels);
                        if (hashSet.size() != GeneralizedNestedWordAutomatonReachableStatesAntichain.this.getAcceptanceSize()) continue;
                        bl = true;
                    } while (this.mDfsNum.get(STATE2) > this.mDfsNum.get(object2));
                    this.mSCCs.push(new AsccPair(STATE2, hashSet));
                }
            }
            if (this.mSCCs.peek().mState.equals(STATE)) {
                Iterator iterator;
                AsccPair asccPair = this.mSCCs.pop();
                LinkedList linkedList = new LinkedList();
                do {
                    assert (!this.mAct.isEmpty()) : "Active stack is empty";
                    iterator = this.mAct.pop();
                    linkedList.add(iterator);
                    if (bl) {
                        assert (!this.mEmp.covers(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState)) : "Add wrong states" + this.mEmp.toString() + "\n " + String.valueOf(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState.mFst) + ", " + String.valueOf(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mSndOperand.getNCSB(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState.mSnd));
                        this.mQPrime.add(iterator);
                        continue;
                    }
                    this.mEmp.addState(GeneralizedNestedWordAutomatonReachableStatesAntichain.this.mStates.get(iterator).mProdState);
                } while (!iterator.equals(STATE));
                if (asccPair.mLabels.size() == GeneralizedNestedWordAutomatonReachableStatesAntichain.this.getAcceptanceSize() && (linkedList.size() > 1 || productStateContainer.hashSelfloop())) {
                    this.mSccList.add(linkedList);
                }
            }
            return bl;
        }
    }
}

