/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RelationDecision;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormulaXML2JConverter {
    private static final String DEFAULT_LOGGER = "FormulaXML2JConverter";
    private ILogger logger = null;
    protected boolean useZDecision = false;

    public FormulaXML2JConverter(String string, boolean bl) {
        this.logger = string.equals("") ? ILogger.getLogger((String)DEFAULT_LOGGER) : ILogger.getLogger((String)string);
        this.useZDecision = bl;
    }

    public FormulaXML2JConverter(boolean bl) {
        this("", bl);
    }

    public CDD convert(Element element) {
        Element[] elementArray = this.getFormulaOperands(element);
        if (elementArray.length != 1) {
            throw new RuntimeException("Formulae with child count != 1 are not allowed");
        }
        this.logger.info((Object)"Trying to build CDD");
        CDD cDD = this.createFormulaCDD(elementArray[0]);
        this.logger.info((Object)"Building CDD successful");
        return cDD;
    }

    private CDD createFormulaCDD(Element element) {
        String string = element.getNodeName();
        if (string.equals("booleanExpression")) {
            return this.createBooleanDecision(element);
        }
        if (string.equals("rangeExpression")) {
            return this.createRangeDecision(element);
        }
        if (string.equals("eventExpression")) {
            return this.createEventDecision(element);
        }
        if (string.equals("formulaTree")) {
            Element[] elementArray = this.getFormulaOperands(element);
            String string2 = element.getAttribute("operator");
            if (string2.equals("NOT")) {
                if (elementArray.length != 1) {
                    throw new RuntimeException("Child count != 1 is not allowed for formula trees with \"NOT\"-operator ");
                }
                CDD cDD = this.createFormulaCDD(elementArray[0]).negate();
                return cDD;
            }
            if (string2.equals("OR")) {
                if (elementArray.length < 2) {
                    throw new RuntimeException("\"OR\" formulae with < 2 operands are not allowed");
                }
                CDD cDD = CDD.FALSE;
                int n = 0;
                while (n < elementArray.length) {
                    cDD = cDD.or(this.createFormulaCDD(elementArray[n]));
                    ++n;
                }
                return cDD;
            }
            if (string2.equals("AND")) {
                if (elementArray.length < 2) {
                    throw new RuntimeException("\"AND\" formulae with < 2 operands are not allowed");
                }
                CDD cDD = CDD.TRUE;
                int n = 0;
                while (n < elementArray.length) {
                    cDD = cDD.and(this.createFormulaCDD(elementArray[n]));
                    ++n;
                }
                return cDD;
            }
            throw new RuntimeException("Formula tree operator has to be \"NOT\", \"AND\", or \"OR\"");
        }
        throw new RuntimeException("Formula has to be \"booleanExpression\", \"eventExpression\", or \"rangeExpression\"");
    }

    private Element[] getFormulaOperands(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getNodeName();
            if (string.equals("rangeExpression") || string.equals("booleanExpression") || string.equals("eventExpression") || string.equals("formulaTree")) {
                arrayList.add((Element)node);
            }
            ++n2;
        }
        n2 = arrayList.size();
        if (n2 == 0) {
            throw new RuntimeException("A formula with 0 operands is not allowed.");
        }
        return arrayList.toArray(new Element[n2]);
    }

    private int getOperator(String string) {
        if (string.equals("greaterequal")) {
            return 1;
        }
        if (string.equals("greater")) {
            return 2;
        }
        if (string.equals("less")) {
            return -2;
        }
        if (string.equals("lessequal")) {
            return -1;
        }
        if (string.equals("equal")) {
            return 0;
        }
        if (string.equals("notequal")) {
            return 4;
        }
        throw new RuntimeException("Operator needs to be \"greaterequal\", \"greater\", \"equal\", \"notequal\", \"less\", or \"lessequal\"");
    }

    private CDD createBooleanDecision(Element element) {
        String string = element.getAttribute("expression");
        if (string.equals("")) {
            throw new RuntimeException("Empty expressions are not allowed");
        }
        if (string.equals("true")) {
            return CDD.TRUE;
        }
        if (string.equals("false")) {
            return CDD.FALSE;
        }
        try {
            if (string.contains("=>")) {
                return RelationDecision.create(string.split("=>"), RelationDecision.Operator.GEQ);
            }
            if (string.contains(RelationDecision.Operator.GEQ.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.GEQ.toString()), RelationDecision.Operator.GEQ);
            }
            if (string.contains("<=")) {
                return RelationDecision.create(string.split("<="), RelationDecision.Operator.LEQ);
            }
            if (string.contains(RelationDecision.Operator.LEQ.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.LEQ.toString()), RelationDecision.Operator.LEQ);
            }
            if (string.contains(RelationDecision.Operator.LESS.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.LESS.toString()), RelationDecision.Operator.LESS);
            }
            if (string.contains(RelationDecision.Operator.GREATER.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.GREATER.toString()), RelationDecision.Operator.GREATER);
            }
            if (string.contains(RelationDecision.Operator.NEQ.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.NEQ.toString()), RelationDecision.Operator.NEQ);
            }
            if (string.contains(RelationDecision.Operator.EQUALS.toString())) {
                return RelationDecision.create(string.split(RelationDecision.Operator.EQUALS.toString()), RelationDecision.Operator.EQUALS);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Found wrong number of operands in " + string);
        }
        return BooleanDecision.create(string);
    }

    private CDD createRangeDecision(Element element) {
        String string = element.getAttribute("variable");
        if (string.equals("")) {
            throw new RuntimeException("Range expressions with empty variables are not allowed");
        }
        String string2 = element.getAttribute("operator");
        int n = this.getOperator(string2);
        String string3 = element.getAttribute("bound");
        double d = Double.parseDouble(string3);
        return RangeDecision.create(string, n, (int)d);
    }

    private CDD createEventDecision(Element element) {
        String string = element.getAttribute("name");
        if (string.equals("")) {
            throw new RuntimeException("Empty name attributes are not allowed");
        }
        return EventDecision.create(string);
    }
}

