/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FormatVersion;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.MetadataProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriterV0;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriterV2;
import java.util.List;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public abstract class YamlWitnessWriter {
    public static YamlWitnessWriter construct(FormatVersion formatVersion, MetadataProvider metadataProvider) {
        if (formatVersion.getMajor() == 0) {
            return new YamlWitnessWriterV0(metadataProvider);
        }
        if (formatVersion.getMajor() == 2) {
            return new YamlWitnessWriterV2(metadataProvider, formatVersion.getMinor() >= 1, formatVersion.getMinor() >= 1);
        }
        throw new UnsupportedOperationException("Unknown format version " + String.valueOf(formatVersion));
    }

    protected static String formatYaml(List<Map<String, Object>> list) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setIndent(2);
        return new Yaml(dumperOptions).dump(list);
    }

    public abstract String toString(Witness var1);
}

