/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetSuccessorProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNetTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetRun;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.PetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.ConditionMarking;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolderBase;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;

public final class PetriNetUnfolder<L, P>
extends PetriNetUnfolderBase<L, P, PetriNetRun<L, P>> {
    public PetriNetUnfolder(AutomataLibraryServices automataLibraryServices, IPetriNetSuccessorProvider<L, P> iPetriNetSuccessorProvider, EventOrderEnum eventOrderEnum, boolean bl, boolean bl2) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices, iPetriNetSuccessorProvider, eventOrderEnum, bl, bl2);
    }

    @Override
    protected boolean checkInitialPlaces() {
        return this.mUnfolding.getDummyRoot().getSuccessorConditions().stream().anyMatch(condition -> this.mOperand.isAccepting(condition.getPlace()));
    }

    @Override
    protected PetriNetRun<L, P> constructInitialRun() throws PetriNetNot1SafeException {
        return new PetriNetRun(new ConditionMarking(this.mUnfolding.getDummyRoot().getSuccessorConditions()).getMarking());
    }

    @Override
    protected boolean addAndCheck(Event<L, P> event) throws PetriNetNot1SafeException {
        return this.mUnfolding.addEvent(event);
    }

    @Override
    protected PetriNetRun<L, P> constructRun(Event<L, P> event) {
        this.mLogger.debug((Object)("Marking: " + String.valueOf(this.mUnfolding.getDummyRoot().getMark())));
        try {
            return this.constructRun(event, this.mUnfolding.getDummyRoot().getConditionMark()).mRunInner;
        }
        catch (PetriNetNot1SafeException petriNetNot1SafeException) {
            throw new AssertionError((Object)("Petri net not one safe for places " + String.valueOf(petriNetNot1SafeException.getUnsafePlaces()) + " but this should have been detected earlier."));
        }
    }

    private RunAndConditionMarking constructRun(Event<L, P> event, ConditionMarking<L, P> conditionMarking) throws PetriNetNot1SafeException {
        Object object;
        assert (event != this.mUnfolding.getDummyRoot());
        assert (!event.getPredecessorConditions().isEmpty());
        PetriNetRun petriNetRun = new PetriNetRun(conditionMarking.getMarking());
        ConditionMarking<L, P> conditionMarking2 = conditionMarking;
        for (Condition<L, P> serializable2 : event.getPredecessorConditions()) {
            if (conditionMarking2.contains(serializable2)) continue;
            object = this.constructRun(serializable2.getPredecessorEvent(), conditionMarking2);
            petriNetRun = petriNetRun.concatenate(((RunAndConditionMarking)object).mRunInner);
            conditionMarking2 = ((RunAndConditionMarking)object).mMarking;
        }
        assert (conditionMarking2 != null);
        ConditionMarking<L, P> conditionMarking3 = conditionMarking2.fireEvent(event);
        Transition<L, P> transition = event.getTransition();
        object = new PetriNetRun(conditionMarking2.getMarking(), transition, conditionMarking3.getMarking());
        petriNetRun = petriNetRun.concatenate(object);
        this.mLogger.debug((Object)("Event  : " + String.valueOf(event)));
        this.mLogger.debug((Object)("Marking: " + String.valueOf(petriNetRun.getMarking(petriNetRun.getWord().length()))));
        return new RunAndConditionMarking(petriNetRun, conditionMarking3);
    }

    @Override
    protected boolean checkRun(IPetriNet2FiniteAutomatonStateFactory<P> iPetriNet2FiniteAutomatonStateFactory, PetriNetRun<L, P> petriNetRun) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        boolean bl;
        this.mLogger.info((Object)"Testing correctness of emptinessCheck");
        if (!(this.mOperand instanceof IPetriNetTransitionProvider)) {
            this.mLogger.warn((Object)"Will not check Unfolding because operand is constructed on-demand");
            return true;
        }
        if (petriNetRun == null) {
            NestedRun nestedRun = new IsEmpty(this.mServices, new PetriNet2FiniteAutomaton(this.mServices, iPetriNet2FiniteAutomatonStateFactory, (IPetriNetTransitionProvider)this.mOperand).getResult()).getNestedRun();
            if (nestedRun != null) {
                bl = false;
                this.mLogger.error((Object)("EmptinessCheck says empty, but net accepts: " + String.valueOf(nestedRun.getWord())));
            }
            bl = nestedRun == null;
        } else {
            Word<L> word = petriNetRun.getWord();
            if (new Accepts(this.mServices, (IPetriNetTransitionProvider)this.mOperand, word).getResult().booleanValue()) {
                bl = true;
            } else {
                this.mLogger.error((Object)("Result of EmptinessCheck, but not accepted: " + String.valueOf(word)));
                bl = false;
            }
        }
        this.mLogger.info((Object)"Finished testing correctness of emptinessCheck");
        return bl;
    }

    public static enum EventOrderEnum {
        DBO("Depth-based Order"),
        ERV("Esparza R\u00f6mer Vogler"),
        KMM("Ken McMillan");

        private final String mDescription;

        private EventOrderEnum(String string2) {
            this.mDescription = string2;
        }

        public String getDescription() {
            return this.mDescription;
        }
    }

    class RunAndConditionMarking {
        private final PetriNetRun<L, P> mRunInner;
        private final ConditionMarking<L, P> mMarking;

        public RunAndConditionMarking(PetriNetRun<L, P> petriNetRun, ConditionMarking<L, P> conditionMarking) {
            this.mRunInner = petriNetRun;
            this.mMarking = conditionMarking;
        }
    }
}

