/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.Horn3Array;

final class Horn3ArrayBuilder {
    private static final int FALSEVAR = 0;
    private static final int TRUEVAR = 1;
    private static final int UNSET = 0;
    private static final int SETFALSE = 1;
    private static final int SETTRUE = 2;
    private Horn3Array mArray;
    private char[] mSingle;
    private boolean mSolveable;

    Horn3ArrayBuilder(int n) {
        this.mArray = new Horn3Array(n);
        this.mSingle = new char[n];
        this.mSolveable = true;
    }

    boolean solveable() {
        return this.mSolveable;
    }

    boolean isAlreadyFalse(int n) {
        return this.mSingle[n] == '\u0001';
    }

    void addClauseFalse(int n) {
        if (this.mSingle[n] == '\u0000') {
            this.mArray.add(1, n, 0);
            this.mSingle[n] = '\u0001';
        } else if (this.mSingle[n] == '\u0002') {
            this.mSolveable = false;
        }
    }

    void addClauseTrue(int n) {
        if (this.mSingle[n] == '\u0000') {
            this.mArray.add(1, 1, n);
            this.mSingle[n] = 2;
        } else if (this.mSingle[n] == '\u0001') {
            this.mSolveable = false;
        }
    }

    void addClauseFalseFalse(int n, int n2) {
        if (n > n2) {
            this.addClauseFalseFalse(n2, n);
        } else if (this.mSingle[n] != '\u0001') {
            if (this.mSingle[n] == '\u0002') {
                this.addClauseFalse(n2);
            } else if (this.mSingle[n2] != '\u0001') {
                if (this.mSingle[n2] == '\u0002') {
                    this.addClauseFalse(n);
                } else {
                    this.mArray.add(n, n2, 0);
                }
            }
        }
    }

    void addClauseFalseTrue(int n, int n2) {
        if (this.mSingle[n] != '\u0001') {
            if (this.mSingle[n] == '\u0002') {
                this.addClauseTrue(n2);
            } else if (this.mSingle[n2] == '\u0001') {
                this.addClauseFalse(n);
            } else if (this.mSingle[n2] != '\u0002') {
                this.mArray.add(1, n, n2);
            }
        }
    }

    void addClauseFalseFalseTrue(int n, int n2, int n3) {
        if (n > n2) {
            this.addClauseFalseFalseTrue(n2, n, n3);
        } else if (this.mSingle[n] != '\u0001') {
            if (this.mSingle[n] == '\u0002') {
                this.addClauseFalseTrue(n2, n3);
            } else if (this.mSingle[n2] != '\u0001') {
                if (this.mSingle[n2] == '\u0002') {
                    this.addClauseFalseTrue(n, n3);
                } else if (this.mSingle[n3] == '\u0001') {
                    this.addClauseFalseFalse(n, n2);
                } else if (this.mSingle[n3] != '\u0002') {
                    this.mArray.add(n, n2, n3);
                }
            }
        }
    }

    Horn3Array extract() {
        Horn3Array horn3Array = this.mSolveable ? this.mArray : null;
        this.mArray = null;
        this.mSingle = null;
        return horn3Array;
    }
}

