/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import java.util.HashMap;

public class PolymorphicFunctionSymbol
extends FunctionSymbolFactory {
    private final Sort[] mTypeParams;
    private final Sort[] mParamSorts;
    private final Sort mResultSort;
    private final int mFlags;

    PolymorphicFunctionSymbol(String string, Sort[] sortArray, Sort[] sortArray2, Sort sort, int n) {
        super(string);
        this.mTypeParams = sortArray;
        this.mParamSorts = sortArray2;
        this.mResultSort = sort;
        this.mFlags = n;
    }

    @Override
    public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
        return this.mFlags;
    }

    @Override
    public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
        if (stringArray != null) {
            return null;
        }
        if (sortArray.length != this.mParamSorts.length) {
            return null;
        }
        HashMap<Sort, Sort> hashMap = new HashMap<Sort, Sort>();
        int n = 0;
        while (n < sortArray.length) {
            if (!this.mParamSorts[n].unifySort(hashMap, sortArray[n])) {
                return null;
            }
            ++n;
        }
        if (sort != null) {
            if (!this.mResultSort.unifySort(hashMap, sort.getRealSort())) {
                return null;
            }
            return sort;
        }
        Sort[] sortArray2 = new Sort[this.mTypeParams.length];
        int n2 = 0;
        while (n2 < this.mTypeParams.length) {
            sortArray2[n2] = hashMap.get(this.mTypeParams[n2]);
            if (sortArray2[n2] == null) {
                return null;
            }
            ++n2;
        }
        return this.mResultSort.mapSort(sortArray2);
    }
}

