/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination;

import de.uni_freiburg.informatik.ultimate.lassoranker.AnalysisType;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.ITerminationAnalysisSettings;
import java.io.Serializable;

public class TerminationAnalysisSettings
implements Serializable,
ITerminationAnalysisSettings {
    private static final long serialVersionUID = 9183092457990345360L;
    private final AnalysisType mAnalysis;
    private final int mNumStrictInvariants;
    private final int mNumNonStrictInvariants;
    private final boolean mNonDecreasingInvariants;
    private final boolean mSimplifyTerminationArgument;
    private final boolean mSimplifySupportingInvariants;
    private final boolean mOverapproximateStem;

    public TerminationAnalysisSettings(ITerminationAnalysisSettings iTerminationAnalysisSettings) {
        this.mAnalysis = iTerminationAnalysisSettings.getAnalysis();
        this.mNumStrictInvariants = iTerminationAnalysisSettings.getNumStrictInvariants();
        this.mNumNonStrictInvariants = iTerminationAnalysisSettings.getNumNonStrictInvariants();
        this.mNonDecreasingInvariants = iTerminationAnalysisSettings.isNonDecreasingInvariants();
        this.mSimplifyTerminationArgument = iTerminationAnalysisSettings.isSimplifyTerminationArgument();
        this.mSimplifySupportingInvariants = iTerminationAnalysisSettings.isSimplifySupportingInvariants();
        this.mOverapproximateStem = iTerminationAnalysisSettings.isOverapproximateStem();
        assert (this.checkSanity());
    }

    private boolean checkSanity() {
        return this.mNumStrictInvariants >= 0 && this.mNumNonStrictInvariants >= 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Termination analysis: ");
        stringBuilder.append((Object)this.mAnalysis);
        stringBuilder.append("Number of strict supporting invariants: ");
        stringBuilder.append(this.mNumStrictInvariants);
        stringBuilder.append("Number of non-strict supporting invariants: ");
        stringBuilder.append(this.mNumNonStrictInvariants);
        stringBuilder.append("Consider only non-deceasing supporting invariants: ");
        stringBuilder.append(this.mNonDecreasingInvariants);
        stringBuilder.append("Simplify termination arguments: ");
        stringBuilder.append(this.mSimplifyTerminationArgument);
        stringBuilder.append("Simplify supporting invariants: ");
        stringBuilder.append(this.mSimplifySupportingInvariants);
        stringBuilder.append("Overapproximate stem: ");
        stringBuilder.append(this.mOverapproximateStem);
        return stringBuilder.toString();
    }

    @Override
    public AnalysisType getAnalysis() {
        return this.mAnalysis;
    }

    @Override
    public int getNumStrictInvariants() {
        return this.mNumStrictInvariants;
    }

    @Override
    public int getNumNonStrictInvariants() {
        return this.mNumNonStrictInvariants;
    }

    @Override
    public boolean isNonDecreasingInvariants() {
        return this.mNonDecreasingInvariants;
    }

    @Override
    public boolean isSimplifyTerminationArgument() {
        return this.mSimplifyTerminationArgument;
    }

    @Override
    public boolean isSimplifySupportingInvariants() {
        return this.mSimplifySupportingInvariants;
    }

    @Override
    public boolean isOverapproximateStem() {
        return this.mOverapproximateStem;
    }
}

