/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.IBuchiWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.automata.StateWa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.BuchiWaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.IStateWaComplement;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.SuccessorGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.SuccessorResult;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.UtilIntSet;

public class StateWaNCSB
extends StateWa
implements IStateWaComplement {
    private final NCSB mNCSB;
    private final IBuchiWa mOperand;
    private final BuchiWaComplement mComplement;
    private final IntSet mVisitedLetters = UtilIntSet.newIntSet();

    public StateWaNCSB(BuchiWaComplement buchiWaComplement, int n, NCSB nCSB) {
        super(n);
        this.mComplement = buchiWaComplement;
        this.mOperand = buchiWaComplement.getOperand();
        this.mNCSB = nCSB;
    }

    public NCSB getNCSB() {
        return this.mNCSB;
    }

    @Override
    public IBuchiWa getOperand() {
        return this.mOperand;
    }

    @Override
    public IBuchiWa getComplement() {
        return this.mComplement;
    }

    @Override
    public IntSet getSuccessors(int n) {
        if (this.mVisitedLetters.get(n)) {
            return super.getSuccessors(n);
        }
        this.mVisitedLetters.set(n);
        SuccessorResult successorResult = this.collectSuccessors(this.mNCSB.getBSet(), n, true);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet = successorResult.mSuccs;
        IntSet intSet2 = successorResult.mMinusFSuccs;
        IntSet intSet3 = successorResult.mInterFSuccs;
        IntSet intSet4 = this.mNCSB.copyCSet();
        intSet4.andNot(this.mNCSB.getBSet());
        successorResult = this.collectSuccessors(intSet4, n, !Options.lazyS);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet5 = successorResult.mSuccs;
        intSet5.or(intSet);
        intSet2.or(successorResult.mMinusFSuccs);
        intSet3.or(successorResult.mInterFSuccs);
        successorResult = this.collectSuccessors(this.mNCSB.getNSet(), n, false);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet6 = successorResult.mSuccs;
        successorResult = this.collectSuccessors(this.mNCSB.getSSet(), n, false);
        if (!successorResult.hasSuccessor) {
            return UtilIntSet.newIntSet();
        }
        IntSet intSet7 = successorResult.mSuccs;
        return this.computeSuccessors(new NCSB(intSet6, intSet5, intSet7, intSet), intSet2, intSet3, n);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StateWaNCSB stateWaNCSB = (StateWaNCSB)object;
        return this.mNCSB.equals(stateWaNCSB.mNCSB);
    }

    @Override
    public String toString() {
        return this.mNCSB.toString();
    }

    @Override
    public int hashCode() {
        return this.mNCSB.hashCode();
    }

    private boolean noTransitionAssertion_MinusF(int n, IntSet intSet) {
        return !this.mOperand.isFinal(n) && intSet.isEmpty();
    }

    private SuccessorResult collectSuccessors(IntSet intSet, int n, boolean bl) {
        SuccessorResult successorResult = new SuccessorResult();
        for (int n2 : intSet.iterable()) {
            IntSet intSet2 = this.mOperand.getSuccessors(n2, n);
            if (bl && this.noTransitionAssertion_MinusF(n2, intSet2)) {
                successorResult.hasSuccessor = false;
                return successorResult;
            }
            successorResult.mSuccs.or(intSet2);
            if (!bl) continue;
            if (this.mOperand.isFinal(n2)) {
                successorResult.mInterFSuccs.or(intSet2);
                continue;
            }
            successorResult.mMinusFSuccs.or(intSet2);
        }
        return successorResult;
    }

    private IntSet computeSuccessors(NCSB nCSB, IntSet intSet, IntSet intSet2, int n) {
        if (nCSB.getSSet().overlap(this.mOperand.getFinalStates()) || intSet.overlap(nCSB.getSSet())) {
            return UtilIntSet.newIntSet();
        }
        SuccessorGenerator successorGenerator = new SuccessorGenerator(this.mNCSB.getBSet().isEmpty(), nCSB, intSet, intSet2, this.mOperand.getFinalStates());
        IntSet intSet3 = UtilIntSet.newIntSet();
        while (successorGenerator.hasNext()) {
            NCSB nCSB2 = successorGenerator.next();
            if (nCSB2 == null) continue;
            StateWaNCSB stateWaNCSB = this.mComplement.addState(nCSB2);
            super.addSuccessor(n, stateWaNCSB.getId());
            intSet3.set(stateWaNCSB.getId());
        }
        return intSet3;
    }
}

