/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class SetConstraint<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final Set<ELEM> mLiterals;
    private final Set<ELEM> mNonLiterals;
    private final boolean mIsInconsistent;

    protected SetConstraint(boolean bl) {
        assert (bl) : "use other constructor for this case!";
        this.mLiterals = null;
        this.mNonLiterals = null;
        this.mIsInconsistent = true;
    }

    public boolean isSingleton() {
        return this.getElementSet().size() == 1;
    }

    public ELEM getSingletonValue() {
        assert (this.isSingleton());
        return (ELEM)((ICongruenceClosureElement)this.getElementSet().iterator().next());
    }

    protected SetConstraint(Set<ELEM> set, Set<ELEM> set2) {
        assert (set.stream().allMatch(ICongruenceClosureElement::isLiteral));
        assert (!set2.stream().anyMatch(ICongruenceClosureElement::isLiteral));
        this.mLiterals = Collections.unmodifiableSet(set);
        this.mNonLiterals = Collections.unmodifiableSet(set2);
        boolean bl = this.mIsInconsistent = set.isEmpty() && set2.isEmpty();
        assert (!this.mIsInconsistent) : "use other constructor, no?";
        assert (this.sanityCheck());
    }

    public Set<ELEM> getLiterals() {
        return Collections.unmodifiableSet(this.mLiterals);
    }

    public boolean expandVariableToLiterals(ELEM ELEM, Set<ELEM> set) {
        if (this.mNonLiterals.contains(ELEM)) {
            this.mNonLiterals.remove(ELEM);
            this.mLiterals.addAll(set);
            return true;
        }
        return false;
    }

    public boolean hasOnlyLiterals() {
        return this.mNonLiterals.isEmpty();
    }

    public boolean isInconsistent() {
        return this.mIsInconsistent || this.mLiterals.isEmpty() && this.mNonLiterals.isEmpty();
    }

    public Set<ELEM> getElementSet() {
        return DataStructureUtils.union(this.mLiterals, this.mNonLiterals);
    }

    public boolean containsElement(ELEM ELEM) {
        if (ELEM.isLiteral()) {
            return this.mLiterals != null && this.mLiterals.contains(ELEM);
        }
        return this.mNonLiterals != null && this.mNonLiterals.contains(ELEM);
    }

    public String toString() {
        return "SetConstraint " + String.valueOf(this.mLiterals) + " U " + String.valueOf(this.mNonLiterals);
    }

    public boolean sanityCheck() {
        if (!this.mLiterals.stream().allMatch(ICongruenceClosureElement::isLiteral)) {
            assert (false);
            return false;
        }
        if (this.mNonLiterals.stream().anyMatch(ICongruenceClosureElement::isLiteral)) {
            assert (false);
            return false;
        }
        if (this.getElementSet().size() >= 2) {
            Iterator<ELEM> iterator = this.getElementSet().iterator();
            ICongruenceClosureElement iCongruenceClosureElement = null;
            ICongruenceClosureElement iCongruenceClosureElement2 = (ICongruenceClosureElement)iterator.next();
            while (iterator.hasNext()) {
                iCongruenceClosureElement = iCongruenceClosureElement2;
                if (iCongruenceClosureElement.hasSameTypeAs(iCongruenceClosureElement2 = (ICongruenceClosureElement)iterator.next())) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean sanityCheck(SetConstraintConjunction<ELEM> setConstraintConjunction) {
        if (!this.sanityCheck()) {
            assert (false);
            return false;
        }
        if (setConstraintConjunction == null) {
            return true;
        }
        if (setConstraintConjunction.mSurroundingCCSetConstraints == null) {
            return true;
        }
        CongruenceClosure<ICongruenceClosureElement> congruenceClosure = setConstraintConjunction.getCongruenceClosure();
        if (congruenceClosure == null) {
            return true;
        }
        if (congruenceClosure.mLiteralSetConstraints == null) {
            return true;
        }
        if (!this.mLiterals.stream().allMatch(congruenceClosure::hasElement)) {
            assert (false);
            return false;
        }
        if (this.mNonLiterals.stream().anyMatch(iCongruenceClosureElement -> !congruenceClosure.isRepresentative((ICongruenceClosureElement)iCongruenceClosureElement))) {
            assert (false);
            return false;
        }
        for (ICongruenceClosureElement iCongruenceClosureElement2 : this.mNonLiterals) {
            Set set = congruenceClosure.getContainsConstraintForElement(iCongruenceClosureElement2);
            if (set == null || !SetConstraintConjunction.hasOnlyLiterals(set)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> boolean isTautological(ELEM ELEM, SetConstraint<ELEM> setConstraint) {
        return setConstraint.containsElement(ELEM);
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> SetConstraint<ELEM> getInconsistentSetConstraint() {
        return new SetConstraint<ELEM>(true);
    }

    public Set<ELEM> getNonLiterals() {
        return Collections.unmodifiableSet(this.mNonLiterals);
    }

    public int hashCode() {
        return Objects.hash(this.mIsInconsistent, this.mLiterals, this.mNonLiterals);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SetConstraint setConstraint = (SetConstraint)object;
        if (this.mIsInconsistent != setConstraint.mIsInconsistent) {
            return false;
        }
        if (this.mLiterals == null ? setConstraint.mLiterals != null : !this.mLiterals.equals(setConstraint.mLiterals)) {
            return false;
        }
        return !(this.mNonLiterals == null ? setConstraint.mNonLiterals != null : !this.mNonLiterals.equals(setConstraint.mNonLiterals));
    }
}

