/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.HistogramOfIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathProgramCache<LETTER> {
    private final ILogger mLogger;
    private Map<Set<LETTER>, Integer> mKnownPathPrograms;
    private List<Integer> mTraceHashes;

    public PathProgramCache(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mKnownPathPrograms = new HashMap<Set<LETTER>, Integer>();
        this.mTraceHashes = new ArrayList<Integer>();
    }

    public int addRun(Word<LETTER> word) {
        List list = word.asList();
        int n = list.hashCode();
        this.mTraceHashes.add(n);
        HashSet hashSet = new HashSet(list);
        Integer n2 = this.mKnownPathPrograms.get(hashSet);
        int n3 = n2 == null ? 1 : n2 + 1;
        this.mKnownPathPrograms.put(hashSet, n3);
        this.mLogger.info((Object)("Analyzing trace with hash " + n + ", now seen corresponding path program " + n3 + " times"));
        return n3;
    }

    public int getPathProgramCount(Word<LETTER> word) {
        Set set = word.asSet();
        Integer n = this.mKnownPathPrograms.get(set);
        if (n == null) {
            this.mLogger.warn((Object)"You did not report this counterexample before!");
            return 0;
        }
        return n;
    }

    public List<Integer> computeSortedHistrogram() {
        Integer[] integerArray = HistogramOfIterable.generateVisualizationArray(this.mKnownPathPrograms);
        return Collections.unmodifiableList(Arrays.asList(integerArray));
    }

    public void setPathProgramCount(Word<LETTER> word, int n) {
        Set set = word.asSet();
        this.mKnownPathPrograms.put(set, n);
    }

    public void copyProgramCache(PathProgramCache<LETTER> pathProgramCache) {
        this.mKnownPathPrograms = pathProgramCache.getKnownPathPrograms();
        this.mTraceHashes = pathProgramCache.getTraceHashes();
    }

    private List<Integer> getTraceHashes() {
        return this.mTraceHashes;
    }

    private Map<Set<LETTER>, Integer> getKnownPathPrograms() {
        return this.mKnownPathPrograms;
    }
}

