/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDecker;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Accepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class IsEmpty<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    protected final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected final Collection<STATE> mStartStates;
    protected final Collection<STATE> mGoalStates;
    protected final boolean mGoalStateIsAcceptingState;
    protected final Collection<STATE> mForbiddenStates;
    protected NestedRun<LETTER, STATE> mAcceptingRun;
    protected final Map<STATE, Set<STATE>> mVisitedPairs = new HashMap<STATE, Set<STATE>>();
    protected final Deque<DoubleDecker<STATE>> mQueue = new ArrayDeque<DoubleDecker<STATE>>();
    protected final Deque<DoubleDecker<STATE>> mQueueCall = new ArrayDeque<DoubleDecker<STATE>>();
    protected final Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>> mInternalSubRun = new HashMap<STATE, Map<STATE, NestedRun<LETTER, STATE>>>();
    protected final Map<STATE, Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>>> mCallSubRun = new HashMap<STATE, Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>>>();
    private final Map<STATE, Map<STATE, STATE>> mCallFirst = new HashMap<STATE, Map<STATE, STATE>>();
    protected final Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>> mReturnSubRun = new HashMap<STATE, Map<STATE, NestedRun<LETTER, STATE>>>();
    protected final Map<STATE, Map<STATE, STATE>> mReturnPredStateK = new HashMap<STATE, Map<STATE, STATE>>();
    protected final Map<STATE, Map<STATE, STATE>> mSummaryReturnPred = new HashMap<STATE, Map<STATE, STATE>>();
    protected final Map<STATE, Map<STATE, LETTER>> mSummaryReturnSymbol = new HashMap<STATE, Map<STATE, LETTER>>();
    protected final STATE mDummyEmptyStackState;
    protected final ArrayDeque<STATE> mReconstructionStack = new ArrayDeque();
    protected final SearchStrategy mStrategy;
    protected NestedRun<LETTER, STATE> mReconstructionOneStepRun;
    protected STATE mReconstructionPredK;

    public IsEmpty(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, SearchStrategy.BFS);
    }

    public IsEmpty(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, SearchStrategy searchStrategy) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, CoreUtil.constructHashSet(iNwaOutgoingLetterAndTransitionProvider.getInitialStates()), Collections.emptySet(), null, true, searchStrategy);
    }

    public IsEmpty(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Set<STATE> set, Set<STATE> set2, Set<STATE> set3) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNestedWordAutomaton, set, set2, set3, false, SearchStrategy.BFS);
        assert (iNestedWordAutomaton.getStates().containsAll(set)) : "unknown states";
        assert (iNestedWordAutomaton.getStates().containsAll(set3)) : "unknown states";
    }

    protected IsEmpty(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<STATE> set, Set<STATE> set2, Set<STATE> set3, boolean bl, SearchStrategy searchStrategy) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNwaOutgoingLetterAndTransitionProvider, set, set2, set3, bl, searchStrategy, false);
    }

    protected IsEmpty(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, Set<STATE> set, Set<STATE> set2, Set<STATE> set3, boolean bl, SearchStrategy searchStrategy, boolean bl2) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mDummyEmptyStackState = this.mOperand.getEmptyStackState();
        this.mStartStates = set;
        this.mGoalStateIsAcceptingState = bl;
        this.mGoalStates = set3;
        if (this.mGoalStateIsAcceptingState) {
            assert (this.mGoalStates == null) : "if we search accepting states, mGoalStates is null";
        } else assert (this.mGoalStates != null) : "mGoalStates must not be null";
        this.mForbiddenStates = set2;
        this.mStrategy = searchStrategy;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mAcceptingRun = bl2 ? null : this.getAcceptingRun();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    protected boolean isGoalState(STATE STATE) {
        if (this.mGoalStateIsAcceptingState) {
            return this.mOperand.isFinal(STATE);
        }
        return this.mGoalStates.contains(STATE);
    }

    protected void enqueueAndMarkVisited(STATE STATE, STATE STATE2) {
        DoubleDecker<STATE> doubleDecker = new DoubleDecker<STATE>(STATE2, STATE);
        this.mQueue.addLast(doubleDecker);
        this.markVisited(STATE, STATE2);
    }

    private void enqueueAndMarkVisitedCall(STATE STATE, STATE STATE2) {
        DoubleDecker<STATE> doubleDecker = new DoubleDecker<STATE>(STATE2, STATE);
        this.mQueueCall.addLast(doubleDecker);
        this.markVisited(STATE, STATE2);
    }

    protected DoubleDecker<STATE> dequeue() {
        return switch (this.mStrategy) {
            case SearchStrategy.BFS -> this.dequeueGivenQueues(this.mQueueCall, this.mQueue);
            case SearchStrategy.DFS -> this.dequeueGivenQueues(this.mQueue, this.mQueueCall);
            case SearchStrategy.PARALLEL -> throw new IllegalArgumentException(String.valueOf((Object)this.mStrategy) + " search strategy shouldbe handled by IsEmptyParallel");
            default -> throw new MatchException(null, null);
        };
    }

    private DoubleDecker<STATE> dequeueGivenQueues(Deque<DoubleDecker<STATE>> deque, Deque<DoubleDecker<STATE>> deque2) {
        if (!deque.isEmpty()) {
            return deque.removeFirst();
        }
        return deque2.removeFirst();
    }

    protected boolean isQueueEmpty() {
        return this.mQueue.isEmpty() && this.mQueueCall.isEmpty();
    }

    private void markVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisitedPairs.get(STATE);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mVisitedPairs.put(STATE, set);
        }
        set.add(STATE2);
    }

    protected boolean wasVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisitedPairs.get(STATE);
        if (set == null) {
            return false;
        }
        return set.contains(STATE2);
    }

    protected NestedRun<LETTER, STATE> getAcceptingRun() throws AutomataOperationCanceledException {
        for (Object object : this.mStartStates) {
            this.enqueueAndMarkVisited(object, this.mDummyEmptyStackState);
        }
        while (!this.isQueueEmpty()) {
            RunningTaskInfo runningTaskInfo;
            Object object;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object = "searching accepting run (input had " + this.mOperand.size() + " states)";
                runningTaskInfo = new RunningTaskInfo(this.getClass(), (String)object);
                throw new AutomataOperationCanceledException(runningTaskInfo);
            }
            object = this.dequeue();
            runningTaskInfo = ((DoubleDecker)object).getUp();
            Object STATE = ((DoubleDecker)object).getDown();
            if (this.isGoalState(runningTaskInfo)) {
                return this.constructRun(runningTaskInfo, STATE);
            }
            this.processSummaries(runningTaskInfo, STATE);
            this.getAcceptingRunHelperInternal(runningTaskInfo, STATE);
            this.getAcceptingRunHelperCall(runningTaskInfo, STATE);
            if (STATE == this.mOperand.getEmptyStackState()) continue;
            this.getAcceptingRunHelperReturn(runningTaskInfo, STATE);
        }
        return null;
    }

    protected void getAcceptingRunHelperInternal(STATE STATE, STATE STATE2) {
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            STATE STATE3 = outgoingInternalTransition.getSucc();
            if (this.mForbiddenStates.contains(STATE3) || this.wasVisited(STATE3, STATE2)) continue;
            this.addRunInformationInternal(STATE3, STATE2, LETTER, STATE, STATE2);
            this.enqueueAndMarkVisited(STATE3, STATE2);
        }
    }

    protected void getAcceptingRunHelperCall(STATE STATE, STATE STATE2) {
        for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            LETTER LETTER = outgoingCallTransition.getLetter();
            STATE STATE3 = outgoingCallTransition.getSucc();
            if (this.mForbiddenStates.contains(STATE3)) continue;
            this.addRunInformationCall(STATE3, STATE, LETTER, STATE, STATE2);
            if (this.wasVisited(STATE3, STATE)) continue;
            this.enqueueAndMarkVisitedCall(STATE3, STATE);
        }
    }

    protected void getAcceptingRunHelperReturn(STATE STATE, STATE STATE2) {
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessorsGivenHier(STATE, STATE2)) {
            LETTER LETTER = outgoingReturnTransition.getLetter();
            STATE STATE3 = outgoingReturnTransition.getSucc();
            if (this.mForbiddenStates.contains(STATE3)) continue;
            for (STATE STATE4 : this.getCallStatesOfCallState(STATE2)) {
                this.addSummary(STATE2, STATE3, STATE, LETTER);
                if (this.wasVisited(STATE3, STATE4)) continue;
                this.enqueueAndMarkVisited(STATE3, STATE4);
                this.addRunInformationReturn(STATE3, STATE4, LETTER, STATE, STATE2);
            }
        }
    }

    protected void processSummaries(STATE STATE, STATE STATE2) {
        if (this.mSummaryReturnPred.containsKey(STATE)) {
            assert (this.mSummaryReturnSymbol.containsKey(STATE));
            Map<STATE, STATE> map = this.mSummaryReturnPred.get(STATE);
            Map<STATE, LETTER> map2 = this.mSummaryReturnSymbol.get(STATE);
            for (Map.Entry<STATE, STATE> entry : map.entrySet()) {
                STATE STATE3 = entry.getKey();
                assert (map2.containsKey(STATE3));
                STATE STATE4 = entry.getValue();
                LETTER LETTER = map2.get(STATE3);
                if (this.wasVisited(STATE3, STATE2)) continue;
                this.enqueueAndMarkVisited(STATE3, STATE2);
                this.addRunInformationReturn(STATE3, STATE2, LETTER, STATE4, STATE);
            }
        }
    }

    private void addRunInformationInternal(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3, STATE STATE4) {
        Map<STATE, NestedRun<LETTER, STATE>> map = this.mInternalSubRun.get(STATE);
        if (map == null) {
            map = new HashMap<STATE, NestedRun<LETTER, STATE>>();
            this.mInternalSubRun.put(STATE, map);
        }
        assert (map.get(STATE2) == null);
        NestedRun<LETTER, STATE> nestedRun = new NestedRun<LETTER, STATE>(STATE3, LETTER, -2, STATE);
        map.put(STATE2, nestedRun);
    }

    private void addRunInformationCall(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3, STATE STATE4) {
        Map<STATE, NestedRun<LETTER, STATE>> map;
        assert (STATE3 == STATE2);
        Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>> map2 = this.mCallSubRun.get(STATE);
        Map<STATE, STATE> map3 = this.mCallFirst.get(STATE);
        if (map2 == null) {
            map2 = new HashMap<STATE, Map<STATE, NestedRun<LETTER, STATE>>>();
            this.mCallSubRun.put(STATE, map2);
            map3 = new HashMap<STATE, STATE>();
            this.mCallFirst.put(STATE, map3);
        }
        if (!map3.containsKey(STATE2)) {
            map3.put(STATE2, STATE4);
        }
        if ((map = map2.get(STATE2)) == null) {
            map = new HashMap<STATE, NestedRun<LETTER, STATE>>();
            map2.put(STATE2, map);
        }
        NestedRun<LETTER, STATE> nestedRun = new NestedRun<LETTER, STATE>(STATE3, LETTER, Integer.MAX_VALUE, STATE);
        map.put(STATE4, nestedRun);
    }

    protected void addRunInformationReturn(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3, STATE STATE4) {
        Map<STATE, NestedRun<LETTER, STATE>> map = this.mReturnSubRun.get(STATE);
        Map<STATE, STATE> map2 = this.mReturnPredStateK.get(STATE);
        if (map == null) {
            assert (map2 == null);
            map = new HashMap<STATE, NestedRun<LETTER, STATE>>();
            this.mReturnSubRun.put(STATE, map);
            map2 = new HashMap<STATE, STATE>();
            this.mReturnPredStateK.put(STATE, map2);
        }
        assert (!map.containsKey(STATE2));
        assert (!map2.containsKey(STATE2));
        NestedRun<LETTER, STATE> nestedRun = new NestedRun<LETTER, STATE>(STATE3, LETTER, Integer.MIN_VALUE, STATE);
        map.put(STATE2, nestedRun);
        map2.put(STATE2, STATE4);
    }

    protected Set<STATE> getCallStatesOfCallState(STATE STATE) {
        Set<STATE> set = this.mVisitedPairs.get(STATE);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    protected void addSummary(STATE STATE, STATE STATE2, STATE STATE3, LETTER LETTER) {
        Map<STATE, STATE> map = this.mSummaryReturnPred.get(STATE);
        Map<STATE, LETTER> map2 = this.mSummaryReturnSymbol.get(STATE);
        if (map == null) {
            assert (map2 == null);
            map = new HashMap<STATE, STATE>();
            this.mSummaryReturnPred.put(STATE, map);
            map2 = new HashMap<STATE, LETTER>();
            this.mSummaryReturnSymbol.put(STATE, map2);
        }
        if (!map.containsKey(STATE2)) {
            map.put(STATE2, STATE3);
            assert (!map2.containsKey(STATE2));
            map2.put(STATE2, LETTER);
        }
    }

    private NestedRun<LETTER, STATE> constructRun(STATE STATE, STATE STATE2) {
        STATE STATE3 = STATE;
        STATE STATE4 = STATE2;
        NestedRun nestedRun = new NestedRun(STATE3);
        while (!this.mStartStates.contains(STATE3) || !this.mReconstructionStack.isEmpty()) {
            if (!(this.computeInternalSubRun(STATE3, STATE4) || this.computeCallSubRun(STATE3, STATE4) || this.computeReturnSubRun(STATE3, STATE4))) {
                if (this.mLogger.isWarnEnabled()) {
                    this.mLogger.warn((Object)("No Run ending in pair " + String.valueOf(STATE3) + "  " + String.valueOf(STATE4) + " with reconstructionStack" + String.valueOf(this.mReconstructionStack)));
                }
                throw new AssertionError();
            }
            nestedRun = this.mReconstructionOneStepRun.concatenate(nestedRun);
            STATE3 = nestedRun.getStateAtPosition(0);
            STATE4 = this.mReconstructionPredK;
        }
        return nestedRun;
    }

    protected boolean computeInternalSubRun(STATE STATE, STATE STATE2) {
        NestedRun<LETTER, STATE> nestedRun;
        Map<STATE, NestedRun<LETTER, STATE>> map = this.mInternalSubRun.get(STATE);
        if (map != null && (nestedRun = map.get(STATE2)) != null) {
            this.mReconstructionOneStepRun = nestedRun;
            this.mReconstructionPredK = STATE2;
            return true;
        }
        return false;
    }

    protected boolean computeCallSubRun(STATE STATE, STATE STATE2) {
        Map<STATE, NestedRun<LETTER, STATE>> map;
        Map<STATE, Map<STATE, NestedRun<LETTER, STATE>>> map2 = this.mCallSubRun.get(STATE);
        if (map2 != null && (map = map2.get(STATE2)) != null) {
            if (this.mReconstructionStack.isEmpty()) {
                STATE STATE3 = this.mCallFirst.get(STATE).get(STATE2);
                this.mReconstructionPredK = STATE3;
                this.mReconstructionOneStepRun = map.get(STATE3);
                return true;
            }
            STATE STATE4 = this.mReconstructionStack.peek();
            if (map.containsKey(STATE4)) {
                this.mReconstructionOneStepRun = map.get(STATE4);
                this.mReconstructionPredK = STATE4;
                this.mReconstructionStack.pop();
                return true;
            }
        }
        return false;
    }

    protected boolean computeReturnSubRun(STATE STATE, STATE STATE2) {
        Map<STATE, NestedRun<LETTER, STATE>> map = this.mReturnSubRun.get(STATE);
        if (map != null) {
            Map<STATE, STATE> map2 = this.mReturnPredStateK.get(STATE);
            assert (map2 != null);
            NestedRun<LETTER, STATE> nestedRun = map.get(STATE2);
            STATE STATE3 = map2.get(STATE2);
            if (nestedRun != null) {
                this.mReconstructionStack.push(STATE2);
                this.mReconstructionOneStepRun = nestedRun;
                this.mReconstructionPredK = STATE3;
                return true;
            }
        }
        return false;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Boolean getResult() {
        if (this.mAcceptingRun == null) {
            return true;
        }
        return false;
    }

    public NestedRun<LETTER, STATE> getNestedRun() {
        return this.mAcceptingRun;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        boolean bl = true;
        if (this.mAcceptingRun == null) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"Emptiness not double checked ");
            }
        } else {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"Correctness of emptinessCheck not tested.");
            }
            bl = new Accepts<LETTER, STATE>(this.mServices, this.mOperand, this.mAcceptingRun.getWord()).getResult();
            if (this.mLogger.isInfoEnabled()) {
                this.mLogger.info((Object)"Finished testing correctness of emptinessCheck");
            }
        }
        return bl;
    }

    @Override
    public String exitMessage() {
        if (this.mAcceptingRun == null) {
            return "Finished " + this.getOperationName() + ". No accepting run.";
        }
        return "Finished " + this.getOperationName() + ". Found accepting run of length " + this.mAcceptingRun.getLength();
    }

    public static enum SearchStrategy {
        BFS,
        DFS,
        PARALLEL;

    }
}

