/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ReqEffectStore {
    private final Set<String> mEffectVars;
    private final Set<Integer> mEffectPhase = new HashSet<Integer>();
    private final Set<Integer> mOutputEffectPhase = new HashSet<Integer>();
    private final Set<Pair<Integer, Integer>> mEffectEdges;
    private final Set<Pair<Integer, Integer>> mOutputEffectEdges;

    public ReqEffectStore() {
        this.mEffectVars = new HashSet<String>();
        this.mEffectEdges = new HashSet<Pair<Integer, Integer>>();
        this.mOutputEffectEdges = new HashSet<Pair<Integer, Integer>>();
    }

    public void addEffectVars(Set<String> set) {
        this.mEffectVars.addAll(set);
    }

    public void addEffectPhaseIndex(Integer n) {
        this.mEffectPhase.add(n);
    }

    public void addOutputEffectPhaseIndex(Integer n) {
        this.mOutputEffectPhase.add(n);
    }

    public void addEffectEdgeIndex(Integer n, Integer n2) {
        this.mEffectEdges.add((Pair<Integer, Integer>)new Pair((Object)n, (Object)n2));
    }

    public void addOutputEffectEdgeIndex(Integer n, Integer n2) {
        this.mOutputEffectEdges.add((Pair<Integer, Integer>)new Pair((Object)n, (Object)n2));
    }

    public Set<String> getEffectVars() {
        return this.mEffectVars;
    }

    public boolean isEffectPhaseIndex(Integer n) {
        return this.mEffectPhase.contains(n);
    }

    public Set<Integer> getEffectPhaseIndexes() {
        return this.mEffectPhase;
    }

    public Set<Integer> getEffectEdgeSourceIndexes() {
        return this.mEffectEdges.stream().map(pair -> (Integer)pair.getFirst()).collect(Collectors.toSet());
    }

    public Set<Pair<Integer, Integer>> getEffectEdges() {
        return this.mEffectEdges;
    }

    public boolean isOutputEffectPhaseIndex(Integer n) {
        return this.mOutputEffectPhase.contains(n);
    }

    public Set<Integer> getOutputEffectPhaseIndex() {
        return this.mOutputEffectPhase;
    }

    public Set<Pair<Integer, Integer>> getOutputEffectEdges() {
        return this.mOutputEffectEdges;
    }

    public boolean isEffectEdge(Integer n, Integer n2) {
        return this.mEffectEdges.contains(new Pair((Object)n, (Object)n2));
    }

    public boolean isOutputEffectEdge(Integer n, Integer n2) {
        return this.mOutputEffectEdges.contains(new Pair((Object)n, (Object)n2));
    }
}

