/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Totalize;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.performance.SinkMergeIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.DisjointSets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Minimize<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final TreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final SinkMergeIntersectStateFactory<STATE> mStateFactory;
    protected final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final Map<Set<STATE>, STATE> mMinimizedStates;
    private final ITreeAutomatonBU<LETTER, STATE> mOperand;

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Minimize(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iTreeAutomatonBU;
        try {
            this.mTreeAutomaton = (TreeAutomatonBU)new Totalize<LETTER, STATE>(automataLibraryServices, SF, iTreeAutomatonBU).getResult();
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            automataOperationCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "minimizing tree automaton"));
            throw automataOperationCanceledException;
        }
        this.mStateFactory = new SinkMergeIntersectStateFactory<STATE>(SF, SF, (IIntersectionStateFactory)SF);
        this.mMinimizedStates = new HashMap<Set<STATE>, STATE>();
        this.mResult = this.computeResult();
    }

    private STATE minimize(Set<STATE> set) {
        if (!this.mMinimizedStates.containsKey(set)) {
            this.mMinimizedStates.put(set, this.mStateFactory.merge(set));
        }
        return this.mMinimizedStates.get(set);
    }

    @Override
    public String startMessage() {
        return "Starting " + this.getOperationName();
    }

    @Override
    public String exitMessage() {
        return "Exiting " + this.getOperationName();
    }

    private boolean replacable(STATE STATE, STATE STATE2, TreeAutomatonRule<LETTER, STATE> treeAutomatonRule, DisjointSets<STATE> disjointSets) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>(treeAutomatonRule.getSource());
        int n = 0;
        while (n < arrayList.size()) {
            if (arrayList.get(n) == STATE) {
                ArrayList arrayList2 = (ArrayList)arrayList.clone();
                arrayList2.set(n, STATE2);
                for (STATE STATE3 : this.mTreeAutomaton.getSuccessors(arrayList2, treeAutomatonRule.getLetter())) {
                    if (!disjointSets.equiv(STATE3, treeAutomatonRule.getDest())) continue;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean replacable(STATE STATE, STATE STATE2, DisjointSets<STATE> disjointSets) {
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mTreeAutomaton.getRulesBySource(STATE)) {
            if (this.replacable(STATE, STATE2, treeAutomatonRule, disjointSets)) continue;
            return false;
        }
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mTreeAutomaton.getRulesBySource(STATE2)) {
            if (this.replacable(STATE2, STATE, treeAutomatonRule, disjointSets)) continue;
            return false;
        }
        return true;
    }

    private ITreeAutomatonBU<LETTER, STATE> computeResult() {
        Object object;
        Object object222;
        DisjointSets disjointSets = new DisjointSets(this.mTreeAutomaton.getStates());
        Object object3 = null;
        Object object4 = null;
        for (Object object222 : this.mTreeAutomaton.getStates()) {
            if (this.mTreeAutomaton.isFinalState((DisjointSets)object222)) {
                if (object3 == null) {
                    object3 = object222;
                    continue;
                }
                disjointSets.union(object3, object222);
                continue;
            }
            if (object4 == null) {
                object4 = object222;
                continue;
            }
            disjointSets.union(object4, object222);
        }
        do {
            object222 = disjointSets;
            disjointSets = new DisjointSets(this.mTreeAutomaton.getStates());
            object = object222.getParitionsIterator();
            while (object.hasNext()) {
                Set object5 = (Set)object.next();
                Iterator<TreeAutomatonRule<LETTER, STATE>> iterator = new ArrayList();
                Iterator iterator2 = object5.iterator();
                while (iterator2.hasNext()) {
                    ((ArrayList)((Object)iterator)).add((TreeAutomatonRule<LETTER, STATE>)iterator2.next());
                }
                int n = 0;
                while (n < ((ArrayList)((Object)iterator)).size()) {
                    Object object2 = ((ArrayList)((Object)iterator)).get(n);
                    int n2 = 0;
                    while (n2 < n) {
                        Object e = ((ArrayList)((Object)iterator)).get(n2);
                        if (!object222.equiv(object2, e) && this.replacable((STATE)object2, (STATE)e, (DisjointSets<STATE>)object222)) {
                            disjointSets.union(object2, e);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        } while (!disjointSets.equals(object222));
        object = new TreeAutomatonBU();
        for (Object e : this.mTreeAutomaton.getStates()) {
            ((TreeAutomatonBU)object).addState(this.minimize(disjointSets.getPartition(e)));
            if (!this.mTreeAutomaton.isFinalState(e)) continue;
            ((TreeAutomatonBU)object).addFinalState(this.minimize(disjointSets.getPartition(e)));
        }
        for (TreeAutomatonRule<LETTER, STATE> treeAutomatonRule : this.mTreeAutomaton.getRules()) {
            ArrayList<STATE> arrayList = new ArrayList<STATE>();
            for (Object object2 : treeAutomatonRule.getSource()) {
                arrayList.add(this.minimize(disjointSets.getPartition(object2)));
            }
            ((TreeAutomatonBU)object).addRule(new TreeAutomatonRule(treeAutomatonRule.getLetter(), arrayList, this.minimize(disjointSets.getPartition(treeAutomatonRule.getDest()))));
        }
        return this.removeUnreachables((TreeAutomatonBU<LETTER, STATE>)object);
    }

    private ITreeAutomatonBU<LETTER, STATE> removeUnreachables(TreeAutomatonBU<LETTER, STATE> treeAutomatonBU) {
        TreeAutomatonBU<Object, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>> treeAutomatonBU2 = new TreeAutomatonBU<Object, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>();
        HashSet<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>> hashSet = new HashSet<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>();
        HashSet<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>> hashSet2 = new HashSet<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>();
        do {
            hashSet2.addAll(hashSet);
            for (TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>> object2 : treeAutomatonBU.getRules()) {
                boolean bl = true;
                for (Map<LETTER, Iterable<List<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>>> map : object2.getSource()) {
                    if (hashSet2.contains(map)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                hashSet.add(object2.getDest());
            }
        } while (!hashSet.equals(hashSet2));
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet.clear();
        hashSet2.clear();
        for (Object e : hashSet3) {
            if (!treeAutomatonBU.isFinalState(e)) continue;
            hashSet.add((Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>)e);
        }
        do {
            hashSet2.addAll(hashSet);
            for (Object e : hashSet2) {
                Map<LETTER, Iterable<List<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>>> map;
                map = treeAutomatonBU.getPredecessors(e);
                for (Object object : map.keySet()) {
                    for (List<Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>> list : map.get(object)) {
                        boolean bl = true;
                        for (Object object2 : list) {
                            if (hashSet3.contains(object2)) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        treeAutomatonBU2.addRule(new TreeAutomatonRule<Object, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>>(object, list, e));
                        hashSet.addAll(list);
                    }
                }
            }
        } while (!hashSet.equals(hashSet2));
        for (Object e : hashSet) {
            if (!hashSet3.contains(e)) continue;
            treeAutomatonBU2.addState((Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>)e);
            if (!treeAutomatonBU.isFinalState(e)) continue;
            treeAutomatonBU2.addFinalState((Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, Iterator<TreeAutomatonRule<LETTER, STATE>>>>>>)e);
        }
        return treeAutomatonBU2;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        IsEquivalent<LETTER, STATE> isEquivalent = new IsEquivalent<LETTER, STATE>(this.mServices, this.mStateFactory, this.mOperand, this.mResult);
        boolean bl = isEquivalent.getResult();
        if (!bl && this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Counterexample: " + String.valueOf(isEquivalent.getCounterexample().get())));
        }
        return bl;
    }
}

